/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network.fabric;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.shiroha233.roadweaver.client.map.MapDataCollector;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.client.map.RoadMapScreen;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.MapSnapshotCodec;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.util.ComputeService;

public class MapNetworkFabric {
    public static final class_2960 REQ_RECT = new class_2960("roadweaver", "map_request_rect");
    public static final class_2960 SNAP = new class_2960("roadweaver", "map_snapshot");
    public static final class_2960 TP_REQ = new class_2960("roadweaver", "map_teleport");
    public static final class_2960 TP_ACK = new class_2960("roadweaver", "map_teleport_ack");
    public static final class_2960 MAN_REQ = new class_2960("roadweaver", "map_manual_connect");

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQ_RECT, (server, player, handler, buf, responseSender) -> {
            int radiusChunks;
            int minX = buf.method_10816();
            int minZ = buf.method_10816();
            int maxX = buf.method_10816();
            int maxZ = buf.method_10816();
            class_3222 sp = player;
            int cx = (int)Math.round(sp.method_23317());
            int cz = (int)Math.round(sp.method_23321());
            try {
                ModConfig cfg = ConfigService.get();
                radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
            }
            catch (Throwable t) {
                radiusChunks = 256;
            }
            int radiusBlocks = Math.max(1, radiusChunks) * 16;
            CompletableFuture.supplyAsync(() -> {
                MapSnapshot snapshot = MapDataCollector.build(sp.method_51469(), minX, minZ, maxX, maxZ, cx, cz, radiusBlocks);
                class_2540 out = new class_2540(Unpooled.buffer());
                MapSnapshotCodec.write(out, snapshot);
                return out;
            }, ComputeService.executor()).thenAccept(out -> server.execute(() -> ServerPlayNetworking.send((class_3222)sp, (class_2960)SNAP, (class_2540)out)));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TP_REQ, (server, player, handler, buf, responseSender) -> {
            int x = buf.method_10816();
            buf.method_10816();
            int z = buf.method_10816();
            server.execute(() -> {
                boolean allowed;
                class_3222 sp = player;
                boolean bl = allowed = sp.method_7337() || sp.method_5687(2);
                if (!allowed) {
                    class_2540 out = new class_2540(Unpooled.buffer());
                    out.writeBoolean(false);
                    ServerPlayNetworking.send((class_3222)sp, (class_2960)TP_ACK, (class_2540)out);
                    return;
                }
                class_3218 level = sp.method_51469();
                level.method_8497(x >> 4, z >> 4);
                int ty = level.method_8624(class_2902.class_2903.field_13203, x, z);
                ty = ty <= level.method_31607() ? level.method_8615() + 1 : ++ty;
                sp.method_14251(level, (double)x + 0.5, (double)ty, (double)z + 0.5, sp.method_36454(), sp.method_36455());
                class_2540 out = new class_2540(Unpooled.buffer());
                out.writeBoolean(true);
                out.method_10804(x);
                out.method_10804(ty);
                out.method_10804(z);
                ServerPlayNetworking.send((class_3222)sp, (class_2960)TP_ACK, (class_2540)out);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MAN_REQ, (server, player, handler, buf, responseSender) -> {
            int ax = buf.method_10816();
            int az = buf.method_10816();
            int bx = buf.method_10816();
            int bz = buf.method_10816();
            server.execute(() -> {
                class_3222 sp = player;
                if (sp == null) {
                    return;
                }
                class_3218 level = sp.method_51469();
                WorldDataProvider provider = WorldDataProvider.getInstance();
                List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> list = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                class_2338 a = new class_2338(ax, 0, az);
                class_2338 b = new class_2338(bx, 0, bz);
                boolean exists = false;
                for (Records.StructureConnection c : list) {
                    class_2338 f = c.from();
                    class_2338 t = c.to();
                    if ((!f.equals((Object)a) || !t.equals((Object)b)) && (!f.equals((Object)b) || !t.equals((Object)a))) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    list.add(new Records.StructureConnection(a, b, Records.ConnectionStatus.PLANNED));
                    provider.setStructureConnections(level, list);
                }
            });
        });
    }

    public static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SNAP, (client, handler, buf, responseSender) -> {
            MapSnapshot s = MapSnapshotCodec.read(buf);
            client.execute(() -> {
                class_437 patt6038$temp = client.field_1755;
                if (patt6038$temp instanceof RoadMapScreen) {
                    RoadMapScreen screen = (RoadMapScreen)patt6038$temp;
                    screen.setSnapshot(s);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TP_ACK, (client, handler, buf, responseSender) -> {
            boolean ok = buf.readBoolean();
            int rx = 0;
            int ry = 0;
            int rz = 0;
            if (ok) {
                rx = buf.method_10816();
                ry = buf.method_10816();
                rz = buf.method_10816();
            }
            int fx = rx;
            int fy = ry;
            int fz = rz;
            client.execute(() -> {
                if (client.field_1724 == null) {
                    return;
                }
                if (ok) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"gui.roadweaver.map.teleport.success_pos", (Object[])new Object[]{fx, fy, fz}), true);
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"gui.roadweaver.map.teleport.denied"), true);
                }
            });
        });
    }

    public static void requestSnapshot(int minX, int minZ, int maxX, int maxZ) {
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10804(minX);
        out.method_10804(minZ);
        out.method_10804(maxX);
        out.method_10804(maxZ);
        ClientPlayNetworking.send((class_2960)REQ_RECT, (class_2540)out);
    }

    public static void requestTeleport(int x, int y, int z) {
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10804(x);
        out.method_10804(y);
        out.method_10804(z);
        ClientPlayNetworking.send((class_2960)TP_REQ, (class_2540)out);
    }

    public static void requestManualConnect(int ax, int az, int bx, int bz) {
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10804(ax);
        out.method_10804(az);
        out.method_10804(bx);
        out.method_10804(bz);
        ClientPlayNetworking.send((class_2960)MAN_REQ, (class_2540)out);
    }
}

