/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.planning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_2338;
import net.shiroha233.roadweaver.helpers.Records;

public final class KNNPlanner {
    private KNNPlanner() {
    }

    public static List<Records.StructureConnection> planKNN(List<class_2338> points, int k, int maxEdgeLenBlocks) {
        return KNNPlanner.planKNN(points, k, maxEdgeLenBlocks, 2.5, 25.0, 3);
    }

    public static List<Records.StructureConnection> planKNN(List<class_2338> points, int k, int maxEdgeLenBlocks, double alpha, double minAngleDeg) {
        return KNNPlanner.planKNN(points, k, maxEdgeLenBlocks, alpha, minAngleDeg, 3);
    }

    public static List<Records.StructureConnection> planKNN(List<class_2338> points, int k, int maxEdgeLenBlocks, double alpha, double minAngleDeg, int degreeCap) {
        int i;
        int j;
        class_2338 a;
        if (points == null || points.size() < 2 || k <= 0) {
            return List.of();
        }
        int n = points.size();
        long maxDist2 = maxEdgeLenBlocks > 0 ? (long)maxEdgeLenBlocks * (long)maxEdgeLenBlocks : Long.MAX_VALUE;
        double minCos = Math.cos(Math.toRadians(Math.max(0.0, Math.min(89.0, minAngleDeg))));
        int degCap = Math.max(1, degreeCap);
        HashSet<Long> edgeKeys = new HashSet<Long>();
        ArrayList<Records.StructureConnection> edges = new ArrayList<Records.StructureConnection>();
        long[] nn2 = new long[n];
        for (int i2 = 0; i2 < n; ++i2) {
            long best = Long.MAX_VALUE;
            a = points.get(i2);
            for (j = 0; j < n; ++j) {
                long d2;
                if (i2 == j || (d2 = KNNPlanner.dist2(a, points.get(j))) >= best) continue;
                best = d2;
            }
            nn2[i2] = best;
        }
        ArrayList adj = new ArrayList(n);
        for (i = 0; i < n; ++i) {
            adj.add(new ArrayList());
        }
        for (i = 0; i < n; ++i) {
            ArrayList<Neighbor> cand = new ArrayList<Neighbor>();
            a = points.get(i);
            for (j = 0; j < n; ++j) {
                class_2338 b;
                long d2;
                if (i == j || (d2 = KNNPlanner.dist2(a, b = points.get(j))) > maxDist2 || !(alpha <= 0.0) && !((double)d2 <= alpha * alpha * (double)Math.max(1L, Math.max(nn2[i], nn2[j])))) continue;
                cand.add(new Neighbor(j, d2));
            }
            cand.sort((p, q) -> Long.compare(p.d2, q.d2));
            int limit = Math.min(k, cand.size());
            for (int t = 0; t < limit; ++t) {
                int bIdx;
                int aIdx;
                long key;
                int j2 = ((Neighbor)cand.get((int)t)).idx;
                if (!KNNPlanner.gabrielOk(points, i, j2, cand) || ((List)adj.get(i)).size() >= degCap || ((List)adj.get(j2)).size() >= degCap || !KNNPlanner.angleOk(points, (List)adj.get(i), i, j2, minCos)) continue;
                if (!KNNPlanner.angleOk(points, (List)adj.get(j2), j2, i, minCos)) {
                    // empty if block
                }
                if (!edgeKeys.add(key = (long)(aIdx = Math.min(i, j2)) << 32 ^ (long)(bIdx = Math.max(i, j2)))) continue;
                edges.add(new Records.StructureConnection(points.get(aIdx), points.get(bIdx)));
                ((List)adj.get(i)).add(j2);
                ((List)adj.get(j2)).add(i);
            }
        }
        return edges;
    }

    private static long dist2(class_2338 a, class_2338 b) {
        long dx = (long)a.method_10263() - (long)b.method_10263();
        long dz = (long)a.method_10260() - (long)b.method_10260();
        return dx * dx + dz * dz;
    }

    private static boolean angleOk(List<class_2338> pts, List<Integer> neighbors, int i, int j, double minCos) {
        long abz;
        if (neighbors.isEmpty()) {
            return true;
        }
        class_2338 a = pts.get(i);
        class_2338 b = pts.get(j);
        long abx = (long)b.method_10263() - (long)a.method_10263();
        double abLen = Math.hypot(abx, abz = (long)b.method_10260() - (long)a.method_10260());
        if (abLen == 0.0) {
            return false;
        }
        double abxN = (double)abx / abLen;
        double abzN = (double)abz / abLen;
        for (int nb : neighbors) {
            double aczN;
            double acxN;
            double cos;
            long acz;
            class_2338 c = pts.get(nb);
            long acx = (long)c.method_10263() - (long)a.method_10263();
            double acLen = Math.hypot(acx, acz = (long)c.method_10260() - (long)a.method_10260());
            if (acLen == 0.0 || !((cos = abxN * (acxN = (double)acx / acLen) + abzN * (aczN = (double)acz / acLen)) > minCos)) continue;
            return false;
        }
        return true;
    }

    private static boolean gabrielOk(List<class_2338> pts, int i, int j, List<Neighbor> local) {
        class_2338 a = pts.get(i);
        class_2338 b = pts.get(j);
        long ab2 = KNNPlanner.dist2(a, b);
        for (Neighbor nb : local) {
            class_2338 c;
            long s;
            int k = nb.idx;
            if (k == i || k == j || (s = KNNPlanner.dist2(a, c = pts.get(k)) + KNNPlanner.dist2(b, c)) > ab2) continue;
            return false;
        }
        return true;
    }

    public static List<Records.StructureConnection> connectComponents(List<class_2338> points, List<Records.StructureConnection> base, int maxJoinLenBlocks, double minAngleDeg, int degreeCap) {
        int n;
        int n2 = n = points != null ? points.size() : 0;
        if (n < 2) {
            return List.of();
        }
        long maxD2 = maxJoinLenBlocks > 0 ? (long)maxJoinLenBlocks * (long)maxJoinLenBlocks : Long.MAX_VALUE;
        double minCos = Math.cos(Math.toRadians(Math.max(0.0, Math.min(89.0, minAngleDeg))));
        ArrayList adj = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            adj.add(new ArrayList());
        }
        final int[] parent = new int[n];
        for (int i = 0; i < n; ++i) {
            parent[i] = i;
        }
        HashMap<class_2338, Integer> index = new HashMap<class_2338, Integer>(n * 2);
        for (int i = 0; i < n; ++i) {
            index.put(points.get(i), i);
        }
        IntUnaryOperator find = new IntUnaryOperator(){

            @Override
            public int applyAsInt(int x) {
                while (parent[x] != x) {
                    parent[x] = parent[parent[x]];
                    x = parent[x];
                }
                return x;
            }
        };
        BiConsumer<Integer, Integer> unite = (a, b) -> {
            int rb;
            int ra = find.applyAsInt((int)a);
            if (ra != (rb = find.applyAsInt((int)b))) {
                parent[rb] = ra;
            }
        };
        HashSet<Long> keys = new HashSet<Long>();
        if (base != null) {
            for (Records.StructureConnection c : base) {
                Integer ia = (Integer)index.get(c.from());
                Integer ib = (Integer)index.get(c.to());
                if (ia == null || ib == null) continue;
                int a2 = Math.min(ia, ib);
                int b2 = Math.max(ia, ib);
                long key = (long)a2 << 32 ^ (long)b2;
                keys.add(key);
                unite.accept(ia, ib);
                ((List)adj.get(ia)).add(ib);
                ((List)adj.get(ib)).add(ia);
            }
        }
        class Pair {
            int a;
            int b;
            long d2;

            Pair(int a, int b, long d2) {
                this.a = a;
                this.b = b;
                this.d2 = d2;
            }
        }
        ArrayList<Pair> cand = new ArrayList<Pair>();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                long d2;
                if (find.applyAsInt(i) == find.applyAsInt(j) || (d2 = KNNPlanner.dist2(points.get(i), points.get(j))) > maxD2) continue;
                cand.add(new Pair(i, j, d2));
            }
        }
        cand.sort((p, q) -> Long.compare(p.d2, q.d2));
        ArrayList<Records.StructureConnection> added = new ArrayList<Records.StructureConnection>();
        for (Pair p2 : cand) {
            int b3;
            int a3;
            long key;
            int rb;
            int ra = find.applyAsInt(p2.a);
            if (ra == (rb = find.applyAsInt(p2.b)) || ((List)adj.get(p2.a)).size() >= degreeCap || ((List)adj.get(p2.b)).size() >= degreeCap || !KNNPlanner.angleOk(points, (List)adj.get(p2.a), p2.a, p2.b, minCos)) continue;
            if (!KNNPlanner.angleOk(points, (List)adj.get(p2.b), p2.b, p2.a, minCos)) {
                // empty if block
            }
            if (!keys.add(key = (long)(a3 = Math.min(p2.a, p2.b)) << 32 ^ (long)(b3 = Math.max(p2.a, p2.b)))) continue;
            added.add(new Records.StructureConnection(points.get(a3), points.get(b3)));
            ((List)adj.get(p2.a)).add(p2.b);
            ((List)adj.get(p2.b)).add(p2.a);
            unite.accept(p2.a, p2.b);
        }
        return added;
    }

    private static final class Neighbor {
        final int idx;
        final long d2;

        Neighbor(int idx, long d2) {
            this.idx = idx;
            this.d2 = d2;
        }
    }
}

