/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5742;
import net.minecraft.class_6862;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_7057;
import net.minecraft.class_7059;
import net.minecraft.class_7138;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import net.shiroha233.roadweaver.helpers.Records;

public final class StructurePredictor {
    private StructurePredictor() {
    }

    public static List<Records.StructureInfo> predictOverworldVillagesAroundSpawn(class_3218 level, int radiusChunks, boolean biomePrefilter) {
        class_5455 registryAccess = level.method_30349();
        class_2378 setRegistry = registryAccess.method_30530(class_7924.field_41248);
        Optional optVillages = setRegistry.method_40264(class_7057.field_37146);
        if (optVillages.isEmpty()) {
            return List.of();
        }
        class_7059 set = (class_7059)((class_6880.class_6883)optVillages.get()).comp_349();
        class_6874 placement = set.comp_511();
        if (!(placement instanceof class_6872)) {
            return List.of();
        }
        class_6872 rssp = (class_6872)placement;
        class_2338 spawn = level.method_43126();
        int cx = spawn.method_10263() >> 4;
        int cz = spawn.method_10260() >> 4;
        int minX = cx - radiusChunks;
        int maxX = cx + radiusChunks;
        int minZ = cz - radiusChunks;
        int maxZ = cz + radiusChunks;
        class_7869 state = level.method_14178().method_46642();
        class_7138 randomState = state.method_46713();
        class_1966 biomeSource = level.method_14178().method_12129().method_12098();
        HashSet<class_6880> allowedBiomes = null;
        if (biomePrefilter) {
            allowedBiomes = new HashSet<class_6880>();
            for (class_7059.class_7060 entry : set.comp_510()) {
                class_3195 structure = (class_3195)entry.comp_512().comp_349();
                for (class_6880 b : structure.method_41607()) {
                    allowedBiomes.add(b);
                }
            }
        }
        int spacing = rssp.method_41632();
        int startI = Math.floorDiv(minX, spacing);
        int endI = Math.floorDiv(maxX, spacing);
        int startJ = Math.floorDiv(minZ, spacing);
        int endJ = Math.floorDiv(maxZ, spacing);
        long seed = level.method_8412();
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (int i = startI; i <= endI; ++i) {
            for (int j = startJ; j <= endJ; ++j) {
                int qz;
                int qy;
                int qx;
                class_6880 sample;
                int baseX = i * spacing;
                int baseZ = j * spacing;
                class_1923 candidate = rssp.method_40169(seed, baseX, baseZ);
                int x = candidate.field_9181;
                int z = candidate.field_9180;
                if (x < minX || x > maxX || z < minZ || z > maxZ || !placement.method_41639(state, x, z)) continue;
                class_2338 locatePos = placement.method_41636(candidate);
                if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample = biomeSource.method_38109(qx = class_5742.method_33100((int)locatePos.method_10263()), qy = class_5742.method_33100((int)64), qz = class_5742.method_33100((int)locatePos.method_10260()), randomState.method_42371()))) continue;
                result.add(new Records.StructureInfo(locatePos, "village"));
            }
        }
        return result;
    }

    public static List<Records.StructureInfo> predictOverworldStructuresInRect(class_3218 level, int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, boolean biomePrefilter, List<String> whitelist, List<String> blacklist) {
        class_5455 access = level.method_30349();
        class_2378 setRegistry = access.method_30530(class_7924.field_41248);
        class_7869 state = level.method_14178().method_46642();
        class_7138 randomState = state.method_46713();
        class_1966 biomeSource = level.method_14178().method_12129().method_12098();
        Filters filters = Filters.of(whitelist, blacklist);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (class_6880.class_6883 holder : setRegistry.method_40270().toList()) {
            class_2960 id;
            Object key;
            class_6880 structureHolder;
            class_7059 set = (class_7059)holder.comp_349();
            class_6874 placement = set.comp_511();
            if (!(placement instanceof class_6872)) continue;
            class_6872 rssp = (class_6872)placement;
            ArrayList<class_6880> matchedStructures = new ArrayList<class_6880>();
            for (Object entry : set.comp_510()) {
                structureHolder = entry.comp_512();
                key = structureHolder.method_40230();
                if (((Optional)key).isEmpty() || !filters.matches((class_6880<class_3195>)structureHolder, id = ((class_5321)((Optional)key).get()).method_29177())) continue;
                matchedStructures.add(structureHolder);
            }
            if (matchedStructures.isEmpty()) {
                if (filters.hasWhitelist()) continue;
                for (Object entry : set.comp_510()) {
                    structureHolder = entry.comp_512();
                    key = structureHolder.method_40230();
                    if (((Optional)key).isEmpty() || filters.isBlacklisted((class_6880<class_3195>)structureHolder, id = ((class_5321)((Optional)key).get()).method_29177())) continue;
                    matchedStructures.add(structureHolder);
                }
                if (matchedStructures.isEmpty()) continue;
            }
            HashSet<class_6880> allowedBiomes = null;
            if (biomePrefilter) {
                Object entry;
                allowedBiomes = new HashSet<class_6880>();
                entry = matchedStructures.iterator();
                while (entry.hasNext()) {
                    class_6880 h2 = (class_6880)entry.next();
                    for (class_6880 b : ((class_3195)h2.comp_349()).method_41607()) {
                        allowedBiomes.add(b);
                    }
                }
            }
            int spacing = rssp.method_41632();
            int startI = Math.floorDiv(minChunkX, spacing);
            int endI = Math.floorDiv(maxChunkX, spacing);
            int startJ = Math.floorDiv(minChunkZ, spacing);
            int endJ = Math.floorDiv(maxChunkZ, spacing);
            String labelId = matchedStructures.stream().map(h -> h.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("structure")).findFirst().orElse("structure");
            for (int i = startI; i <= endI; ++i) {
                for (int j = startJ; j <= endJ; ++j) {
                    int baseX = i * spacing;
                    int baseZ = j * spacing;
                    class_1923 candidate = rssp.method_40169(level.method_8412(), baseX, baseZ);
                    int x = candidate.field_9181;
                    int z = candidate.field_9180;
                    if (x < minChunkX || x > maxChunkX || z < minChunkZ || z > maxChunkZ || !placement.method_41639(state, x, z)) continue;
                    class_2338 locatePos = placement.method_41636(candidate);
                    int qx = class_5742.method_33100((int)locatePos.method_10263());
                    int qy = class_5742.method_33100((int)64);
                    int qz = class_5742.method_33100((int)locatePos.method_10260());
                    class_6880 sample = biomeSource.method_38109(qx, qy, qz, randomState.method_42371());
                    if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample)) continue;
                    String chosenId = labelId;
                    for (class_6880 h3 : matchedStructures) {
                        if (!((class_3195)h3.comp_349()).method_41607().method_40241(sample)) continue;
                        chosenId = h3.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse(labelId);
                        break;
                    }
                    result.add(new Records.StructureInfo(locatePos, chosenId));
                }
            }
        }
        return result;
    }

    public static List<Records.StructureInfo> predictOverworldStructuresAroundSpawn(class_3218 level, int radiusChunks, boolean biomePrefilter, List<String> whitelist, List<String> blacklist) {
        class_5455 access = level.method_30349();
        class_2378 setRegistry = access.method_30530(class_7924.field_41248);
        class_2338 spawn = level.method_43126();
        int cx = spawn.method_10263() >> 4;
        int cz = spawn.method_10260() >> 4;
        int minX = cx - radiusChunks;
        int maxX = cx + radiusChunks;
        int minZ = cz - radiusChunks;
        int maxZ = cz + radiusChunks;
        class_7869 state = level.method_14178().method_46642();
        class_7138 randomState = state.method_46713();
        class_1966 biomeSource = level.method_14178().method_12129().method_12098();
        Filters filters = Filters.of(whitelist, blacklist);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (class_6880.class_6883 holder : setRegistry.method_40270().toList()) {
            class_2960 id;
            Object key;
            class_6880 structureHolder;
            class_7059 set = (class_7059)holder.comp_349();
            class_6874 placement = set.comp_511();
            if (!(placement instanceof class_6872)) continue;
            class_6872 rssp = (class_6872)placement;
            ArrayList<class_6880> matchedStructures = new ArrayList<class_6880>();
            for (Object entry : set.comp_510()) {
                structureHolder = entry.comp_512();
                key = structureHolder.method_40230();
                if (((Optional)key).isEmpty() || !filters.matches((class_6880<class_3195>)structureHolder, id = ((class_5321)((Optional)key).get()).method_29177())) continue;
                matchedStructures.add(structureHolder);
            }
            if (matchedStructures.isEmpty()) {
                if (filters.hasWhitelist()) continue;
                for (Object entry : set.comp_510()) {
                    structureHolder = entry.comp_512();
                    key = structureHolder.method_40230();
                    if (((Optional)key).isEmpty() || filters.isBlacklisted((class_6880<class_3195>)structureHolder, id = ((class_5321)((Optional)key).get()).method_29177())) continue;
                    matchedStructures.add(structureHolder);
                }
                if (matchedStructures.isEmpty()) continue;
            }
            HashSet<class_6880> allowedBiomes = null;
            if (biomePrefilter) {
                Object entry;
                allowedBiomes = new HashSet<class_6880>();
                entry = matchedStructures.iterator();
                while (entry.hasNext()) {
                    class_6880 h2 = (class_6880)entry.next();
                    for (class_6880 b : ((class_3195)h2.comp_349()).method_41607()) {
                        allowedBiomes.add(b);
                    }
                }
            }
            int spacing = rssp.method_41632();
            int startI = Math.floorDiv(minX, spacing);
            int endI = Math.floorDiv(maxX, spacing);
            int startJ = Math.floorDiv(minZ, spacing);
            int endJ = Math.floorDiv(maxZ, spacing);
            String labelId = matchedStructures.stream().map(h -> h.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse("structure")).findFirst().orElse("structure");
            for (int i = startI; i <= endI; ++i) {
                for (int j = startJ; j <= endJ; ++j) {
                    int baseX = i * spacing;
                    int baseZ = j * spacing;
                    class_1923 candidate = rssp.method_40169(level.method_8412(), baseX, baseZ);
                    int x = candidate.field_9181;
                    int z = candidate.field_9180;
                    if (x < minX || x > maxX || z < minZ || z > maxZ || !placement.method_41639(state, x, z)) continue;
                    class_2338 locatePos = placement.method_41636(candidate);
                    int qx = class_5742.method_33100((int)locatePos.method_10263());
                    int qy = class_5742.method_33100((int)64);
                    int qz = class_5742.method_33100((int)locatePos.method_10260());
                    class_6880 sample = biomeSource.method_38109(qx, qy, qz, randomState.method_42371());
                    if (biomePrefilter && allowedBiomes != null && !allowedBiomes.contains(sample)) continue;
                    String chosenId = labelId;
                    for (class_6880 h3 : matchedStructures) {
                        if (!((class_3195)h3.comp_349()).method_41607().method_40241(sample)) continue;
                        chosenId = h3.method_40230().map(class_5321::method_29177).map(class_2960::toString).orElse(labelId);
                        break;
                    }
                    result.add(new Records.StructureInfo(locatePos, chosenId));
                }
            }
        }
        return result;
    }

    private static final class Filters {
        private final List<String> whitelist;
        private final List<String> blacklist;

        private Filters(List<String> whitelist, List<String> blacklist) {
            this.whitelist = Filters.normalize(whitelist);
            this.blacklist = Filters.normalize(blacklist);
        }

        static Filters of(List<String> whitelist, List<String> blacklist) {
            return new Filters(whitelist, blacklist);
        }

        boolean hasWhitelist() {
            return !this.whitelist.isEmpty();
        }

        boolean matches(class_6880<class_3195> holder, class_2960 id) {
            boolean whiteOk = this.whitelist.isEmpty() || this.whitelist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
            boolean blackHit = this.blacklist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
            return whiteOk && !blackHit;
        }

        boolean isBlacklisted(class_6880<class_3195> holder, class_2960 id) {
            return this.blacklist.stream().anyMatch(p -> this.matchesPattern(holder, id, (String)p));
        }

        private boolean matchesPattern(class_6880<class_3195> holder, class_2960 id, String pattern) {
            if (pattern == null || pattern.isEmpty()) {
                return false;
            }
            String p = pattern.trim().toLowerCase(Locale.ROOT);
            String idStr = id.toString().toLowerCase(Locale.ROOT);
            if (p.startsWith("#")) {
                String raw = p.substring(1);
                class_2960 tagId = class_2960.method_12829((String)raw);
                if (tagId == null) {
                    return false;
                }
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)tagId);
                return holder.method_40220(tag);
            }
            if (p.endsWith("/*")) {
                String base = p.substring(0, p.length() - 2);
                if (idStr.startsWith(base + "/")) {
                    return true;
                }
                if (idStr.startsWith(base + "_")) {
                    return true;
                }
                if (idStr.startsWith(base + "-")) {
                    return true;
                }
                return idStr.startsWith(base + ".");
            }
            if (p.endsWith(":*")) {
                String ns = p.substring(0, p.length() - 2);
                int idx = ns.indexOf(58);
                if (idx > 0) {
                    ns = ns.substring(0, idx);
                }
                return id.method_12836().equalsIgnoreCase(ns);
            }
            return idStr.equals(p);
        }

        private static List<String> normalize(List<String> src) {
            ArrayList<String> out = new ArrayList<String>();
            if (src == null) {
                return out;
            }
            for (String s : src) {
                String v;
                if (s == null || (v = s.trim().toLowerCase(Locale.ROOT)).isEmpty()) continue;
                out.add(v);
            }
            return out;
        }
    }
}

