/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;

public final class ComputeService {
    private static volatile ExecutorService EXEC = null;

    private ComputeService() {
    }

    private static synchronized ExecutorService ensure() {
        if (EXEC == null || EXEC.isShutdown() || EXEC.isTerminated()) {
            int threads;
            try {
                int cores = Runtime.getRuntime().availableProcessors();
                threads = Math.max(1, cores - 1);
            }
            catch (Throwable t) {
                threads = 1;
            }
            EXEC = Executors.newFixedThreadPool(threads, r -> {
                Thread t = new Thread(r, "RW-Compute-" + System.nanoTime());
                t.setDaemon(true);
                return t;
            });
        }
        return EXEC;
    }

    public static Executor executor() {
        return ComputeService.ensure();
    }

    public static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, ComputeService.ensure());
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, ComputeService.ensure());
    }

    public static void shutdownNow() {
        ExecutorService e = EXEC;
        if (e != null) {
            try {
                e.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EXEC = null;
        }
    }
}

