/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.achievements;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public final class AchievementService {
    private static final class_2960 ADV_FIRST_1 = new class_2960("roadweaver", "road_first_step_1");
    private static final class_2960 ADV_FIRST_2 = new class_2960("roadweaver", "road_first_step_2");
    private static final Map<class_3218, Set<Long>> ROAD_INDEX = new ConcurrentHashMap<class_3218, Set<Long>>();
    private static final Map<class_3218, Integer> ROAD_COUNT = new ConcurrentHashMap<class_3218, Integer>();

    private AchievementService() {
    }

    public static void tick(class_3218 level) {
        if (level == null) {
            return;
        }
        AchievementService.ensureIndex(level);
        Set<Long> index = ROAD_INDEX.get(level);
        if (index == null || index.isEmpty()) {
            return;
        }
        for (class_3222 sp : level.method_8503().method_3760().method_14571()) {
            if (sp == null || sp.method_51469() != level) continue;
            class_2338 feet = sp.method_24515();
            long key = AchievementService.hashXZ(feet.method_10263(), feet.method_10260());
            long keyBelow = AchievementService.hashXZ(feet.method_10263(), feet.method_10260());
            if (!index.contains(key) && !index.contains(keyBelow)) continue;
            AchievementService.award(sp, ADV_FIRST_1, "entered_road");
            AchievementService.award(sp, ADV_FIRST_2, "entered_road");
        }
    }

    private static void ensureIndex(class_3218 level) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.RoadData> list = provider.getRoadDataList(level);
        int size = list == null ? 0 : list.size();
        Integer prev = ROAD_COUNT.get(level);
        if (prev != null && prev == size && ROAD_INDEX.containsKey(level)) {
            return;
        }
        HashSet<Long> set = new HashSet<Long>();
        if (list != null) {
            for (Records.RoadData rd : list) {
                if (rd == null || rd.roadSegmentList() == null) continue;
                for (Records.RoadSegmentPlacement seg : rd.roadSegmentList()) {
                    if (seg == null || seg.positions() == null) continue;
                    for (class_2338 p : seg.positions()) {
                        set.add(AchievementService.hashXZ(p.method_10263(), p.method_10260()));
                    }
                }
            }
        }
        ROAD_INDEX.put(level, set);
        ROAD_COUNT.put(level, size);
    }

    private static void award(class_3222 sp, class_2960 id, String criterion) {
        class_161 adv = sp.field_13995.method_3851().method_12896(id);
        if (adv == null) {
            return;
        }
        class_167 progress = sp.method_14236().method_12882(adv);
        if (!progress.method_740()) {
            sp.method_14236().method_12878(adv, criterion);
        }
    }

    private static long hashXZ(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }
}

