/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.shiroha233.roadweaver.helpers.Records;

public class MapSnapshot {
    private final List<class_2338> structures;
    private final List<Records.StructureConnection> connections;
    private final Map<class_2338, String> structureNames;
    private final List<List<class_2338>> roadPolylines;
    private final int minX;
    private final int minZ;
    private final int maxX;
    private final int maxZ;

    public MapSnapshot(List<class_2338> structures, List<Records.StructureConnection> connections, List<Records.StructureInfo> structureInfos, List<List<class_2338>> roadPolylines) {
        int n;
        int n2;
        int n3;
        this.structures = Collections.unmodifiableList(new ArrayList<class_2338>(structures != null ? structures : List.of()));
        this.connections = Collections.unmodifiableList(new ArrayList<Records.StructureConnection>(connections != null ? connections : List.of()));
        HashMap<class_2338, String> nm = new HashMap<class_2338, String>();
        if (structureInfos != null) {
            for (Records.StructureInfo structureInfo : structureInfos) {
                nm.put(structureInfo.pos(), structureInfo.structureId());
            }
        }
        this.structureNames = Collections.unmodifiableMap(nm);
        ArrayList<List<class_2338>> rp = new ArrayList<List<class_2338>>();
        if (roadPolylines != null) {
            for (List<class_2338> list : roadPolylines) {
                rp.add(Collections.unmodifiableList(new ArrayList<class_2338>(list)));
            }
        }
        this.roadPolylines = Collections.unmodifiableList(rp);
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 class_23382 : this.structures) {
            int n6;
            int n7;
            if (class_23382.method_10263() < n7) {
                n7 = class_23382.method_10263();
            }
            if (class_23382.method_10260() < n6) {
                n6 = class_23382.method_10260();
            }
            if (class_23382.method_10263() > maxX) {
                maxX = class_23382.method_10263();
            }
            if (class_23382.method_10260() <= maxZ) continue;
            maxZ = class_23382.method_10260();
        }
        for (Records.StructureConnection structureConnection : this.connections) {
            int n8;
            int n9;
            class_2338 a = structureConnection.from();
            class_2338 b = structureConnection.to();
            if (a.method_10263() < n9) {
                n9 = a.method_10263();
            }
            if (a.method_10260() < n8) {
                n8 = a.method_10260();
            }
            if (a.method_10263() > maxX) {
                maxX = a.method_10263();
            }
            if (a.method_10260() > maxZ) {
                maxZ = a.method_10260();
            }
            if (b.method_10263() < n9) {
                n9 = b.method_10263();
            }
            if (b.method_10260() < n8) {
                n8 = b.method_10260();
            }
            if (b.method_10263() > maxX) {
                maxX = b.method_10263();
            }
            if (b.method_10260() <= maxZ) continue;
            maxZ = b.method_10260();
        }
        for (List list : this.roadPolylines) {
            for (class_2338 p : list) {
                int n10;
                if (p.method_10263() < n3) {
                    n3 = p.method_10263();
                }
                if (p.method_10260() < n10) {
                    n10 = p.method_10260();
                }
                if (p.method_10263() > maxX) {
                    maxX = p.method_10263();
                }
                if (p.method_10260() <= maxZ) continue;
                maxZ = p.method_10260();
            }
        }
        if (n3 == Integer.MAX_VALUE) {
            n2 = 0;
            n = 0;
            maxZ = 1;
            maxX = 1;
        }
        this.minX = n;
        this.minZ = n2;
        this.maxX = maxX;
        this.maxZ = maxZ;
    }

    public List<class_2338> structures() {
        return this.structures;
    }

    public List<Records.StructureConnection> connections() {
        return this.connections;
    }

    public String structureName(class_2338 pos) {
        return this.structureNames.get(pos);
    }

    public List<List<class_2338>> roadPolylines() {
        return this.roadPolylines;
    }

    public int minX() {
        return this.minX;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public int structuresCount() {
        return this.structures.size();
    }

    public int plannedCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.PLANNED).count();
    }

    public int generatingCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.GENERATING).count();
    }

    public int completedCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.COMPLETED).count();
    }

    public int failedCount() {
        return (int)this.connections.stream().filter(c -> c.status() == Records.ConnectionStatus.FAILED).count();
    }

    public static MapSnapshot empty() {
        return new MapSnapshot(List.of(), List.of(), List.of(), List.of());
    }
}

