/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import net.minecraft.class_332;

public final class RenderUtils {
    private RenderUtils() {
    }

    public static void drawLine(class_332 g, int x1, int y1, int x2, int y2, int color, int left, int top, int right, int bottom) {
        int dy;
        int dx = Math.abs(x2 - x1);
        int steps = Math.max(dx, dy = Math.abs(y2 - y1));
        if (steps == 0) {
            if (x1 >= left && x1 <= right && y1 >= top && y1 <= bottom) {
                g.method_25294(x1, y1, x1 + 1, y1 + 1, color);
            }
            return;
        }
        float fx = x1;
        float fy = y1;
        float sx = (float)(x2 - x1) / (float)steps;
        float sy = (float)(y2 - y1) / (float)steps;
        for (int i = 0; i <= steps; ++i) {
            int px = Math.round(fx);
            int py = Math.round(fy);
            if (px >= left && px <= right && py >= top && py <= bottom) {
                g.method_25294(px, py, px + 1, py + 1, color);
            }
            fx += sx;
            fy += sy;
        }
    }

    public static void drawThickLine(class_332 g, int x1, int y1, int x2, int y2, int color, int thickness, int left, int top, int right, int bottom) {
        if ((thickness = Math.max(1, thickness)) == 1) {
            RenderUtils.drawLine(g, x1, y1, x2, y2, color, left, top, right, bottom);
            return;
        }
        int half = thickness / 2;
        for (int ox = -half; ox <= half; ++ox) {
            for (int oy = -half; oy <= half; ++oy) {
                RenderUtils.drawLine(g, x1 + ox, y1 + oy, x2 + ox, y2 + oy, color, left, top, right, bottom);
            }
        }
    }

    public static void drawDashedLine(class_332 g, int x1, int y1, int x2, int y2, int color, int dash, int gap, int left, int top, int right, int bottom) {
        int dy;
        dash = Math.max(1, dash);
        gap = Math.max(1, gap);
        int dx = Math.abs(x2 - x1);
        int steps = Math.max(dx, dy = Math.abs(y2 - y1));
        if (steps == 0) {
            if (x1 >= left && x1 <= right && y1 >= top && y1 <= bottom) {
                g.method_25294(x1, y1, x1 + 1, y1 + 1, color);
            }
            return;
        }
        float fx = x1;
        float fy = y1;
        float sx = (float)(x2 - x1) / (float)steps;
        float sy = (float)(y2 - y1) / (float)steps;
        int pattern = dash + gap;
        for (int i = 0; i <= steps; ++i) {
            int idx = i % pattern;
            if (idx < dash) {
                int px = Math.round(fx);
                int py = Math.round(fy);
                if (px >= left && px <= right && py >= top && py <= bottom) {
                    g.method_25294(px, py, px + 1, py + 1, color);
                }
            }
            fx += sx;
            fy += sy;
        }
    }

    public static void drawThickDashedLine(class_332 g, int x1, int y1, int x2, int y2, int color, int thickness, int dash, int gap, int left, int top, int right, int bottom) {
        if ((thickness = Math.max(1, thickness)) == 1) {
            RenderUtils.drawDashedLine(g, x1, y1, x2, y2, color, dash, gap, left, top, right, bottom);
            return;
        }
        int half = thickness / 2;
        for (int ox = -half; ox <= half; ++ox) {
            for (int oy = -half; oy <= half; ++oy) {
                RenderUtils.drawDashedLine(g, x1 + ox, y1 + oy, x2 + ox, y2 + oy, color, dash, gap, left, top, right, bottom);
            }
        }
    }

    public static void drawPoint(class_332 g, int x, int y, int size, int color, int left, int top, int right, int bottom) {
        int half = Math.max(0, size / 2);
        if (x < left || x > right || y < top || y > bottom) {
            return;
        }
        g.method_25294(x - half, y - half, x - half + size, y - half + size, color);
    }

    public static void fillTriangle(class_332 g, int x1, int y1, int x2, int y2, int x3, int y3, int color, int left, int top, int right, int bottom) {
        int ty;
        int tx;
        if (y2 < y1) {
            tx = x1;
            ty = y1;
            x1 = x2;
            y1 = y2;
            x2 = tx;
            y2 = ty;
        }
        if (y3 < y1) {
            tx = x1;
            ty = y1;
            x1 = x3;
            y1 = y3;
            x3 = tx;
            y3 = ty;
        }
        if (y3 < y2) {
            tx = x2;
            ty = y2;
            x2 = x3;
            y2 = y3;
            x3 = tx;
            y3 = ty;
        }
        if (y1 == y3) {
            return;
        }
        float inv12 = y2 != y1 ? (float)(x2 - x1) / (float)(y2 - y1) : 0.0f;
        float inv13 = (float)(x3 - x1) / (float)(y3 - y1);
        float inv23 = y3 != y2 ? (float)(x3 - x2) / (float)(y3 - y2) : 0.0f;
        float sx12 = x1;
        float sx13 = x1;
        for (int y = y1; y < y2; ++y) {
            if (y < top || y > bottom) {
                sx12 += inv12;
                sx13 += inv13;
                continue;
            }
            int xa = Math.round(Math.min(sx12, sx13));
            int xb = Math.round(Math.max(sx12, sx13));
            if ((xa = Math.max(xa, left)) <= (xb = Math.min(xb, right))) {
                g.method_25294(xa, y, xb + 1, y + 1, color);
            }
            sx12 += inv12;
            sx13 += inv13;
        }
        float sx23 = x2;
        float sx13b = (float)x1 + inv13 * (float)(y2 - y1);
        for (int y = y2; y <= y3; ++y) {
            if (y < top || y > bottom) {
                sx23 += inv23;
                sx13b += inv13;
                continue;
            }
            int xa = Math.round(Math.min(sx23, sx13b));
            int xb = Math.round(Math.max(sx23, sx13b));
            if ((xa = Math.max(xa, left)) <= (xb = Math.min(xb, right))) {
                g.method_25294(xa, y, xb + 1, y + 1, color);
            }
            sx23 += inv23;
            sx13b += inv13;
        }
    }
}

