/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.shiroha233.roadweaver.client.map.GridRenderer;
import net.shiroha233.roadweaver.client.map.MapDataCollector;
import net.shiroha233.roadweaver.client.map.MapInteraction;
import net.shiroha233.roadweaver.client.map.MapRenderers;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.RenderUtils;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.ClientNetBridge;

public class RoadMapScreen
extends class_437 {
    private static final class_2960 MAP_TEXTURE = new class_2960("roadweaver", "textures/gui/map.png");
    private static final int TEX_W = 1536;
    private static final int TEX_H = 1024;
    private static final int COLOR_TEXT = -10601186;
    private static final int COLOR_STRUCT = -10601186;
    private static final int COLOR_PLANNED = -11751600;
    private static final int COLOR_GENERATING = -16777216;
    private static final int COLOR_COMPLETED = -16777216;
    private static final int COLOR_FAILED = -522167472;
    private static final int COLOR_GRID = 0x30999999;
    private static final int GRID_TARGET_PX = 32;
    private static final class_2561 MENU_TELEPORT = class_2561.method_43471((String)"gui.roadweaver.map.menu.teleport");
    private static final class_2561 BTN_CONFIG = class_2561.method_43471((String)"gui.roadweaver.config_button");
    private static final int MENU_BG = -267382768;
    private static final int MENU_BORDER = -1;
    private static final int MENU_HOVER = 0x40FFFFFF;
    private static final int MENU_TEXT = -1;
    private static final int MENU_MIN_W = 0;
    private static final int MENU_ITEM_H = 14;
    private static final int MENU_PAD_X = 6;
    private static final int MENU_PAD_Y = 4;
    private MapSnapshot snapshot = MapSnapshot.empty();
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;
    private static final int OUTER_PAD = 36;
    private static final int INNER_PAD = 25;
    private final MapView view = new MapView();
    private boolean dragging;
    private int dragButton;
    private double lastMouseX;
    private double lastMouseY;
    private boolean debounceZoomPending;
    private long debounceZoomDeadlineMs;
    private boolean showContextMenu;
    private int menuX;
    private int menuY;
    private class_2338 menuTarget;

    public RoadMapScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.map.title"));
    }

    protected void method_25426() {
        super.method_25426();
        this.computeMapRect();
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.resetFromSnapshot(this.snapshot);
        class_310 mc = this.field_22787;
        if (mc != null && mc.field_1724 != null) {
            this.view.calibrateInitialToPlayer(mc, contentW, contentH, 32);
        }
        this.requestCurrentView();
    }

    private void computeMapRect() {
        int availW = this.field_22789 - 72;
        int availH = this.field_22790 - 72;
        int w = availW;
        float ratio = 1.5f;
        int h = Math.round((float)w / ratio);
        if (h > availH) {
            h = availH;
            w = Math.round((float)h * ratio);
        }
        this.mapW = w;
        this.mapH = h;
        this.mapX = (this.field_22789 - w) / 2;
        this.mapY = (this.field_22790 - h) / 2;
    }

    private boolean insideMap(double x, double y) {
        return x >= (double)(this.mapX + 25) && x <= (double)(this.mapX + this.mapW - 25) && y >= (double)(this.mapY + 25) && y <= (double)(this.mapY + this.mapH - 25);
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_25293(MAP_TEXTURE, this.mapX, this.mapY, this.mapW, this.mapH, 0.0f, 0.0f, 1536, 1024, 1536, 1024);
        int titleY = this.mapY - 8;
        g.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, Math.max(6, titleY), -10601186);
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.lockAspect(contentW, contentH);
        int left = this.mapX + 25;
        int top = this.mapY + 25;
        int right = this.mapX + this.mapW - 25;
        int bottom = this.mapY + this.mapH - 25;
        g.method_44379(left, top, right, bottom);
        MapRenderers.renderGrid(g, this.field_22793, this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 0x30999999, 32, -10601186);
        int thickness = this.computeThickness();
        ArrayList<Records.StructureConnection> connForLines = new ArrayList<Records.StructureConnection>(this.snapshot.connections());
        connForLines.removeIf(c -> c.status() == Records.ConnectionStatus.COMPLETED);
        MapRenderers.renderConnections(g, connForLines, (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -11751600, -16777216, -16777216, -522167472, left, top, right, bottom);
        int lodStep = GridRenderer.computeGridStep(this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 32);
        MapRenderers.renderRoadPolylines(g, this.snapshot.roadPolylines(), (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -16777216, left, top, right, bottom, lodStep);
        MapRenderers.renderStructures(g, this.snapshot.structures(), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), (x, z) -> this.view.isInViewWorld((int)x, (int)z), this.computePointSize(), -10601186, left, top, right, bottom);
        if (!this.showContextMenu) {
            MapInteraction.renderHoverHighlight(g, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        this.renderPlayer(g);
        g.method_44380();
        int legendRight = this.mapX + this.mapW - 25;
        int legendStartY = this.mapY + 25 + 8;
        int gap = 8;
        MapRenderers.renderLegend(g, this.field_22793, legendRight, legendStartY, gap, -10601186, -10601186, -11751600, -16777216, -16777216, -522167472, this.snapshot.structuresCount(), this.snapshot.plannedCount(), this.snapshot.generatingCount(), this.snapshot.completedCount(), this.snapshot.failedCount());
        this.renderConfigButton(g, mouseX, mouseY);
        if (!this.showContextMenu) {
            MapInteraction.renderHoverTooltip(g, this.field_22793, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        if (this.debounceZoomPending && System.currentTimeMillis() >= this.debounceZoomDeadlineMs) {
            this.debounceZoomPending = false;
            this.requestCurrentView();
        }
        if (this.showContextMenu && this.menuTarget != null) {
            this.renderContextMenu(g, mouseX, mouseY);
        }
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private int computeThickness() {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double ppb = Math.min(this.view.pxPerBlockX(contentW), this.view.pxPerBlockZ(contentH));
        int t = (int)Math.round(ppb);
        if (t < 1) {
            t = 1;
        }
        if (t > 4) {
            t = 4;
        }
        return t;
    }

    private int computePointSize() {
        return 2 + this.computeThickness();
    }

    public boolean method_25421() {
        return false;
    }

    public void setSnapshot(MapSnapshot snapshot) {
        if (snapshot != null) {
            this.snapshot = snapshot;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!this.insideMap(mouseX, mouseY)) {
            return super.method_25401(mouseX, mouseY, delta);
        }
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double factor = delta > 0.0 ? 0.9 : 1.1;
        double cx = this.view.screenToWorldX(mouseX, this.mapX, 25, contentW);
        double cz = this.view.screenToWorldZ(mouseY, this.mapY, 25, contentH);
        this.view.applyZoomAround(cx, cz, factor, contentW, contentH, 32);
        this.debounceZoomPending = true;
        this.debounceZoomDeadlineMs = System.currentTimeMillis() + 500L;
        this.showContextMenu = false;
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_2338 best;
        if (button == 0 && this.insideConfigButton((int)mouseX, (int)mouseY)) {
            this.openConfig();
            return true;
        }
        if (this.showContextMenu) {
            boolean inside;
            int[] bounds = this.computeMenuBounds();
            int bx = bounds[0];
            int by = bounds[1];
            int bw = bounds[2];
            int bh = bounds[3];
            boolean bl = inside = mouseX >= (double)bx && mouseX <= (double)(bx + bw) && mouseY >= (double)by && mouseY <= (double)(by + bh);
            if (inside && button == 0) {
                int idx = this.getMenuHoverIndex((int)mouseX, (int)mouseY);
                if (idx == 0) {
                    this.onTeleportSelected();
                    this.showContextMenu = false;
                    return true;
                }
            } else {
                this.showContextMenu = false;
            }
        }
        if (this.insideMap(mouseX, mouseY) && button == 0) {
            this.dragging = true;
            this.dragButton = button;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.debounceZoomPending = false;
            this.showContextMenu = false;
            return true;
        }
        if (this.insideMap(mouseX, mouseY) && button == 1 && (best = this.findNearestStructure(mouseX, mouseY)) != null) {
            this.menuTarget = best;
            this.menuX = (int)mouseX;
            this.menuY = (int)mouseY;
            this.showContextMenu = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == this.dragButton) {
            int contentW = this.mapW - 50;
            int contentH = this.mapH - 50;
            double dx = mouseX - this.lastMouseX;
            double dy = mouseY - this.lastMouseY;
            this.view.panByScreenDelta(dx, dy, contentW, contentH);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.view.lockAspect(contentW, contentH);
            this.showContextMenu = false;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragging && button == this.dragButton) {
            this.dragging = false;
            this.view.clampZoom(this.mapW - 50, this.mapH - 50, 32);
            this.debounceZoomPending = false;
            this.requestCurrentView();
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void renderPlayer(class_332 g) {
        int sy;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        double wx = this.field_22787.field_1724.method_23317();
        double wz = this.field_22787.field_1724.method_23321();
        int sx = this.view.toScreenX((int)Math.round(wx), this.mapX, 25, this.mapW - 50);
        if (!this.insideMap(sx, sy = this.view.toScreenY((int)Math.round(wz), this.mapY, 25, this.mapH - 50))) {
            return;
        }
        float yaw = this.field_22787.field_1724.method_36454();
        int left = this.mapX + 25;
        int right = this.mapX + this.mapW - 25;
        int top = this.mapY + 25;
        int bottom = this.mapY + this.mapH - 25;
        MapRenderers.drawPlayerArrow(g, sx, sy, yaw, 10, 6, 4, -16777216, left, top, right, bottom, this.view.pxPerBlockX(this.mapW - 50), this.view.pxPerBlockZ(this.mapH - 50));
    }

    private void requestCurrentView() {
        int minX = (int)Math.floor(Math.min(this.view.getMinX(), this.view.getMaxX()));
        int maxX = (int)Math.ceil(Math.max(this.view.getMinX(), this.view.getMaxX()));
        int minZ = (int)Math.floor(Math.min(this.view.getMinZ(), this.view.getMaxZ()));
        int maxZ = (int)Math.ceil(Math.max(this.view.getMinZ(), this.view.getMaxZ()));
        int pad = 32;
        minX -= pad;
        maxX += pad;
        minZ -= pad;
        maxZ += pad;
        class_310 mc = this.field_22787;
        if (mc == null) {
            return;
        }
        class_1132 server = mc.method_1576();
        if (server != null) {
            class_3218 level = server.method_3847(class_1937.field_25179);
            if (level != null) {
                int radiusChunks;
                int cx = 0;
                int cz = 0;
                if (mc.field_1724 != null) {
                    cx = (int)Math.round(mc.field_1724.method_23317());
                    cz = (int)Math.round(mc.field_1724.method_23321());
                }
                try {
                    ModConfig cfg = ConfigService.get();
                    radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
                }
                catch (Throwable t) {
                    radiusChunks = 256;
                }
                int radiusBlocks = Math.max(1, radiusChunks) * 16;
                this.setSnapshot(MapDataCollector.build(level, minX, minZ, maxX, maxZ, cx, cz, radiusBlocks));
            }
        } else {
            ClientNetBridge.requestSnapshot(minX, minZ, maxX, maxZ);
        }
    }

    private class_2338 findNearestStructure(double mouseX, double mouseY) {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        int bestDist = Integer.MAX_VALUE;
        class_2338 best = null;
        for (class_2338 p : this.snapshot.structures()) {
            int dy;
            if (!this.view.isInViewWorld(p.method_10263(), p.method_10260())) continue;
            int x = this.view.toScreenX(p.method_10263(), this.mapX, 25, contentW);
            int y = this.view.toScreenY(p.method_10260(), this.mapY, 25, contentH);
            int dx = (int)Math.abs((double)x - mouseX);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - mouseY)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            return best;
        }
        return null;
    }

    private int[] computeMenuBounds() {
        int cnt = 1;
        int textW = this.field_22793.method_27525((class_5348)MENU_TELEPORT);
        int w = Math.max(0, textW + 12);
        int h = 8 + 14 * cnt;
        int x = this.menuX + 12;
        int y = this.menuY - 12;
        if (x + w > this.field_22789) {
            x = this.field_22789 - w - 4;
        }
        if (y + h > this.field_22790) {
            y = this.field_22790 - h - 4;
        }
        if (x < 4) {
            x = 4;
        }
        if (y < 4) {
            y = 4;
        }
        return new int[]{x, y, w, h};
    }

    private int getMenuHoverIndex(int mx, int my) {
        int[] b = this.computeMenuBounds();
        int x = b[0];
        int y = b[1];
        int w = b[2];
        int h = b[3];
        if (mx < x || mx > x + w || my < y || my > y + h) {
            return -1;
        }
        int innerTop = y + 4;
        if (my < innerTop) {
            return -1;
        }
        int rel = my - innerTop;
        int idx = rel / 14;
        if (idx < 0) {
            return -1;
        }
        if (idx > 0) {
            return -1;
        }
        return 0;
    }

    private void renderContextMenu(class_332 g, int mouseX, int mouseY) {
        int[] b = this.computeMenuBounds();
        int x = b[0];
        int y = b[1];
        int w = b[2];
        int h = b[3];
        int shadow = -2146430960;
        g.method_25294(x + 3, y + 3, x + w + 3, y + h + 3, shadow);
        g.method_25294(x - 1, y - 1, x + w + 1, y + h + 1, -1);
        g.method_25294(x, y, x + w, y + h, -267382768);
        int hover = this.getMenuHoverIndex(mouseX, mouseY);
        int itemTop = y + 4;
        if (hover == 0) {
            g.method_25294(x + 1, itemTop, x + w - 1, itemTop + 14, 0x40FFFFFF);
        }
        g.method_25294(x + 1, itemTop + 14, x + w - 1, itemTop + 14 + 1, 0x40FFFFFF);
        Objects.requireNonNull(this.field_22793);
        int ty = itemTop + (14 - 9) / 2;
        g.method_51439(this.field_22793, MENU_TELEPORT, x + 6, ty, -1, false);
        int baseY = itemTop + 7;
        int tipX = x - 6;
        int tipY = baseY;
        int bx1 = x - 1;
        int by1 = baseY - 4;
        int bx2 = x - 1;
        int by2 = baseY + 4;
        RenderUtils.fillTriangle(g, tipX, tipY, bx1, by1, bx2, by2, -1, 0, 0, this.field_22789, this.field_22790);
        RenderUtils.fillTriangle(g, tipX + 1, tipY, bx1, by1 + 1, bx2, by2 - 1, -267382768, 0, 0, this.field_22789, this.field_22790);
    }

    private void onTeleportSelected() {
        if (this.menuTarget == null) {
            return;
        }
        ClientNetBridge.requestTeleport(this.menuTarget.method_10263(), this.menuTarget.method_10264(), this.menuTarget.method_10260());
    }

    private int[] computeConfigBtnBounds() {
        int x = this.mapX + 25 + 4;
        int y = this.mapY + 25 + 4;
        int w = this.field_22793.method_27525((class_5348)BTN_CONFIG) + 6;
        Objects.requireNonNull(this.field_22793);
        int h = 9 + 4;
        return new int[]{x, y, w, h};
    }

    private boolean insideConfigButton(int mx, int my) {
        int[] b = this.computeConfigBtnBounds();
        int x = b[0];
        int y = b[1];
        int w = b[2];
        int h = b[3];
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private void renderConfigButton(class_332 g, int mouseX, int mouseY) {
        int[] b = this.computeConfigBtnBounds();
        int x = b[0];
        int y = b[1];
        int h = b[3];
        Objects.requireNonNull(this.field_22793);
        int ty = y + (h - 9) / 2;
        g.method_51439(this.field_22793, BTN_CONFIG, x + 3, ty, -10601186, false);
        if (this.insideConfigButton(mouseX, mouseY)) {
            int textW = this.field_22793.method_27525((class_5348)BTN_CONFIG);
            Objects.requireNonNull(this.field_22793);
            int uy = ty + 9 + 1;
            int underline = 1616788766;
            g.method_25294(x + 2, uy, x + 2 + textW + 2, uy + 1, underline);
        }
    }

    private void openConfig() {
        Class<?> c2;
        if (this.field_22787 == null) {
            return;
        }
        class_437 next = null;
        try {
            c2 = Class.forName("net.shiroha233.roadweaver.client.fabric.ConfigScreenFactoryImpl");
            next = (class_437)c2.getMethod("createConfigScreen", class_437.class).invoke(null, new Object[]{this});
        }
        catch (Throwable c2) {
            // empty catch block
        }
        if (next == null) {
            try {
                c2 = Class.forName("net.shiroha233.roadweaver.client.forge.ConfigScreenFactoryImpl");
                next = (class_437)c2.getMethod("createConfigScreen", class_437.class).invoke(null, new Object[]{this});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (next != null) {
            this.field_22787.method_1507(next);
        }
    }
}

