/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.config;

import java.util.ArrayList;
import java.util.List;

public final class ModConfig {
    private boolean villagePredictionEnabled = true;
    private int predictRadiusChunks = 1024;
    private boolean biomePrefilter = true;
    private List<String> structureWhitelist = new ArrayList<String>();
    private List<String> structureBlacklist = new ArrayList<String>();
    private int initialPlanRadiusChunks;
    private boolean dynamicPlanEnabled;
    private int dynamicPlanRadiusChunks;
    private int dynamicPlanStrideChunks;
    private PlanningAlgorithm planningAlgorithm;
    private boolean allowArtificial;
    private boolean placeWaypoints;
    private int averagingRadius;
    private int generationThreads;
    private int maxConcurrentGenerations;
    private int aStarStep;
    private int roadWidth;
    private int lampInterval;
    private boolean tunnelEnabled;
    private int tunnelClearHeight;

    public ModConfig() {
        this.structureWhitelist.add("#minecraft:village");
        this.initialPlanRadiusChunks = 64;
        this.dynamicPlanEnabled = true;
        this.dynamicPlanRadiusChunks = 256;
        this.dynamicPlanStrideChunks = Math.max(8, Math.min(64, this.dynamicPlanRadiusChunks / 2));
        this.planningAlgorithm = PlanningAlgorithm.RNG;
        this.allowArtificial = true;
        this.placeWaypoints = false;
        this.averagingRadius = 8;
        this.generationThreads = Math.max(2, Math.min(3, Runtime.getRuntime().availableProcessors()));
        this.maxConcurrentGenerations = Math.max(1, Math.min(3, this.generationThreads));
        this.aStarStep = 16;
        this.roadWidth = 3;
        this.lampInterval = 32;
        this.tunnelEnabled = false;
        this.tunnelClearHeight = 5;
    }

    public boolean villagePredictionEnabled() {
        return this.villagePredictionEnabled;
    }

    public void setVillagePredictionEnabled(boolean villagePredictionEnabled) {
        this.villagePredictionEnabled = villagePredictionEnabled;
    }

    public int predictRadiusChunks() {
        return this.predictRadiusChunks;
    }

    public void setPredictRadiusChunks(int predictRadiusChunks) {
        this.predictRadiusChunks = predictRadiusChunks;
    }

    public boolean biomePrefilter() {
        return this.biomePrefilter;
    }

    public void setBiomePrefilter(boolean biomePrefilter) {
        this.biomePrefilter = biomePrefilter;
    }

    public List<String> structureWhitelist() {
        return this.structureWhitelist;
    }

    public void setStructureWhitelist(List<String> structureWhitelist) {
        this.structureWhitelist = structureWhitelist == null ? new ArrayList<String>() : new ArrayList<String>(structureWhitelist);
    }

    public List<String> structureBlacklist() {
        return this.structureBlacklist;
    }

    public void setStructureBlacklist(List<String> structureBlacklist) {
        this.structureBlacklist = structureBlacklist == null ? new ArrayList<String>() : new ArrayList<String>(structureBlacklist);
    }

    public void sanitize() {
        int maxCap;
        if (this.structureWhitelist == null) {
            this.structureWhitelist = new ArrayList<String>();
        }
        if (this.structureBlacklist == null) {
            this.structureBlacklist = new ArrayList<String>();
        }
        if (this.predictRadiusChunks <= 0) {
            this.predictRadiusChunks = 1024;
        }
        if (this.initialPlanRadiusChunks <= 0) {
            this.initialPlanRadiusChunks = 64;
        }
        if (this.dynamicPlanRadiusChunks <= 0) {
            this.dynamicPlanRadiusChunks = 256;
        }
        if (this.dynamicPlanStrideChunks <= 0) {
            this.dynamicPlanStrideChunks = Math.max(8, Math.min(64, Math.max(1, this.dynamicPlanRadiusChunks) / 2));
        }
        if (this.dynamicPlanStrideChunks > this.dynamicPlanRadiusChunks) {
            this.dynamicPlanStrideChunks = this.dynamicPlanRadiusChunks;
        }
        if (this.dynamicPlanStrideChunks > 256) {
            this.dynamicPlanStrideChunks = 256;
        }
        if (this.planningAlgorithm == null) {
            this.planningAlgorithm = PlanningAlgorithm.RNG;
        }
        if (this.averagingRadius < 0) {
            this.averagingRadius = 0;
        }
        if (this.generationThreads < 1) {
            this.generationThreads = Math.max(2, Math.min(8, Runtime.getRuntime().availableProcessors()));
        }
        if (this.generationThreads > 64) {
            this.generationThreads = 64;
        }
        if (this.maxConcurrentGenerations < 1) {
            this.maxConcurrentGenerations = this.generationThreads;
        }
        if (this.maxConcurrentGenerations > (maxCap = Math.max(1, this.generationThreads * 2))) {
            this.maxConcurrentGenerations = maxCap;
        }
        if (this.aStarStep < 4) {
            this.aStarStep = 16;
        }
        if (this.aStarStep > 128) {
            this.aStarStep = 128;
        }
        if (this.roadWidth < 0) {
            this.roadWidth = 0;
        }
        if (this.roadWidth > 15) {
            this.roadWidth = 15;
        }
        if (this.lampInterval < 1) {
            this.lampInterval = 59;
        }
        if (this.lampInterval > 2048) {
            this.lampInterval = 2048;
        }
        if (this.tunnelClearHeight < 2) {
            this.tunnelClearHeight = 2;
        }
        if (this.tunnelClearHeight > 16) {
            this.tunnelClearHeight = 16;
        }
    }

    public int initialPlanRadiusChunks() {
        return this.initialPlanRadiusChunks;
    }

    public void setInitialPlanRadiusChunks(int v) {
        this.initialPlanRadiusChunks = v;
    }

    public boolean dynamicPlanEnabled() {
        return this.dynamicPlanEnabled;
    }

    public void setDynamicPlanEnabled(boolean v) {
        this.dynamicPlanEnabled = v;
    }

    public int dynamicPlanRadiusChunks() {
        return this.dynamicPlanRadiusChunks;
    }

    public void setDynamicPlanRadiusChunks(int v) {
        this.dynamicPlanRadiusChunks = v;
    }

    public int dynamicPlanStrideChunks() {
        return this.dynamicPlanStrideChunks;
    }

    public void setDynamicPlanStrideChunks(int v) {
        this.dynamicPlanStrideChunks = v;
    }

    public boolean allowArtificial() {
        return this.allowArtificial;
    }

    public void setAllowArtificial(boolean v) {
        this.allowArtificial = v;
    }

    public boolean placeWaypoints() {
        return this.placeWaypoints;
    }

    public void setPlaceWaypoints(boolean v) {
        this.placeWaypoints = v;
    }

    public int averagingRadius() {
        return this.averagingRadius;
    }

    public void setAveragingRadius(int v) {
        this.averagingRadius = v;
    }

    public int generationThreads() {
        return this.generationThreads;
    }

    public void setGenerationThreads(int v) {
        this.generationThreads = v;
    }

    public int maxConcurrentGenerations() {
        return this.maxConcurrentGenerations;
    }

    public void setMaxConcurrentGenerations(int v) {
        this.maxConcurrentGenerations = v;
    }

    public int aStarStep() {
        return this.aStarStep;
    }

    public void setAStarStep(int v) {
        this.aStarStep = v;
    }

    public int roadWidth() {
        return this.roadWidth;
    }

    public void setRoadWidth(int v) {
        this.roadWidth = v;
    }

    public int lampInterval() {
        return this.lampInterval;
    }

    public void setLampInterval(int v) {
        this.lampInterval = v;
    }

    public PlanningAlgorithm planningAlgorithm() {
        return this.planningAlgorithm;
    }

    public void setPlanningAlgorithm(PlanningAlgorithm v) {
        this.planningAlgorithm = v;
    }

    public boolean tunnelEnabled() {
        return this.tunnelEnabled;
    }

    public void setTunnelEnabled(boolean v) {
        this.tunnelEnabled = v;
    }

    public int tunnelClearHeight() {
        return this.tunnelClearHeight;
    }

    public void setTunnelClearHeight(int v) {
        this.tunnelClearHeight = v;
    }

    public static enum PlanningAlgorithm {
        KNN,
        DELAUNAY,
        RNG;

    }
}

