/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.shiroha233.roadweaver.config.PresetConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PresetService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String BASE_DIR = "roadweaver";
    private static final String PRESET_DIR = "presets";
    private static final String FILE_NAME = "road_surface.json";
    private static final AtomicReference<PresetConfig> PRESET = new AtomicReference();

    private PresetService() {
    }

    public static synchronized PresetConfig get() {
        PresetConfig cur = PRESET.get();
        if (cur != null) {
            return cur;
        }
        PresetService.load();
        return PRESET.get();
    }

    public static synchronized void load() {
        PresetConfig preset;
        block14: {
            Path cfgRoot = Platform.getConfigFolder();
            Path baseDir = cfgRoot.resolve(BASE_DIR);
            Path presetDir = baseDir.resolve(PRESET_DIR);
            Path file = presetDir.resolve(FILE_NAME);
            preset = null;
            try {
                try {
                    Files.createDirectories(presetDir, new FileAttribute[0]);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to create preset directory: {}", (Object)presetDir, (Object)e);
                }
                if (Files.exists(file, new LinkOption[0])) {
                    try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                        preset = (PresetConfig)GSON.fromJson((Reader)br, PresetConfig.class);
                        break block14;
                    }
                }
                preset = PresetConfig.defaults();
                PresetService.save(preset);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to read presets, using defaults: {}", (Object)file, (Object)e);
                preset = PresetConfig.defaults();
            }
        }
        if (preset == null) {
            preset = PresetConfig.defaults();
        }
        try {
            preset.sanitize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PRESET.set(preset);
        LOGGER.info("Presets loaded from {}/{}: materials={} entries", new Object[]{BASE_DIR, PRESET_DIR, preset.materials.size()});
    }

    public static synchronized void save() {
        PresetConfig p = PRESET.get();
        if (p == null) {
            p = PresetConfig.defaults();
        }
        PresetService.save(p);
    }

    private static void save(PresetConfig p) {
        Path cfgRoot = Platform.getConfigFolder();
        Path baseDir = cfgRoot.resolve(BASE_DIR);
        Path presetDir = baseDir.resolve(PRESET_DIR);
        Path file = presetDir.resolve(FILE_NAME);
        try {
            Files.createDirectories(presetDir, new FileAttribute[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create preset directory: {}", (Object)presetDir, (Object)e);
        }
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)p, (Appendable)bw);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to write presets: {}", (Object)file, (Object)e);
        }
    }

    public static List<List<String>> getMaterialCombos() {
        PresetConfig p = PresetService.get();
        return p.materials == null ? List.of() : p.materials;
    }
}

