/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.system.RoadDecorationSystem;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public class RoadFeature
extends class_3031<RoadFeatureConfig> {
    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<RoadFeatureConfig> ctx) {
        class_5281 world = ctx.method_33652();
        class_3218 lvl = world.method_8410();
        if (!(lvl instanceof class_3218)) {
            return false;
        }
        class_3218 server = lvl;
        List<Records.RoadData> roadDataList = WorldDataProvider.getInstance().getRoadDataList(server);
        if (roadDataList == null || roadDataList.isEmpty()) {
            return false;
        }
        class_1923 currentChunk = new class_1923(ctx.method_33655());
        HashSet<class_2338> processedMiddle = new HashSet<class_2338>();
        class_5819 random = ctx.method_33654();
        ModConfig cfg = ConfigService.get();
        int averagingRadius = Math.max(0, cfg.averagingRadius());
        HashSet<Decoration> decorations = new HashSet<Decoration>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            int roadWidth = Math.max(1, data.width());
            List<class_2680> materials = data.materials();
            List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
            if (segments == null || segments.size() < 5) continue;
            List<class_2338> middlePositions = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            int segmentIndex = 0;
            for (int i = 2; i < segments.size() - 2; ++i) {
                class_1923 middleChunk;
                class_2338 middle = middlePositions.get(i);
                if (!processedMiddle.add(middle) || ++segmentIndex < 60 || segmentIndex > segments.size() - 60 || !(middleChunk = new class_1923(middle)).equals((Object)currentChunk)) continue;
                class_2338 prev = middlePositions.get(i - 2);
                class_2338 next = middlePositions.get(i + 2);
                ArrayList<Integer> heights = new ArrayList<Integer>();
                for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                    if (j < 0 || j >= middlePositions.size()) continue;
                    class_2338 sample = middlePositions.get(j);
                    int yTop = world.method_8624(class_2902.class_2903.field_13194, sample.method_10263(), sample.method_10260());
                    heights.add(yTop);
                }
                int averageY = heights.isEmpty() ? middle.method_10264() : (int)Math.round(heights.stream().mapToInt(Integer::intValue).average().orElse(middle.method_10264()));
                int topYCenter = world.method_8624(class_2902.class_2903.field_13194, middle.method_10263(), middle.method_10260());
                class_2338 averaged = new class_2338(middle.method_10263(), topYCenter, middle.method_10260());
                Records.RoadSegmentPlacement seg = segments.get(i);
                for (class_2338 widthBlock : seg.positions()) {
                    class_2338 pos = new class_2338(widthBlock.method_10263(), averageY, widthBlock.method_10260());
                    RoadFeature.placeOnSurface(world, pos, materials, roadType, random, cfg);
                }
                RoadFeature.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadType, roadWidth, random, cfg);
            }
        }
        RoadDecorationSystem.finalizeDecorations(decorations);
        return true;
    }

    private static void placeOnSurface(class_5281 world, class_2338 placePos, List<class_2680> material, int roadType, class_5819 random, ModConfig cfg) {
        RoadDecorationSystem.placeOnSurface(world, placePos, material, roadType, random, cfg);
    }

    private static void addDecoration(class_5281 world, Set<Decoration> out, class_2338 placePos, int segmentIndex, class_2338 nextPos, class_2338 prevPos, List<class_2338> middlePositions, int roadType, int roadWidth, class_5819 random, ModConfig cfg) {
        RoadDecorationSystem.addDecoration(world, out, placePos, segmentIndex, nextPos, prevPos, middlePositions, roadType, roadWidth, random, cfg);
    }
}

