/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration;

import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_7717;
import net.minecraft.class_8242;
import net.shiroha233.roadweaver.features.decoration.OrientedDecoration;
import net.shiroha233.roadweaver.features.decoration.util.BiomeWoodAware;
import net.shiroha233.roadweaver.helpers.Records;

public class DistanceSignDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean isStart;
    private final String signText;
    private Records.WoodAssets wood;

    public DistanceSignDecoration(class_2338 pos, class_2382 direction, class_5281 world, boolean isStart, String distanceText) {
        super(pos, direction, world);
        this.isStart = isStart;
        this.signText = distanceText;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.isStart);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        class_2338 basePos = this.getPos();
        class_5281 world = this.getWorld();
        class_2338 signPos = basePos.method_10086(2).method_10093(props.offsetDirection.method_10153());
        world.method_8652(signPos, (class_2680)((class_2680)this.wood.hangingSign().method_9564().method_11657((class_2769)class_2741.field_12532, (Comparable)Integer.valueOf(rotation))).method_11657((class_2769)class_2741.field_12493, (Comparable)Boolean.valueOf(true)), 3);
        this.updateSigns(world, signPos, this.signText);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(class_2338 pos, OrientedDecoration.DirectionProperties props) {
        class_5281 world = this.getWorld();
        world.method_8652(pos.method_10086(3).method_10093(props.offsetDirection.method_10153()), (class_2680)this.wood.fence().method_9564().method_11657((class_2769)props.directionProperty, (Comparable)Boolean.valueOf(true)), 3);
        world.method_8652(pos.method_10086(0), this.wood.fence().method_9564(), 3);
        world.method_8652(pos.method_10086(1), this.wood.fence().method_9564(), 3);
        world.method_8652(pos.method_10086(2), this.wood.fence().method_9564(), 3);
        world.method_8652(pos.method_10086(3), (class_2680)this.wood.fence().method_9564().method_11657((class_2769)props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)), 3);
    }

    private void updateSigns(class_5281 level, class_2338 pos, String text) {
        class_3218 l = level.method_8410();
        if (!(l instanceof class_3218)) {
            return;
        }
        class_3218 sLevel = l;
        sLevel.method_8503().execute(() -> {
            class_2586 be = sLevel.method_8321(pos);
            if (be instanceof class_7717) {
                class_7717 sign = (class_7717)be;
                class_8242 front = sign.method_49843(true);
                front = front.method_49857(0, (class_2561)class_2561.method_43471((String)"gui.roadweaver.sign.next_location"));
                front = front.method_49857(1, (class_2561)class_2561.method_43470((String)(text + " m")));
                front = front.method_49857(2, (class_2561)class_2561.method_43470((String)""));
                front = front.method_49857(3, (class_2561)class_2561.method_43470((String)""));
                sign.method_49840(front, true);
                class_8242 back = sign.method_49843(false);
                back = back.method_49857(0, (class_2561)class_2561.method_43470((String)"----------"));
                back = back.method_49857(1, (class_2561)class_2561.method_43471((String)"gui.roadweaver.sign.welcome"));
                back = back.method_49857(2, (class_2561)class_2561.method_43471((String)"gui.roadweaver.sign.traveller"));
                back = back.method_49857(3, (class_2561)class_2561.method_43470((String)"----------"));
                sign.method_49840(back, false);
                sign.method_5431();
            }
        });
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

