/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.config.PresetService;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.DistanceSignDecoration;
import net.shiroha233.roadweaver.features.decoration.FenceWaypointDecoration;
import net.shiroha233.roadweaver.features.decoration.LamppostDecoration;
import net.shiroha233.roadweaver.features.decoration.RoadFeatureCompat;
import net.shiroha233.roadweaver.features.decoration.RoadStructures;

public final class RoadDecorationSystem {
    private static final int SIGN_INDEX_OFFSET = 65;
    private static final int SIDE_OFFSET = 2;

    private RoadDecorationSystem() {
    }

    public static List<class_2680> selectMaterials(class_5819 rnd, RoadFeatureConfig cfg) {
        return RoadDecorationSystem.selectMaterialsFromPresets(rnd);
    }

    public static List<class_2680> selectMaterialsFromPresets(class_5819 rnd) {
        List<List<String>> combos = PresetService.getMaterialCombos();
        if (combos == null || combos.isEmpty()) {
            return List.of(class_2246.field_10056.method_9564(), class_2246.field_10093.method_9564());
        }
        List<String> chosen = combos.get(rnd.method_43048(combos.size()));
        List<class_2680> parsed = RoadDecorationSystem.parseMaterials(chosen);
        if (parsed.isEmpty()) {
            return List.of(class_2246.field_10056.method_9564());
        }
        return parsed;
    }

    private static List<class_2680> parseMaterials(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return List.of();
        }
        ArrayList<class_2680> out = new ArrayList<class_2680>(ids.size());
        for (String s : ids) {
            try {
                class_2960 rl = new class_2960(s);
                class_2248 b = (class_2248)class_7923.field_41175.method_10223(rl);
                if (b == null || b == class_2246.field_10124) continue;
                out.add(b.method_9564());
            }
            catch (Throwable throwable) {}
        }
        return out;
    }

    public static void placeOnSurface(class_5281 world, class_2338 placePos, List<class_2680> material, int roadType, class_5819 random, ModConfig cfg) {
        double naturalBlockChance = 0.5;
        class_2338 surfacePos = placePos;
        if (roadType == 1 || Math.max(0, cfg.averagingRadius()) == 0) {
            int topY = world.method_8624(class_2902.class_2903.field_13194, placePos.method_10263(), placePos.method_10260());
            surfacePos = new class_2338(placePos.method_10263(), topY, placePos.method_10260());
        }
        int topYForBelow = world.method_8624(class_2902.class_2903.field_13194, surfacePos.method_10263(), surfacePos.method_10260());
        class_2338 belowTop = new class_2338(surfacePos.method_10263(), topYForBelow - 1, surfacePos.method_10260());
        class_2680 blockStateAtPos = world.method_8320(belowTop);
        if (roadType == 0 || random.method_43058() < naturalBlockChance) {
            RoadDecorationSystem.placeRoadBlock(world, blockStateAtPos, surfacePos, material, random, cfg);
        }
    }

    public static void placeRoadBlock(class_5281 world, class_2680 blockBelow, class_2338 surfacePos, List<class_2680> materials, class_5819 random, ModConfig cfg) {
        class_2338 up;
        class_2680 blockStateUp;
        if (!RoadDecorationSystem.placeAllowedCheck(blockBelow.method_26204())) {
            return;
        }
        class_2680 chosen = materials.get(random.method_43048(materials.size()));
        int MAX_CAUSEWAY_DEPTH = 12;
        class_2338 below1 = surfacePos.method_10074();
        class_2338 below2 = surfacePos.method_10087(2);
        boolean sturdy1 = world.method_8320(below1).method_26206((class_1922)world, below1, class_2350.field_11036);
        boolean sturdy2 = world.method_8320(below2).method_26206((class_1922)world, below2, class_2350.field_11036);
        if (!sturdy1 && !sturdy2) {
            class_2338 fillStart;
            class_2338 cursor = below2;
            class_2338 base = null;
            for (int depth = 0; cursor.method_10264() > world.method_31607() && depth < 12; ++depth) {
                if (world.method_8320(cursor).method_26206((class_1922)world, cursor, class_2350.field_11036)) {
                    base = cursor;
                    break;
                }
                cursor = cursor.method_10074();
            }
            class_2338 class_23382 = fillStart = base != null ? base.method_10084() : below1.method_10087(Math.min(11, Math.max(0, below1.method_10264() - world.method_31607())));
            if (fillStart.method_10264() < world.method_31607()) {
                fillStart = new class_2338(fillStart.method_10263(), world.method_31607(), fillStart.method_10260());
            }
            class_2338 pos = fillStart;
            while (pos.method_10264() <= below1.method_10264()) {
                world.method_8652(pos, chosen, 3);
                pos = pos.method_10084();
            }
        } else {
            world.method_8652(below1, chosen, 3);
        }
        for (int i = 0; !(i >= 3 || (blockStateUp = world.method_8320(up = surfacePos.method_10086(i))).method_26215() || blockStateUp.method_26164(class_3481.field_15475) || blockStateUp.method_26164(class_3481.field_16584)); ++i) {
            world.method_8652(up, class_2246.field_10124.method_9564(), 3);
        }
        class_2338 belowPos1 = surfacePos.method_10087(2);
        class_2680 belowState1 = world.method_8320(belowPos1);
        if (belowState1.method_27852(class_2246.field_10219)) {
            world.method_8652(belowPos1, class_2246.field_10566.method_9564(), 3);
        }
    }

    public static void addDecoration(class_5281 world, Set<Decoration> out, class_2338 placePos, int segmentIndex, class_2338 nextPos, class_2338 prevPos, List<class_2338> middlePositions, int roadType, int roadWidth, class_5819 random, ModConfig cfg) {
        boolean isStart;
        int dz;
        int dx = nextPos.method_10263() - prevPos.method_10263();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.method_10260() - prevPos.method_10260()) * (double)dz);
        int nx = len != 0.0 ? (int)Math.round((double)dx / len) : 0;
        int nz = len != 0.0 ? (int)Math.round((double)dz / len) : 0;
        class_2382 dir = new class_2382(nx, 0, nz);
        class_2382 ortho = new class_2382(-dir.method_10260(), 0, dir.method_10263());
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = Math.max(2, halfWidth + 1);
        boolean bl = isStart = segmentIndex == 65;
        if (segmentIndex == 65 || segmentIndex == middlePositions.size() - 65) {
            class_2338 shifted = isStart ? placePos.method_10069(ortho.method_10263() * sideOffset, 0, ortho.method_10260() * sideOffset) : placePos.method_10069(-ortho.method_10263() * sideOffset, 0, -ortho.method_10260() * sideOffset);
            int dist = RoadDecorationSystem.computeApproxDistanceMeters(world, shifted, isStart, middlePositions);
            out.add(new DistanceSignDecoration(shifted, ortho, world, isStart, String.valueOf(dist)));
        } else {
            int interval = Math.max(1, cfg.lampInterval());
            if (segmentIndex % interval == 0) {
                boolean left = random.method_43056();
                class_2338 shifted = left ? placePos.method_10069(ortho.method_10263() * sideOffset, 0, ortho.method_10260() * sideOffset) : placePos.method_10069(-ortho.method_10263() * sideOffset, 0, -ortho.method_10260() * sideOffset);
                if (Math.abs((shifted = new class_2338(shifted.method_10263(), world.method_8624(class_2902.class_2903.field_13194, shifted.method_10263(), shifted.method_10260()), shifted.method_10260())).method_10264() - placePos.method_10264()) > 1) {
                    return;
                }
                if (roadType == 0) {
                    out.add(new LamppostDecoration(shifted, ortho, world, left));
                } else {
                    out.add(new FenceWaypointDecoration(shifted, world));
                }
            }
        }
    }

    public static void finalizeDecorations(Set<Decoration> decorations) {
        RoadStructures.tryPlaceDecorations(decorations);
    }

    public static int computeApproxDistanceMeters(class_5281 world, class_2338 fromPos, boolean isStart, List<class_2338> middlePositions) {
        class_2338 target = isStart ? middlePositions.get(middlePositions.size() - 1) : middlePositions.get(0);
        long dx = (long)target.method_10263() - (long)fromPos.method_10263();
        long dz = (long)target.method_10260() - (long)fromPos.method_10260();
        double d = Math.sqrt((double)dx * (double)dx + (double)dz * (double)dz);
        return (int)Math.round(d);
    }

    private static boolean placeAllowedCheck(class_2248 block) {
        return !RoadFeatureCompat.dontPlaceHere(block) && !block.method_9564().method_26164(class_3481.field_15503) && !block.method_9564().method_26164(class_3481.field_15475) && !block.method_9564().method_26164(class_3481.field_15496) && !block.method_9564().method_26164(class_3481.field_17619) && !block.method_9564().method_26164(class_3481.field_15471);
    }
}

