/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.system.RoadDecorationSystem;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public final class Road {
    private final class_3218 level;
    private final Records.StructureConnection connection;
    private final RoadFeatureConfig config;

    public Road(class_3218 level, Records.StructureConnection connection, RoadFeatureConfig config) {
        this.level = level;
        this.connection = connection;
        this.config = config;
    }

    public void generateRoad(int maxSteps) {
        class_2338 end;
        class_5819 random = class_5819.method_43047();
        int width = ConfigService.get().roadWidth() > 0 ? ConfigService.get().roadWidth() : Road.getRandomWidth(random, this.config);
        ModConfig cfg = ConfigService.get();
        if (!cfg.allowArtificial()) {
            return;
        }
        int type = 0;
        List<class_2680> materials = RoadDecorationSystem.selectMaterials(random, this.config);
        class_2338 start = this.connection.from();
        List<Records.RoadSegmentPlacement> segments = RoadPathCalculator.calculateAStarRoadPath(start, end = this.connection.to(), width, this.level, maxSteps);
        if (segments == null || segments.size() < 5) {
            return;
        }
        List<Records.RoadSpan> spans = RoadPathCalculator.extractSpans(segments, this.level);
        WorldDataProvider provider = WorldDataProvider.getInstance();
        ArrayList<Records.RoadData> list = new ArrayList<Records.RoadData>(provider.getRoadDataList(this.level));
        list.add(new Records.RoadData(width, type, materials, segments, spans));
        provider.setRoadDataList(this.level, list);
    }

    private static int getRandomWidth(class_5819 rnd, RoadFeatureConfig cfg) {
        return 3;
    }
}

