/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.helpers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;

public final class StructureConnector {
    private static final Queue<Records.StructureConnection> CACHED = new ArrayDeque<Records.StructureConnection>();

    private StructureConnector() {
    }

    public static Queue<Records.StructureConnection> cachedStructureConnections() {
        return CACHED;
    }

    public static void cacheNewConnection(class_3218 level, boolean locateAtPlayerIgnored) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData data = provider.getStructureLocations(level);
        List<class_2338> list = data.structureLocations();
        if (list == null || list.size() < 2) {
            return;
        }
        StructureConnector.createNewStructureConnection(level);
    }

    private static void createNewStructureConnection(class_3218 level) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData data = provider.getStructureLocations(level);
        List<class_2338> all = data.structureLocations();
        if (all == null || all.size() < 2) {
            return;
        }
        class_2338 latest = all.get(all.size() - 1);
        class_2338 closest = StructureConnector.findClosest(latest, all);
        if (closest == null) {
            return;
        }
        ArrayList<Records.StructureConnection> connections = new ArrayList<Records.StructureConnection>(provider.getStructureConnections(level));
        if (!StructureConnector.exists(connections, latest, closest)) {
            Records.StructureConnection c = new Records.StructureConnection(latest, closest, Records.ConnectionStatus.PLANNED);
            connections.add(c);
            provider.setStructureConnections(level, connections);
            CACHED.add(c);
        }
    }

    private static boolean exists(List<Records.StructureConnection> existing, class_2338 a, class_2338 b) {
        for (Records.StructureConnection c : existing) {
            if ((!c.from().equals((Object)a) || !c.to().equals((Object)b)) && (!c.from().equals((Object)b) || !c.to().equals((Object)a))) continue;
            return true;
        }
        return false;
    }

    private static class_2338 findClosest(class_2338 cur, List<class_2338> all) {
        class_2338 best = null;
        double min = Double.MAX_VALUE;
        for (class_2338 p : all) {
            double d;
            if (p.equals((Object)cur) || !((d = cur.method_10262((class_2382)p)) < min)) continue;
            min = d;
            best = p;
        }
        return best;
    }
}

