/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network.fabric;

import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.shiroha233.roadweaver.client.map.MapDataCollector;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.client.map.RoadMapScreen;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.network.MapSnapshotCodec;

public class MapNetworkFabric {
    public static final class_2960 REQ = new class_2960("roadweaver", "map_request");
    public static final class_2960 REQ_RECT = new class_2960("roadweaver", "map_request_rect");
    public static final class_2960 SNAP = new class_2960("roadweaver", "map_snapshot");
    public static final class_2960 TP_REQ = new class_2960("roadweaver", "map_teleport");
    public static final class_2960 TP_ACK = new class_2960("roadweaver", "map_teleport_ack");

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQ, (server, player, handler, buf, responseSender) -> server.execute(() -> {
            int radiusChunks;
            class_3222 sp = player;
            int cx = (int)Math.round(sp.method_23317());
            int cz = (int)Math.round(sp.method_23321());
            try {
                ModConfig cfg = ConfigService.get();
                radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
            }
            catch (Throwable t) {
                radiusChunks = 256;
            }
            int radiusBlocks = Math.max(1, radiusChunks) * 16;
            int minX = cx - radiusBlocks;
            int minZ = cz - radiusBlocks;
            int maxX = cx + radiusBlocks;
            int maxZ = cz + radiusBlocks;
            MapSnapshot snap = MapDataCollector.build(sp.method_51469(), minX, minZ, maxX, maxZ, cx, cz, radiusBlocks);
            class_2540 out = new class_2540(Unpooled.buffer());
            MapSnapshotCodec.write(out, snap);
            ServerPlayNetworking.send((class_3222)sp, (class_2960)SNAP, (class_2540)out);
        }));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQ_RECT, (server, player, handler, buf, responseSender) -> {
            int minX = buf.method_10816();
            int minZ = buf.method_10816();
            int maxX = buf.method_10816();
            int maxZ = buf.method_10816();
            server.execute(() -> {
                int radiusChunks;
                class_3222 sp = player;
                int cx = (int)Math.round(sp.method_23317());
                int cz = (int)Math.round(sp.method_23321());
                try {
                    ModConfig cfg = ConfigService.get();
                    radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
                }
                catch (Throwable t) {
                    radiusChunks = 256;
                }
                int radiusBlocks = Math.max(1, radiusChunks) * 16;
                MapSnapshot snap = MapDataCollector.build(sp.method_51469(), minX, minZ, maxX, maxZ, cx, cz, radiusBlocks);
                class_2540 out = new class_2540(Unpooled.buffer());
                MapSnapshotCodec.write(out, snap);
                ServerPlayNetworking.send((class_3222)sp, (class_2960)SNAP, (class_2540)out);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TP_REQ, (server, player, handler, buf, responseSender) -> {
            int x = buf.method_10816();
            buf.method_10816();
            int z = buf.method_10816();
            server.execute(() -> {
                boolean allowed;
                class_3222 sp = player;
                boolean bl = allowed = sp.method_7337() || sp.method_5687(2);
                if (!allowed) {
                    class_2540 out = new class_2540(Unpooled.buffer());
                    out.writeBoolean(false);
                    ServerPlayNetworking.send((class_3222)sp, (class_2960)TP_ACK, (class_2540)out);
                    return;
                }
                class_3218 level = sp.method_51469();
                level.method_8497(x >> 4, z >> 4);
                int ty = level.method_8624(class_2902.class_2903.field_13203, x, z);
                ty = ty <= level.method_31607() ? level.method_8615() + 1 : ++ty;
                sp.method_14251(level, (double)x + 0.5, (double)ty, (double)z + 0.5, sp.method_36454(), sp.method_36455());
                class_2540 out = new class_2540(Unpooled.buffer());
                out.writeBoolean(true);
                out.method_10804(x);
                out.method_10804(ty);
                out.method_10804(z);
                ServerPlayNetworking.send((class_3222)sp, (class_2960)TP_ACK, (class_2540)out);
            });
        });
    }

    public static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SNAP, (client, handler, buf, responseSender) -> {
            MapSnapshot s = MapSnapshotCodec.read(buf);
            client.execute(() -> {
                class_437 patt5511$temp = client.field_1755;
                if (patt5511$temp instanceof RoadMapScreen) {
                    RoadMapScreen screen = (RoadMapScreen)patt5511$temp;
                    screen.setSnapshot(s);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TP_ACK, (client, handler, buf, responseSender) -> {
            boolean ok = buf.readBoolean();
            int rx = 0;
            int ry = 0;
            int rz = 0;
            if (ok) {
                rx = buf.method_10816();
                ry = buf.method_10816();
                rz = buf.method_10816();
            }
            int fx = rx;
            int fy = ry;
            int fz = rz;
            client.execute(() -> {
                if (client.field_1724 == null) {
                    return;
                }
                if (ok) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"gui.roadweaver.map.teleport.success_pos", (Object[])new Object[]{fx, fy, fz}), true);
                } else {
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"gui.roadweaver.map.teleport.denied"), true);
                }
            });
        });
    }

    public static void requestSnapshot(int minX, int minZ, int maxX, int maxZ) {
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10804(minX);
        out.method_10804(minZ);
        out.method_10804(maxX);
        out.method_10804(maxZ);
        ClientPlayNetworking.send((class_2960)REQ_RECT, (class_2540)out);
    }

    public static void requestTeleport(int x, int y, int z) {
        class_2540 out = new class_2540(Unpooled.buffer());
        out.method_10804(x);
        out.method_10804(y);
        out.method_10804(z);
        ClientPlayNetworking.send((class_2960)TP_REQ, (class_2540)out);
    }
}

