/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.planning;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.planning.PlanningUtils;

public final class DelaunayPlanner {
    private DelaunayPlanner() {
    }

    public static List<Records.StructureConnection> planDelaunay(List<class_2338> points, int maxEdgeLenBlocks) {
        if (points == null || points.size() < 2) {
            return List.of();
        }
        ArrayList<class_2338> unique = new ArrayList<class_2338>();
        HashSet<Long> seen = new HashSet<Long>();
        for (class_2338 p : points) {
            long k = PlanningUtils.pos2dKey(new class_2338(p.method_10263(), 0, p.method_10260()));
            if (!seen.add(k)) continue;
            unique.add(new class_2338(p.method_10263(), 0, p.method_10260()));
        }
        if (unique.size() < 2) {
            return List.of();
        }
        Bounds b = DelaunayPlanner.bounds(unique);
        double dx = b.maxX - b.minX;
        double dz = b.maxZ - b.minZ;
        double delta = Math.max(dx, dz);
        if (delta <= 0.0) {
            delta = 1.0;
        }
        double cx = (b.minX + b.maxX) * 0.5;
        double cz = (b.minZ + b.maxZ) * 0.5;
        Vertex v1 = new Vertex(cx - 2.0 * delta, cz - delta);
        Vertex v2 = new Vertex(cx, cz + 2.0 * delta);
        Vertex v3 = new Vertex(cx + 2.0 * delta, cz - delta);
        int n = unique.size();
        ArrayList<Vertex> verts = new ArrayList<Vertex>(n + 3);
        for (class_2338 p : unique) {
            verts.add(new Vertex(p.method_10263(), p.method_10260()));
        }
        verts.add(v1);
        verts.add(v2);
        verts.add(v3);
        int s1 = n;
        int s2 = n + 1;
        int s3 = n + 2;
        ArrayList<Tri> tris = new ArrayList<Tri>();
        tris.add(new Tri(s1, s2, s3));
        for (int i = 0; i < n; ++i) {
            Vertex p = (Vertex)verts.get(i);
            ArrayList<Tri> bad = new ArrayList<Tri>();
            for (Tri t2 : tris) {
                if (t2.invalid || !DelaunayPlanner.inCircumcircle(verts, t2, p)) continue;
                bad.add(t2);
            }
            ArrayList<Edge> polygon = new ArrayList<Edge>();
            for (Tri t3 : bad) {
                t3.invalid = true;
                DelaunayPlanner.addOrRemove(polygon, new Edge(t3.a, t3.b));
                DelaunayPlanner.addOrRemove(polygon, new Edge(t3.b, t3.c));
                DelaunayPlanner.addOrRemove(polygon, new Edge(t3.c, t3.a));
            }
            tris.removeIf(tr -> tr.invalid);
            for (Edge e : polygon) {
                tris.add(new Tri(e.u, e.v, i));
            }
        }
        tris.removeIf(t -> t.contains(s1) || t.contains(s2) || t.contains(s3));
        long maxD2 = maxEdgeLenBlocks > 0 ? (long)maxEdgeLenBlocks * (long)maxEdgeLenBlocks : Long.MAX_VALUE;
        HashSet<Long> edgeKeys = new HashSet<Long>();
        ArrayList<Records.StructureConnection> out = new ArrayList<Records.StructureConnection>();
        for (Tri t3 : tris) {
            DelaunayPlanner.addEdge(out, edgeKeys, unique, t3.a, t3.b, maxD2);
            DelaunayPlanner.addEdge(out, edgeKeys, unique, t3.b, t3.c, maxD2);
            DelaunayPlanner.addEdge(out, edgeKeys, unique, t3.c, t3.a, maxD2);
        }
        return out;
    }

    private static void addEdge(List<Records.StructureConnection> out, Set<Long> keys, List<class_2338> pts, int ia, int ib, long maxD2) {
        long dz;
        int b;
        if (ia >= pts.size() || ib >= pts.size()) {
            return;
        }
        int a = Math.min(ia, ib);
        long key = (long)a << 32 ^ (long)(b = Math.max(ia, ib));
        if (!keys.add(key)) {
            return;
        }
        class_2338 pa = pts.get(ia);
        class_2338 pb = pts.get(ib);
        long dx = (long)pa.method_10263() - (long)pb.method_10263();
        long d2 = dx * dx + (dz = (long)pa.method_10260() - (long)pb.method_10260()) * dz;
        if (d2 > maxD2) {
            return;
        }
        out.add(new Records.StructureConnection(pa, pb));
    }

    private static void addOrRemove(List<Edge> polygon, Edge e) {
        int idx = -1;
        for (int i = 0; i < polygon.size(); ++i) {
            if (!polygon.get(i).equals(e)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            polygon.remove(idx);
        } else {
            polygon.add(e);
        }
    }

    private static boolean inCircumcircle(List<Vertex> verts, Tri t, Vertex p) {
        Vertex a = verts.get(t.a);
        Vertex b = verts.get(t.b);
        Vertex c = verts.get(t.c);
        double area2 = (b.x - a.x) * (c.z - a.z) - (b.z - a.z) * (c.x - a.x);
        if (Math.abs(area2) < 1.0E-6) {
            return false;
        }
        double ax = a.x - p.x;
        double ay = a.z - p.z;
        double bx = b.x - p.x;
        double by = b.z - p.z;
        double cx = c.x - p.x;
        double cy = c.z - p.z;
        double det = (ax * ax + ay * ay) * (bx * cy - by * cx) - (bx * bx + by * by) * (ax * cy - ay * cx) + (cx * cx + cy * cy) * (ax * by - ay * bx);
        if (area2 > 0.0) {
            return det > 1.0E-6;
        }
        return det < -1.0E-6;
    }

    private static Bounds bounds(List<class_2338> pts) {
        double minX = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (class_2338 p : pts) {
            if ((double)p.method_10263() < minX) {
                minX = p.method_10263();
            }
            if ((double)p.method_10260() < minZ) {
                minZ = p.method_10260();
            }
            if ((double)p.method_10263() > maxX) {
                maxX = p.method_10263();
            }
            if (!((double)p.method_10260() > maxZ)) continue;
            maxZ = p.method_10260();
        }
        return new Bounds(minX, minZ, maxX, maxZ);
    }

    private static final class Bounds {
        final double minX;
        final double minZ;
        final double maxX;
        final double maxZ;

        Bounds(double minX, double minZ, double maxX, double maxZ) {
            this.minX = minX;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxZ = maxZ;
        }
    }

    private static final class Vertex {
        final double x;
        final double z;

        Vertex(double x, double z) {
            this.x = x;
            this.z = z;
        }
    }

    private static final class Tri {
        final int a;
        final int b;
        final int c;
        boolean invalid;

        Tri(int a, int b, int c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        boolean contains(int v) {
            return this.a == v || this.b == v || this.c == v;
        }
    }

    private static final class Edge {
        final int u;
        final int v;

        Edge(int a, int b) {
            if (a < b) {
                this.u = a;
                this.v = b;
            } else {
                this.u = b;
                this.v = a;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge e = (Edge)o;
            return this.u == e.u && this.v == e.v;
        }

        public int hashCode() {
            return this.u * 73471 ^ this.v;
        }
    }
}

