/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.planning;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.shiroha233.roadweaver.client.map.MapDataCollector;
import net.shiroha233.roadweaver.client.map.MapSnapshot;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.planning.DelaunayPlanner;
import net.shiroha233.roadweaver.planning.KNNPlanner;
import net.shiroha233.roadweaver.planning.PlanningUtils;
import net.shiroha233.roadweaver.planning.RNGPlanner;

public final class RoadPlanningService {
    private static final ConcurrentHashMap<class_1937, Set<Long>> PLANNED_TILES = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_1937, ConcurrentHashMap<Long, Long>> PLANNED_TILE_CENTERS = new ConcurrentHashMap();

    private RoadPlanningService() {
    }

    public static void initialPlan(class_3218 level) {
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return;
        }
        ModConfig cfg = ConfigService.get();
        int radiusChunks = Math.max(1, cfg.initialPlanRadiusChunks());
        class_2338 spawn = level.method_43126();
        int cx = spawn.method_10263() >> 4;
        int cz = spawn.method_10260() >> 4;
        int minX = (cx - radiusChunks) * 16;
        int maxX = (cx + radiusChunks) * 16;
        int minZ = (cz - radiusChunks) * 16;
        int maxZ = (cz + radiusChunks) * 16;
        RoadPlanningService.planRect(level, minX, minZ, maxX, maxZ);
    }

    public static void planAroundPlayer(class_3222 player) {
        if (player == null) {
            return;
        }
        class_3218 level = player.method_51469();
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return;
        }
        ModConfig cfg = ConfigService.get();
        if (!cfg.dynamicPlanEnabled()) {
            return;
        }
        int radiusChunks = Math.max(1, cfg.dynamicPlanRadiusChunks());
        int stride = Math.max(1, cfg.dynamicPlanStrideChunks());
        int tile = Math.max(8, Math.min(256, stride));
        int pcx = player.method_31476().field_9181;
        int pcz = player.method_31476().field_9180;
        int kx = RoadPlanningService.floorDiv(pcx, tile);
        int kz = RoadPlanningService.floorDiv(pcz, tile);
        long key = (long)kx << 32 ^ (long)kz & 0xFFFFFFFFL;
        Set set = PLANNED_TILES.computeIfAbsent((class_1937)level, l -> ConcurrentHashMap.newKeySet());
        boolean isNewTile = set.add(key);
        ConcurrentHashMap centers = PLANNED_TILE_CENTERS.computeIfAbsent((class_1937)level, l -> new ConcurrentHashMap());
        centers.putIfAbsent(key, (long)pcx << 32 ^ (long)pcz & 0xFFFFFFFFL);
        if (!isNewTile) {
            return;
        }
        int minX = (pcx - radiusChunks) * 16;
        int maxX = (pcx + radiusChunks) * 16;
        int minZ = (pcz - radiusChunks) * 16;
        int maxZ = (pcz + radiusChunks) * 16;
        RoadPlanningService.planRect(level, minX, minZ, maxX, maxZ);
    }

    private static void planRect(class_3218 level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        MapSnapshot snap = MapDataCollector.build(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ);
        ArrayList<class_2338> points = new ArrayList<class_2338>();
        HashSet<Long> seenPos = new HashSet<Long>();
        for (class_2338 p : snap.structures()) {
            class_2338 q = new class_2338(p.method_10263(), 0, p.method_10260());
            long key = PlanningUtils.pos2dKey(q);
            if (!seenPos.add(key)) continue;
            points.add(q);
        }
        if (points.size() < 2) {
            return;
        }
        ModConfig cfg0 = ConfigService.get();
        List<Records.StructureConnection> primaryEdges = cfg0.planningAlgorithm() == ModConfig.PlanningAlgorithm.DELAUNAY ? DelaunayPlanner.planDelaunay(points, 2048) : (cfg0.planningAlgorithm() == ModConfig.PlanningAlgorithm.RNG ? RNGPlanner.planRNG(points, 2048) : KNNPlanner.planKNN(points, 2, 2048, 1.8, 40.0, 2));
        if (primaryEdges.isEmpty()) {
            return;
        }
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> existing = provider.getStructureConnections(level);
        HashSet<class_2338> inRect = new HashSet<class_2338>(points);
        ArrayList<Records.StructureConnection> existingInRect = new ArrayList<Records.StructureConnection>();
        if (existing != null) {
            for (Records.StructureConnection c : existing) {
                if (!inRect.contains(c.from()) || !inRect.contains(c.to())) continue;
                existingInRect.add(c);
            }
        }
        ArrayList<Records.StructureConnection> base = new ArrayList<Records.StructureConnection>(existingInRect);
        base.addAll(primaryEdges);
        List<Records.StructureConnection> bridges = KNNPlanner.connectComponents(points, base, 1536, 35.0, 3);
        ArrayList<Records.StructureConnection> incoming = new ArrayList<Records.StructureConnection>(primaryEdges);
        incoming.addAll(bridges);
        List<Records.StructureConnection> merged = RoadPlanningService.mergeConnections(existing, incoming);
        if (merged.size() != existing.size()) {
            provider.setStructureConnections(level, merged);
        }
    }

    private static List<Records.StructureConnection> mergeConnections(List<Records.StructureConnection> existing, List<Records.StructureConnection> incoming) {
        long k;
        HashSet<Long> seen = new HashSet<Long>();
        ArrayList<Records.StructureConnection> out = new ArrayList<Records.StructureConnection>();
        if (existing != null) {
            for (Records.StructureConnection c : existing) {
                k = PlanningUtils.edgeKey(c.from(), c.to());
                if (!seen.add(k)) continue;
                out.add(c);
            }
        }
        for (Records.StructureConnection c : incoming) {
            k = PlanningUtils.edgeKey(c.from(), c.to());
            if (!seen.add(k)) continue;
            out.add(new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.PLANNED));
        }
        return out;
    }

    private static int floorDiv(int a, int b) {
        int r = a / b;
        if ((a ^ b) < 0 && r * b != a) {
            --r;
        }
        return r;
    }

    public static Set<Long> getPlannedTiles(class_3218 level) {
        Set<Long> s = PLANNED_TILES.get(level);
        return s != null ? Set.copyOf(s) : Set.of();
    }

    public static Map<Long, Long> getPlannedTileCenters(class_3218 level) {
        ConcurrentHashMap<Long, Long> m = PLANNED_TILE_CENTERS.get(level);
        if (m == null || m.isEmpty()) {
            return Map.of();
        }
        return Map.copyOf(m);
    }

    public static int getStrideTileSizeChunks() {
        ModConfig cfg = ConfigService.get();
        int stride = Math.max(1, cfg.dynamicPlanStrideChunks());
        return Math.max(8, Math.min(256, stride));
    }

    public static int getDynamicPlanRadiusChunks() {
        ModConfig cfg = ConfigService.get();
        return Math.max(1, cfg.dynamicPlanRadiusChunks());
    }
}

