/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.interaction;

import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;

public final class MapInteraction {
    private MapInteraction() {
    }

    public static void renderHoverHighlight(class_332 g, MapSnapshot snapshot, MapView view, int mapX, int mapY, int mapW, int mapH, int innerPad, double mouseX, double mouseY) {
        double mx = mouseX;
        double my = mouseY;
        if (!MapInteraction.insideMap(mx, my, mapX, mapY, mapW, mapH, innerPad)) {
            return;
        }
        int bestDist = Integer.MAX_VALUE;
        class_2338 best = null;
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        for (class_2338 p : snapshot.structures()) {
            int dy;
            if (!view.isInViewWorld(p.method_10263(), p.method_10260())) continue;
            int x = view.toScreenX(p.method_10263(), mapX, innerPad, contentW);
            int y = view.toScreenY(p.method_10260(), mapY, innerPad, contentH);
            int dx = (int)Math.abs((double)x - mx);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - my)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            int x = view.toScreenX(best.method_10263(), mapX, innerPad, contentW);
            int y = view.toScreenY(best.method_10260(), mapY, innerPad, contentH);
            g.method_25294(x - 4, y - 4, x + 5, y + 5, -855648945);
        }
    }

    public static void renderHoverTooltip(class_332 g, class_327 font, MapSnapshot snapshot, MapView view, int mapX, int mapY, int mapW, int mapH, int innerPad, double mouseX, double mouseY) {
        double mx = mouseX;
        double my = mouseY;
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        if (!MapInteraction.insideMap(mx, my, mapX, mapY, mapW, mapH, innerPad)) {
            int wx = (int)Math.round(view.screenToWorldX(mx, mapX, innerPad, contentW));
            int wz = (int)Math.round(view.screenToWorldZ(my, mapY, innerPad, contentH));
            g.method_51438(font, (class_2561)class_2561.method_43469((String)"gui.roadweaver.map.coord", (Object[])new Object[]{wx, wz}), (int)mx, (int)my);
            return;
        }
        int bestDist = Integer.MAX_VALUE;
        class_2338 best = null;
        for (class_2338 p : snapshot.structures()) {
            int dy;
            if (!view.isInViewWorld(p.method_10263(), p.method_10260())) continue;
            int x = view.toScreenX(p.method_10263(), mapX, innerPad, contentW);
            int y = view.toScreenY(p.method_10260(), mapY, innerPad, contentH);
            int dx = (int)Math.abs((double)x - mx);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - my)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            String name = snapshot.structureName(best);
            String alias = ClientMapNotes.getAlias(best);
            class_5250 coords = class_2561.method_43469((String)"gui.roadweaver.map.coord", (Object[])new Object[]{best.method_10263(), best.method_10260()});
            class_5250 label = alias != null ? class_2561.method_43470((String)alias).method_27693(" ").method_10852((class_2561)coords) : (name != null ? class_2561.method_43470((String)name).method_27693(" ").method_10852((class_2561)coords) : coords);
            g.method_51438(font, (class_2561)label, (int)mx, (int)my);
        } else {
            int wx = (int)Math.round(view.screenToWorldX(mx, mapX, innerPad, contentW));
            int wz = (int)Math.round(view.screenToWorldZ(my, mapY, innerPad, contentH));
            g.method_51438(font, (class_2561)class_2561.method_43469((String)"gui.roadweaver.map.coord", (Object[])new Object[]{wx, wz}), (int)mx, (int)my);
        }
    }

    private static boolean insideMap(double x, double y, int mapX, int mapY, int mapW, int mapH, int innerPad) {
        return x >= (double)(mapX + innerPad) && x <= (double)(mapX + mapW - innerPad) && y >= (double)(mapY + innerPad) && y <= (double)(mapY + mapH - innerPad);
    }
}

