/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.search.StructurePredictor;

public final class StructureRoadOffsetService {
    private static final int MATCH_TOLERANCE_BLOCKS = 16;

    private StructureRoadOffsetService() {
    }

    @Deprecated
    public static class_2338 adjustEndpoint(class_3218 level, class_2338 endpoint, class_2338 otherEnd) {
        return endpoint;
    }

    public static List<Records.RoadSegmentPlacement> trimPathNearStructure(class_3218 level, List<Records.RoadSegmentPlacement> segments, class_2338 rawStart, class_2338 rawEnd) {
        long distSq;
        long dz;
        long dx;
        class_2338 pos;
        int i;
        long offsetSq;
        if (segments == null || segments.size() < 3) {
            return segments;
        }
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return segments;
        }
        int startOffset = StructureRoadOffsetService.getOffsetBlocksForEndpoint(level, rawStart);
        int endOffset = StructureRoadOffsetService.getOffsetBlocksForEndpoint(level, rawEnd);
        if (startOffset <= 0 && endOffset <= 0) {
            return segments;
        }
        int n = segments.size();
        int trimStart = 0;
        int trimEnd = n;
        if (startOffset > 0) {
            offsetSq = (long)startOffset * (long)startOffset;
            for (i = 0; i < n; ++i) {
                pos = segments.get(i).middlePos();
                dx = (long)pos.method_10263() - (long)rawStart.method_10263();
                distSq = dx * dx + (dz = (long)pos.method_10260() - (long)rawStart.method_10260()) * dz;
                if (distSq < offsetSq) continue;
                trimStart = i;
                break;
            }
        }
        if (endOffset > 0) {
            offsetSq = (long)endOffset * (long)endOffset;
            for (i = n - 1; i >= 0; --i) {
                pos = segments.get(i).middlePos();
                dx = (long)pos.method_10263() - (long)rawEnd.method_10263();
                distSq = dx * dx + (dz = (long)pos.method_10260() - (long)rawEnd.method_10260()) * dz;
                if (distSq < offsetSq) continue;
                trimEnd = i + 1;
                break;
            }
        }
        if (trimStart >= trimEnd || trimEnd - trimStart < 3) {
            int mid = n / 2;
            trimStart = Math.max(0, mid - 2);
            trimEnd = Math.min(n, mid + 3);
        }
        return new ArrayList<Records.RoadSegmentPlacement>(segments.subList(trimStart, trimEnd));
    }

    public static int getOffsetBlocksForEndpoint(class_3218 level, class_2338 endpoint) {
        StructureCategory cat = StructureRoadOffsetService.detectCategory(level, endpoint);
        int configOffset = ConfigService.get().structureRoadOffset();
        return switch (cat) {
            case StructureCategory.VILLAGE -> configOffset;
            default -> 0;
        };
    }

    private static StructureCategory detectCategory(class_3218 level, class_2338 endpoint) {
        int cz;
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return StructureCategory.UNKNOWN;
        }
        int cx = endpoint.method_10263() >> 4;
        List<Records.StructureInfo> infos = StructurePredictor.predictOverworldStructuresInRect(level, cx, cz = endpoint.method_10260() >> 4, cx, cz, true, List.of("#minecraft:village"), List.of());
        if (infos == null || infos.isEmpty()) {
            return StructureCategory.UNKNOWN;
        }
        long tol2 = 256L;
        for (Records.StructureInfo info : infos) {
            long dz;
            class_2338 p = info.pos();
            long dx = (long)p.method_10263() - (long)endpoint.method_10263();
            long d2 = dx * dx + (dz = (long)p.method_10260() - (long)endpoint.method_10260()) * dz;
            if (d2 > tol2) continue;
            return StructureCategory.VILLAGE;
        }
        return StructureCategory.UNKNOWN;
    }

    private static enum StructureCategory {
        VILLAGE,
        OTHER,
        UNKNOWN;

    }
}

