/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.PathPostProcessor;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;

final class GradientDescentPathfinder {
    private static final int BIOME_BASE_COST = 12;
    private static final int SEARCH_BUFFER = 64;

    private GradientDescentPathfinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Records.RoadSegmentPlacement> calculatePath(class_2338 startGround, class_2338 endGround, int width, class_3218 level, int maxSteps, TerrainSamplingCache cache) {
        ModConfig cfg = ConfigService.get();
        int minX = Math.min(startGround.method_10263(), endGround.method_10263()) - 64;
        int maxX = Math.max(startGround.method_10263(), endGround.method_10263()) + 64;
        int minZ = Math.min(startGround.method_10260(), endGround.method_10260()) - 64;
        int maxZ = Math.max(startGround.method_10260(), endGround.method_10260()) + 64;
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.fCost));
        HashMap<class_2338, Node> allNodes = new HashMap<class_2338, Node>();
        HashSet<class_2338> closed = new HashSet<class_2338>();
        Node startNode = new Node(startGround, null, 0.0, GradientDescentPathfinder.heuristic(startGround, endGround) * cfg.heuristicWeight());
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = RoadPathCalculator.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        int stepsBudget = Math.max(5000, maxSteps * 3);
        ThreadPoolManager.resetThrottle();
        try {
            while (!openSet.isEmpty() && stepsBudget-- > 0) {
                ThreadPoolManager.throttle();
                if (Thread.currentThread().isInterrupted()) {
                    List<Records.RoadSegmentPlacement> list = null;
                    return list;
                }
                Node current = openSet.poll();
                if (current == null) {
                    break;
                }
                if ((double)GradientDescentPathfinder.manhattan2d(current.pos, endGround) < (double)d * 1.5) {
                    List<Records.RoadSegmentPlacement> list = GradientDescentPathfinder.reconstructPath(current, width, level, cache);
                    return list;
                }
                closed.add(current.pos);
                for (Object object : (List<Records.RoadSegmentPlacement>)neighborOffsets) {
                    class_2338 nxz = current.pos.method_10069((int)object[0], 0, (int)object[1]);
                    if (nxz.method_10263() < minX || nxz.method_10263() > maxX || nxz.method_10260() < minZ || nxz.method_10260() > maxZ) continue;
                    int y = RoadPathCalculator.heightSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
                    class_2338 np = new class_2338(nxz.method_10263(), y, nxz.method_10260());
                    if (closed.contains(np)) continue;
                    class_6880<class_1959> biome = cache.getBiome(level, np.method_10263(), np.method_10260());
                    int biomeCost = biome.method_40220(class_6908.field_36511) || biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36508) ? 12 : 0;
                    int elevation = Math.abs(y - current.pos.method_10264());
                    int offsetSum = Math.abs(Math.abs((int)object[0])) + Math.abs((int)object[1]);
                    double stepCost = offsetSum == 2 * d ? cfg.diagStepCost() : cfg.orthoStepCost();
                    int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level, d);
                    int sea = level.method_8615();
                    boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.method_10263(), nxz.method_10260(), level);
                    boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.method_10263(), nxz.method_10260(), level);
                    int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
                    int waterDepth = Math.max(0, sea - oceanFloor);
                    int waterDepthCost = waterColumn ? waterDepth * cfg.waterDepthWeight() : 0;
                    int nearWaterCost = nearWater ? cfg.nearWaterCost() : 0;
                    double elevationCost = elevation * elevation * cfg.elevationWeight();
                    double slope = (double)elevation / (double)Math.max(1, d);
                    if (slope > 0.5) {
                        elevationCost += 800.0 * slope;
                    }
                    if (slope > 0.8) {
                        elevationCost += 8000.0;
                    }
                    double gCost = current.gCost + stepCost + elevationCost + (double)(biomeCost * cfg.biomeWeight()) + (double)(stabilityCost * cfg.stabilityWeight()) + (double)waterDepthCost + (double)nearWaterCost;
                    double hCost = GradientDescentPathfinder.heuristic(np, endGround) * cfg.heuristicWeight();
                    double fCost = gCost + hCost;
                    Node n2 = (Node)allNodes.get(np);
                    if (n2 != null && !(gCost < n2.gCost)) continue;
                    n2 = new Node(np, current, gCost, fCost);
                    allNodes.put(np, n2);
                    openSet.add(n2);
                }
            }
        }
        finally {
            openSet.clear();
            allNodes.clear();
            closed.clear();
        }
        return null;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, class_3218 level, TerrainSamplingCache cache) {
        ArrayList<class_2338> rawPath = new ArrayList<class_2338>();
        Node c = endNode;
        while (c != null) {
            rawPath.add(c.pos);
            c = c.parent;
        }
        Collections.reverse(rawPath);
        return PathPostProcessor.process(rawPath, width, level, cache);
    }

    private static int manhattan2d(class_2338 a, class_2338 b) {
        return Math.abs(a.method_10263() - b.method_10263()) + Math.abs(a.method_10260() - b.method_10260());
    }

    private static double heuristic(class_2338 a, class_2338 b) {
        double dx = a.method_10263() - b.method_10263();
        double dz = a.method_10260() - b.method_10260();
        return Math.sqrt(dx * dx + dz * dz);
    }

    private static final class Node {
        final class_2338 pos;
        final Node parent;
        final double gCost;
        final double fCost;

        Node(class_2338 pos, Node parent, double gCost, double fCost) {
            this.pos = pos;
            this.parent = parent;
            this.gCost = gCost;
            this.fCost = fCost;
        }
    }
}

