/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.surface;

import java.util.List;
import net.minecraft.class_2338;

public final class RoadHeightInterpolator {
    private RoadHeightInterpolator() {
    }

    public static int getInterpolatedY(int x, int z, List<class_2338> centers, int[] targetY) {
        if (centers == null || centers.isEmpty() || targetY == null || targetY.length == 0) {
            return 64;
        }
        int n = centers.size();
        if (n == 1 || targetY.length == 1) {
            return targetY[0];
        }
        if (targetY.length != n) {
            return targetY[0];
        }
        ProjectionResult proj = RoadHeightInterpolator.findNearestProjection(x, z, centers);
        return RoadHeightInterpolator.interpolateY(proj.segmentIndex, proj.t, targetY);
    }

    private static ProjectionResult findNearestProjection(int x, int z, List<class_2338> centers) {
        int n = centers.size();
        int bestSegment = 0;
        double bestT = 0.0;
        double bestDistSq = Double.MAX_VALUE;
        for (int i = 0; i < n - 1; ++i) {
            double t;
            double bz;
            double dz;
            class_2338 a = centers.get(i);
            class_2338 b = centers.get(i + 1);
            double ax = a.method_10263();
            double az = a.method_10260();
            double bx = b.method_10263();
            double dx = bx - ax;
            double lenSq = dx * dx + (dz = (bz = (double)b.method_10260()) - az) * dz;
            if (lenSq < 1.0E-9) {
                t = 0.0;
            } else {
                t = (((double)x - ax) * dx + ((double)z - az) * dz) / lenSq;
                t = Math.max(0.0, Math.min(1.0, t));
            }
            double projX = ax + t * dx;
            double projZ = az + t * dz;
            double distSq = ((double)x - projX) * ((double)x - projX) + ((double)z - projZ) * ((double)z - projZ);
            if (!(distSq < bestDistSq)) continue;
            bestDistSq = distSq;
            bestSegment = i;
            bestT = t;
        }
        return new ProjectionResult(bestSegment, bestT, bestDistSq);
    }

    private static int interpolateY(int segmentIndex, double t, int[] targetY) {
        int y0 = targetY[segmentIndex];
        int y1 = targetY[segmentIndex + 1];
        double interpolated = (double)y0 + t * (double)(y1 - y0);
        return (int)Math.round(interpolated);
    }

    public static int[] batchInterpolate(List<class_2338> positions, int segmentIndex, List<class_2338> centers, int[] targetY) {
        if (positions == null || positions.isEmpty()) {
            return new int[0];
        }
        int[] results = new int[positions.size()];
        int n = centers.size();
        int searchRadius = 5;
        int searchStart = Math.max(0, segmentIndex - searchRadius);
        int searchEnd = Math.min(n - 2, segmentIndex + searchRadius);
        for (int i = 0; i < positions.size(); ++i) {
            class_2338 pos = positions.get(i);
            int x = pos.method_10263();
            int z = pos.method_10260();
            int bestSeg = segmentIndex;
            double bestT = 0.5;
            double bestDistSq = Double.MAX_VALUE;
            for (int seg = searchStart; seg <= searchEnd; ++seg) {
                double projZ;
                double bz;
                double dz;
                class_2338 a = centers.get(seg);
                class_2338 b = centers.get(seg + 1);
                double ax = a.method_10263();
                double az = a.method_10260();
                double bx = b.method_10263();
                double dx = bx - ax;
                double lenSq = dx * dx + (dz = (bz = (double)b.method_10260()) - az) * dz;
                double t = lenSq < 1.0E-9 ? 0.0 : Math.max(0.0, Math.min(1.0, (((double)x - ax) * dx + ((double)z - az) * dz) / lenSq));
                double projX = ax + t * dx;
                double distSq = ((double)x - projX) * ((double)x - projX) + ((double)z - (projZ = az + t * dz)) * ((double)z - projZ);
                if (!(distSq < bestDistSq)) continue;
                bestDistSq = distSq;
                bestSeg = seg;
                bestT = t;
            }
            results[i] = RoadHeightInterpolator.interpolateY(bestSeg, bestT, targetY);
        }
        return results;
    }

    private record ProjectionResult(int segmentIndex, double t, double distSq) {
    }
}

