/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.fabric.WorldDataProviderImpl;
import net.shiroha233.roadweaver.structures.model.StructureInstance;

public abstract class WorldDataProvider {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static WorldDataProvider getInstance() {
        return WorldDataProviderImpl.getInstance();
    }

    public abstract Records.StructureLocationData getStructureLocations(class_3218 var1);

    public abstract void setStructureLocations(class_3218 var1, Records.StructureLocationData var2);

    public abstract List<Records.StructureConnection> getStructureConnections(class_3218 var1);

    public abstract void setStructureConnections(class_3218 var1, List<Records.StructureConnection> var2);

    public abstract Set<Long> getPlannedTileKeys(class_3218 var1);

    public abstract void setPlannedTileKeys(class_3218 var1, Set<Long> var2);

    public abstract Map<Long, Long> getPlannedTileCenters(class_3218 var1);

    public abstract void setPlannedTileCenters(class_3218 var1, Map<Long, Long> var2);

    public abstract List<StructureInstance> getStructureInstances(class_3218 var1);

    public abstract void setStructureInstances(class_3218 var1, List<StructureInstance> var2);

    public void addStructureLocation(class_3218 level, class_2338 pos) {
        Records.StructureLocationData data = this.getStructureLocations(level);
        ArrayList<class_2338> locations = new ArrayList<class_2338>(data.structureLocations());
        if (!locations.contains(pos)) {
            locations.add(pos);
            this.setStructureLocations(level, new Records.StructureLocationData(locations));
        }
    }

    public void addStructureInstance(class_3218 level, StructureInstance inst) {
        if (inst == null) {
            return;
        }
        ArrayList origin = this.getStructureInstances(level);
        ArrayList<StructureInstance> copy = new ArrayList<StructureInstance>(origin != null ? origin : new ArrayList());
        boolean exists = false;
        for (StructureInstance s : copy) {
            if (s == null || !s.anchorPos().equals((Object)inst.anchorPos()) || !s.blueprintId().equals((Object)inst.blueprintId())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            copy.add(inst);
            this.setStructureInstances(level, copy);
        }
    }
}

