/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.planning;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2338;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.planning.PlanningUtils;

public final class RNGPlanner {
    private RNGPlanner() {
    }

    public static List<Records.StructureConnection> planRNG(List<class_2338> points, int maxEdgeLenBlocks) {
        if (points == null || points.size() < 2) {
            return List.of();
        }
        ArrayList<class_2338> unique = new ArrayList<class_2338>();
        HashSet<Long> seen = new HashSet<Long>();
        for (class_2338 p : points) {
            class_2338 q = new class_2338(p.method_10263(), 0, p.method_10260());
            long key = PlanningUtils.pos2dKey(q);
            if (!seen.add(key)) continue;
            unique.add(q);
        }
        int n = unique.size();
        if (n < 2) {
            return List.of();
        }
        long maxD2 = maxEdgeLenBlocks > 0 ? (long)maxEdgeLenBlocks * (long)maxEdgeLenBlocks : Long.MAX_VALUE;
        long[] xs = new long[n];
        long[] zs = new long[n];
        for (int i = 0; i < n; ++i) {
            xs[i] = ((class_2338)unique.get(i)).method_10263();
            zs[i] = ((class_2338)unique.get(i)).method_10260();
        }
        HashSet<Long> edgeKeys = new HashSet<Long>();
        ArrayList<Records.StructureConnection> edges = new ArrayList<Records.StructureConnection>();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                long key;
                long dx = xs[i] - xs[j];
                long dz = zs[i] - zs[j];
                long d2 = dx * dx + dz * dz;
                if (d2 > maxD2) continue;
                boolean blocked = false;
                for (int k = 0; k < n; ++k) {
                    if (k == i || k == j) continue;
                    long dax = xs[i] - xs[k];
                    long daz = zs[i] - zs[k];
                    long dbx = xs[j] - xs[k];
                    long dbz = zs[j] - zs[k];
                    long da2 = dax * dax + daz * daz;
                    long db2 = dbx * dbx + dbz * dbz;
                    if (da2 >= d2 || db2 >= d2) continue;
                    blocked = true;
                    break;
                }
                if (blocked || !edgeKeys.add(key = (long)i << 32 ^ (long)j)) continue;
                edges.add(new Records.StructureConnection((class_2338)unique.get(i), (class_2338)unique.get(j)));
            }
        }
        return edges;
    }
}

