/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.runtime;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.server.MinecraftServer;
import net.shiroha233.roadweaver.config.ConfigService;

public final class ThreadPoolManager {
    private static volatile ExecutorService COMPUTE_EXEC;
    private static volatile ExecutorService GENERATION_EXEC;
    private static final AtomicLong EPOCH;
    private static final long WORK_PERIOD_MS = 20L;
    private static final ThreadLocal<Long> WORK_START;

    private ThreadPoolManager() {
    }

    private static ThreadFactory namedFactory(String prefix) {
        return r -> {
            Thread t = new Thread(r, prefix + "-" + System.nanoTime());
            t.setDaemon(true);
            return t;
        };
    }

    public static synchronized void onServerStarted(MinecraftServer server) {
        EPOCH.incrementAndGet();
        int computeThreads = ThreadPoolManager.resolveComputeThreadsFromConfig();
        if (COMPUTE_EXEC != null && !COMPUTE_EXEC.isShutdown() && !COMPUTE_EXEC.isTerminated()) {
            try {
                COMPUTE_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        COMPUTE_EXEC = Executors.newFixedThreadPool(computeThreads, ThreadPoolManager.namedFactory("RW-Compute"));
        int genThreads = Math.max(1, ConfigService.get().generationThreads());
        if (GENERATION_EXEC != null && !GENERATION_EXEC.isShutdown() && !GENERATION_EXEC.isTerminated()) {
            try {
                GENERATION_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        GENERATION_EXEC = Executors.newFixedThreadPool(genThreads, ThreadPoolManager.namedFactory("RW-Gen"));
    }

    public static synchronized void onServerStopping() {
        EPOCH.incrementAndGet();
        if (COMPUTE_EXEC != null) {
            try {
                COMPUTE_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            COMPUTE_EXEC = null;
        }
        if (GENERATION_EXEC != null) {
            try {
                GENERATION_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GENERATION_EXEC = null;
        }
    }

    public static synchronized void resizeGenerationPool(int threads) {
        int genThreads = Math.max(1, threads);
        if (GENERATION_EXEC != null && !GENERATION_EXEC.isShutdown() && !GENERATION_EXEC.isTerminated()) {
            try {
                GENERATION_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        GENERATION_EXEC = Executors.newFixedThreadPool(genThreads, ThreadPoolManager.namedFactory("RW-Gen"));
    }

    public static synchronized void resizeComputePool(int threads) {
        int computeThreads = threads <= 0 ? ThreadPoolManager.resolveComputeThreadsFromConfig() : Math.max(1, threads);
        if (COMPUTE_EXEC != null && !COMPUTE_EXEC.isShutdown() && !COMPUTE_EXEC.isTerminated()) {
            try {
                COMPUTE_EXEC.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        COMPUTE_EXEC = Executors.newFixedThreadPool(computeThreads, ThreadPoolManager.namedFactory("RW-Compute"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService computeExecutor() {
        ExecutorService e = COMPUTE_EXEC;
        if (e != null && !e.isShutdown()) {
            if (!e.isTerminated()) return e;
        }
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            if (COMPUTE_EXEC != null && !COMPUTE_EXEC.isShutdown()) {
                if (!COMPUTE_EXEC.isTerminated()) return COMPUTE_EXEC;
            }
            int computeThreads = ThreadPoolManager.resolveComputeThreadsFromConfig();
            COMPUTE_EXEC = Executors.newFixedThreadPool(computeThreads, ThreadPoolManager.namedFactory("RW-Compute"));
            return COMPUTE_EXEC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService generationExecutor() {
        ExecutorService e = GENERATION_EXEC;
        if (e != null && !e.isShutdown()) {
            if (!e.isTerminated()) return e;
        }
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            if (GENERATION_EXEC != null && !GENERATION_EXEC.isShutdown()) {
                if (!GENERATION_EXEC.isTerminated()) return GENERATION_EXEC;
            }
            int genThreads = Math.max(1, ConfigService.get().generationThreads());
            GENERATION_EXEC = Executors.newFixedThreadPool(genThreads, ThreadPoolManager.namedFactory("RW-Gen"));
            return GENERATION_EXEC;
        }
    }

    public static long currentEpoch() {
        return EPOCH.get();
    }

    public static boolean isEpoch(long epoch) {
        return EPOCH.get() == epoch;
    }

    public static void throttle() {
        int duty;
        try {
            duty = ConfigService.get().threadDutyCycle();
        }
        catch (Throwable t) {
            return;
        }
        if (duty >= 100) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - WORK_START.get();
        if (elapsed >= 20L) {
            long sleepMs = (long)(20.0 * (100.0 - (double)duty) / (double)duty);
            if (sleepMs > 0L) {
                try {
                    Thread.sleep(Math.min(sleepMs, 200L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            WORK_START.set(System.currentTimeMillis());
        }
    }

    public static void resetThrottle() {
        WORK_START.set(System.currentTimeMillis());
    }

    private static int resolveComputeThreadsFromConfig() {
        int configured = 0;
        try {
            configured = ConfigService.get().computeThreads();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (configured > 0) {
            return Math.max(1, configured);
        }
        try {
            int cores = Runtime.getRuntime().availableProcessors();
            return Math.max(1, cores - 1);
        }
        catch (Throwable t) {
            return 1;
        }
    }

    static {
        EPOCH = new AtomicLong(0L);
        WORK_START = ThreadLocal.withInitial(System::currentTimeMillis);
    }
}

