/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.events;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.RoadFeature;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.Road;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModEventHandler {
    private static final int THREAD_COUNT = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static ExecutorService executor = Executors.newFixedThreadPool(7);
    private static final ConcurrentHashMap<String, Future<?>> runningTasks = new ConcurrentHashMap();

    public static void register() {
        ServerWorldEvents.LOAD.register((server, serverWorld) -> {
            ModEventHandler.restartExecutorIfNeeded();
            if (!serverWorld.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            Records.StructureLocationData structureLocationData = (Records.StructureLocationData)serverWorld.getAttachedOrCreate(WorldDataAttachment.STRUCTURE_LOCATIONS, () -> new Records.StructureLocationData(new ArrayList<class_2338>()));
            ModEventHandler.restoreUnfinishedRoads(serverWorld);
            if (structureLocationData.structureLocations().size() < ModConfig.initialLocatingCount) {
                for (int i = 0; i < ModConfig.initialLocatingCount; ++i) {
                    StructureConnector.cacheNewConnection(serverWorld, false);
                    ModEventHandler.tryGenerateNewRoads(serverWorld, true, 5000);
                }
            }
        });
        ServerWorldEvents.UNLOAD.register((server, serverWorld) -> {
            if (!serverWorld.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            Future<?> task = runningTasks.remove(serverWorld.method_27983().method_29177().toString());
            if (task != null && !task.isDone()) {
                task.cancel(true);
                LOGGER.debug("Aborted running road task for world: {}", (Object)serverWorld.method_27983().method_29177());
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(serverWorld -> {
            if (!serverWorld.method_27983().equals(class_1937.field_25179)) {
                return;
            }
            ModEventHandler.tryGenerateNewRoads(serverWorld, true, 5000);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            RoadPathCalculator.heightCache.clear();
            runningTasks.values().forEach(future -> future.cancel(true));
            runningTasks.clear();
            executor.shutdownNow();
            LOGGER.debug("RoadWeaver: ExecutorService shut down.");
        });
    }

    private static void tryGenerateNewRoads(class_3218 serverWorld, Boolean async, int steps) {
        runningTasks.entrySet().removeIf(entry -> ((Future)entry.getValue()).isDone());
        if (runningTasks.size() >= ModConfig.maxConcurrentRoadGeneration) {
            return;
        }
        if (!StructureConnector.cachedStructureConnections.isEmpty()) {
            class_3037 class_30372;
            Records.StructureConnection structureConnection = StructureConnector.cachedStructureConnections.poll();
            class_2975 feature = (class_2975)serverWorld.method_30349().method_30530(class_7924.field_41239).method_29107(RoadFeature.ROAD_FEATURE_KEY);
            if (feature != null && (class_30372 = feature.comp_333()) instanceof RoadFeatureConfig) {
                RoadFeatureConfig roadConfig = (RoadFeatureConfig)class_30372;
                if (async.booleanValue()) {
                    String taskId = serverWorld.method_27983().method_29177().toString() + "_" + System.nanoTime();
                    Future<?> future = executor.submit(() -> {
                        try {
                            new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error generating road", (Throwable)e);
                        }
                        finally {
                            runningTasks.remove(taskId);
                        }
                    });
                    runningTasks.put(taskId, future);
                } else {
                    new Road(serverWorld, structureConnection, roadConfig).generateRoad(steps);
                }
            }
        }
    }

    private static void restartExecutorIfNeeded() {
        if (executor.isShutdown() || executor.isTerminated()) {
            executor = Executors.newFixedThreadPool(7);
            LOGGER.debug("RoadWeaver: ExecutorService restarted.");
        }
    }

    private static void restoreUnfinishedRoads(class_3218 serverWorld) {
        List connections = (List)serverWorld.getAttachedOrCreate(WorldDataAttachment.CONNECTED_STRUCTURES, ArrayList::new);
        int restoredCount = 0;
        for (Records.StructureConnection connection : connections) {
            if (connection.status() != Records.ConnectionStatus.PLANNED && connection.status() != Records.ConnectionStatus.GENERATING) continue;
            if (connection.status() == Records.ConnectionStatus.GENERATING) {
                Records.StructureConnection resetConnection = new Records.StructureConnection(connection.from(), connection.to(), Records.ConnectionStatus.PLANNED);
                StructureConnector.cachedStructureConnections.add(resetConnection);
                ArrayList<Records.StructureConnection> updatedConnections = new ArrayList<Records.StructureConnection>(connections);
                int index = updatedConnections.indexOf(connection);
                if (index >= 0) {
                    updatedConnections.set(index, resetConnection);
                    serverWorld.setAttached(WorldDataAttachment.CONNECTED_STRUCTURES, updatedConnections);
                }
            } else {
                StructureConnector.cachedStructureConnections.add(connection);
            }
            ++restoredCount;
        }
        if (restoredCount > 0) {
            LOGGER.info("RoadWeaver: \u6062\u590d\u4e86 {} \u4e2a\u672a\u5b8c\u6210\u7684\u9053\u8def\u751f\u6210\u4efb\u52a1", (Object)restoredCount);
        }
    }
}

