/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.network;

import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.network.DebugDataPacket;
import net.countered.settlementroads.network.RoadWeaverNetworkManager;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static DebugDataPacket cachedDebugData = null;

    public static void handleDebugDataRequest(class_3222 player) {
        try {
            class_3218 world = player.method_51469();
            WorldDataProvider dataProvider = WorldDataProvider.getInstance();
            Records.StructureLocationData structureData = dataProvider.getStructureLocations(world);
            List<Records.StructureConnection> connections = dataProvider.getStructureConnections(world);
            List<Records.RoadData> roads = dataProvider.getRoadDataList(world);
            ArrayList<Records.StructureInfo> structureInfos = structureData != null ? new ArrayList<Records.StructureInfo>(structureData.structureInfos()) : new ArrayList();
            DebugDataPacket packet = new DebugDataPacket(structureInfos, connections, roads);
            RoadWeaverNetworkManager.sendDebugData(player, packet);
            LOGGER.info("Sent debug data to player {}: {} structures, {} connections, {} roads", new Object[]{player.method_5477().getString(), structureInfos.size(), connections.size(), roads.size()});
        }
        catch (Exception e) {
            LOGGER.error("Failed to send debug data to player {}", (Object)player.method_5477().getString(), (Object)e);
            DebugDataPacket emptyPacket = new DebugDataPacket(new ArrayList<Records.StructureInfo>(), new ArrayList<Records.StructureConnection>(), new ArrayList<Records.RoadData>());
            RoadWeaverNetworkManager.sendDebugData(player, emptyPacket);
        }
    }

    public static void handleDebugDataResponse(DebugDataPacket packet) {
        cachedDebugData = packet;
        LOGGER.info("Received debug data: {} structures, {} connections, {} roads", new Object[]{packet.getStructureInfos().size(), packet.getConnections().size(), packet.getRoads().size()});
    }

    public static DebugDataPacket getCachedDebugData() {
        return cachedDebugData;
    }

    public static void clearCachedDebugData() {
        cachedDebugData = null;
    }
}

