/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.shiroha233.roadweaver.client.ConfigScreenFactory;
import net.shiroha233.roadweaver.client.map.MapContextMenu;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.data.MapDataCollector;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.client.map.data.MapSnapshotCache;
import net.shiroha233.roadweaver.client.map.interaction.MapInteraction;
import net.shiroha233.roadweaver.client.map.render.GridRenderer;
import net.shiroha233.roadweaver.client.map.render.MapRenderers;
import net.shiroha233.roadweaver.client.map.render.RenderUtils;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.ClientNetBridge;
import net.shiroha233.roadweaver.util.ComputeService;

public class RoadMapScreen
extends class_437 {
    private static final class_2960 MAP_TEXTURE = new class_2960("roadweaver", "textures/gui/map.png");
    private static final int TEX_W = 1536;
    private static final int TEX_H = 1024;
    private static final int COLOR_TEXT = -10601186;
    private static final int COLOR_STRUCT = -10601186;
    private static final int COLOR_PLANNED = -11751600;
    private static final int COLOR_GENERATING = -16777216;
    private static final int COLOR_COMPLETED = -16777216;
    private static final int COLOR_FAILED = -522167472;
    private static final int COLOR_GRID = 0x30999999;
    private static final int GRID_TARGET_PX = 32;
    private static final class_2561 MENU_TELEPORT = class_2561.method_43471((String)"gui.roadweaver.map.menu.teleport");
    private static final class_2561 BTN_CONFIG = class_2561.method_43471((String)"gui.roadweaver.config_button");
    private static final class_2561 BTN_MANUAL = class_2561.method_43471((String)"gui.roadweaver.map.manual_connect");
    private static final int MENU_BG = -267382768;
    private static final int MENU_BORDER = -1;
    private static final int MENU_HOVER = 0x40FFFFFF;
    private static final int MENU_TEXT = -1;
    private static final int MENU_MIN_W = 0;
    private static final int MENU_ITEM_H = 14;
    private static final int MENU_PAD_X = 6;
    private static final int MENU_PAD_Y = 4;
    private MapSnapshot snapshot = MapSnapshot.empty();
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;
    private static final int OUTER_PAD = 36;
    private static final int INNER_PAD = 25;
    private final MapView view = new MapView();
    private boolean dragging;
    private int dragButton;
    private double lastMouseX;
    private double lastMouseY;
    private boolean debounceZoomPending;
    private long debounceZoomDeadlineMs;
    private boolean showContextMenu;
    private int menuX;
    private int menuY;
    private class_2338 menuTarget;
    private boolean manualMode;
    private class_2338 selectedA;
    private final AtomicInteger requestSeq = new AtomicInteger(0);

    public RoadMapScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.map.title"));
    }

    protected void method_25426() {
        super.method_25426();
        MapSnapshotCache.cancelClear();
        MapSnapshot cached = MapSnapshotCache.peek();
        if (cached != null) {
            this.snapshot = cached;
        }
        this.computeMapRect();
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.resetFromSnapshot(this.snapshot);
        class_310 mc = this.field_22787;
        if (mc != null && mc.field_1724 != null) {
            this.view.calibrateInitialToPlayer(mc, contentW, contentH, 32);
        }
        this.requestCurrentView();
    }

    private void computeMapRect() {
        int availW = this.field_22789 - 72;
        int availH = this.field_22790 - 72;
        int w = availW;
        float ratio = 1.5f;
        int h = Math.round((float)w / ratio);
        if (h > availH) {
            h = availH;
            w = Math.round((float)h * ratio);
        }
        this.mapW = w;
        this.mapH = h;
        this.mapX = (this.field_22789 - w) / 2;
        this.mapY = (this.field_22790 - h) / 2;
    }

    private boolean insideMap(double x, double y) {
        return x >= (double)(this.mapX + 25) && x <= (double)(this.mapX + this.mapW - 25) && y >= (double)(this.mapY + 25) && y <= (double)(this.mapY + this.mapH - 25);
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        boolean hasDetailedRoads;
        this.method_25420(g);
        g.method_25293(MAP_TEXTURE, this.mapX, this.mapY, this.mapW, this.mapH, 0.0f, 0.0f, 1536, 1024, 1536, 1024);
        int titleY = this.mapY - 8;
        g.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, Math.max(6, titleY), -10601186);
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.lockAspect(contentW, contentH);
        int left = this.mapX + 25;
        int top = this.mapY + 25;
        int right = this.mapX + this.mapW - 25;
        int bottom = this.mapY + this.mapH - 25;
        g.method_44379(left, top, right, bottom);
        MapRenderers.renderGrid(g, this.field_22793, this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 0x30999999, 32, -10601186);
        int thickness = this.computeThickness();
        ArrayList<Records.StructureConnection> connForLines = new ArrayList<Records.StructureConnection>(this.snapshot.connections());
        boolean bl = hasDetailedRoads = !this.snapshot.roadPolylines().isEmpty();
        if (hasDetailedRoads) {
            connForLines.removeIf(c -> c.status() == Records.ConnectionStatus.COMPLETED);
        }
        MapRenderers.renderConnections(g, connForLines, (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -11751600, -16777216, -16777216, -522167472, left, top, right, bottom);
        int lodStep = GridRenderer.computeGridStep(this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 32);
        MapRenderers.renderRoadPolylines(g, this.snapshot.roadPolylines(), (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -16777216, left, top, right, bottom, lodStep);
        MapRenderers.renderStructures(g, this.snapshot.structures(), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), (x, z) -> this.view.isInViewWorld((int)x, (int)z), this.computePointSize(), -10601186, left, top, right, bottom);
        if (this.manualMode && this.selectedA != null && this.view.isInViewWorld(this.selectedA.method_10263(), this.selectedA.method_10260())) {
            int sxA = this.view.toScreenX(this.selectedA.method_10263(), this.mapX, 25, contentW);
            int syA = this.view.toScreenY(this.selectedA.method_10260(), this.mapY, 25, contentH);
            int selSize = this.computePointSize() * 2 + 4;
            RenderUtils.drawPoint(g, sxA, syA, selSize, -50384, left, top, right, bottom);
            if (this.insideMap(mouseX, mouseY)) {
                int syB;
                int sxB;
                class_2338 hover = this.findNearestStructure(mouseX, mouseY);
                if (hover != null && this.view.isInViewWorld(hover.method_10263(), hover.method_10260())) {
                    sxB = this.view.toScreenX(hover.method_10263(), this.mapX, 25, contentW);
                    syB = this.view.toScreenY(hover.method_10260(), this.mapY, 25, contentH);
                } else {
                    sxB = Math.round(mouseX);
                    syB = Math.round(mouseY);
                }
                int previewThickness = this.computeThickness();
                RenderUtils.drawThickDashedLine(g, sxA, syA, sxB, syB, -855688400, previewThickness, 8, 6, left, top, right, bottom);
            }
        }
        if (!this.showContextMenu) {
            MapInteraction.renderHoverHighlight(g, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        this.renderPlayer(g);
        g.method_44380();
        int legendRight = this.mapX + this.mapW - 25;
        int legendStartY = this.mapY + 25 + 8;
        int gap = 8;
        MapRenderers.renderLegend(g, this.field_22793, legendRight, legendStartY, gap, -10601186, -10601186, -11751600, -16777216, -16777216, -522167472, this.snapshot.structuresCount(), this.snapshot.plannedCount(), this.snapshot.generatingCount(), this.snapshot.completedCount(), this.snapshot.failedCount());
        this.renderConfigButton(g, mouseX, mouseY);
        this.renderManualButton(g, mouseX, mouseY);
        if (!this.showContextMenu) {
            MapInteraction.renderHoverTooltip(g, this.field_22793, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        if (this.debounceZoomPending && System.currentTimeMillis() >= this.debounceZoomDeadlineMs) {
            this.debounceZoomPending = false;
            this.requestCurrentView();
        }
        if (this.showContextMenu && this.menuTarget != null) {
            int[] bounds = MapContextMenu.computeMenuBounds(this.field_22793, MENU_TELEPORT, this.menuX, this.menuY, this.field_22789, this.field_22790, 6, 4, 14, 0);
            int hover = MapContextMenu.getMenuHoverIndex(mouseX, mouseY, bounds, 4, 14, 1);
            MapContextMenu.renderContextMenu(g, this.field_22793, MENU_TELEPORT, mouseX, mouseY, bounds, hover, -267382768, -1, 0x40FFFFFF, -1, this.field_22789, this.field_22790);
        }
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private int computeThickness() {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double ppb = Math.min(this.view.pxPerBlockX(contentW), this.view.pxPerBlockZ(contentH));
        int t = (int)Math.round(ppb);
        if (t < 1) {
            t = 1;
        }
        if (t > 4) {
            t = 4;
        }
        return t;
    }

    private int computePointSize() {
        return 2 + this.computeThickness();
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25432() {
        super.method_25432();
        MapSnapshotCache.scheduleClear(1000L);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_310 mc = this.field_22787;
        if (mc != null) {
            for (class_304 mapping : mc.field_1690.field_1839) {
                if (!"key.roadweaver.open_map".equals(mapping.method_1431()) || !mapping.method_1417(keyCode, scanCode)) continue;
                while (mapping.method_1436()) {
                }
                this.method_25419();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void setSnapshot(MapSnapshot snapshot) {
        if (snapshot != null) {
            this.snapshot = snapshot;
            MapSnapshotCache.put(snapshot);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!this.insideMap(mouseX, mouseY)) {
            return super.method_25401(mouseX, mouseY, delta);
        }
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double factor = delta > 0.0 ? 0.9 : 1.1;
        double cx = this.view.screenToWorldX(mouseX, this.mapX, 25, contentW);
        double cz = this.view.screenToWorldZ(mouseY, this.mapY, 25, contentH);
        this.view.applyZoomAround(cx, cz, factor, contentW, contentH, 32);
        this.debounceZoomPending = true;
        this.debounceZoomDeadlineMs = System.currentTimeMillis() + 500L;
        this.showContextMenu = false;
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_2338 best;
        if (button == 0 && this.insideConfigButton((int)mouseX, (int)mouseY)) {
            this.openConfig();
            return true;
        }
        if (button == 0 && this.insideManualButton((int)mouseX, (int)mouseY)) {
            boolean bl = this.manualMode = !this.manualMode;
            if (!this.manualMode) {
                this.selectedA = null;
            }
            this.showContextMenu = false;
            return true;
        }
        if (this.showContextMenu) {
            boolean inside;
            int[] bounds = MapContextMenu.computeMenuBounds(this.field_22793, MENU_TELEPORT, this.menuX, this.menuY, this.field_22789, this.field_22790, 6, 4, 14, 0);
            int bx = bounds[0];
            int by = bounds[1];
            int bw = bounds[2];
            int bh = bounds[3];
            boolean bl = inside = mouseX >= (double)bx && mouseX <= (double)(bx + bw) && mouseY >= (double)by && mouseY <= (double)(by + bh);
            if (inside && button == 0) {
                int idx = MapContextMenu.getMenuHoverIndex((int)mouseX, (int)mouseY, bounds, 4, 14, 1);
                if (idx == 0) {
                    this.onTeleportSelected();
                    this.showContextMenu = false;
                    return true;
                }
            } else {
                this.showContextMenu = false;
            }
        }
        if (this.manualMode && this.insideMap(mouseX, mouseY) && button == 0 && (best = this.findNearestStructure(mouseX, mouseY)) != null) {
            if (this.selectedA == null) {
                this.selectedA = best;
            } else if (this.selectedA.equals((Object)best)) {
                this.selectedA = null;
            } else {
                ClientNetBridge.requestManualConnect(this.selectedA.method_10263(), this.selectedA.method_10260(), best.method_10263(), best.method_10260());
                this.selectedA = null;
                this.requestCurrentView();
            }
            this.showContextMenu = false;
            return true;
        }
        if (this.insideMap(mouseX, mouseY) && button == 0) {
            this.dragging = true;
            this.dragButton = button;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.debounceZoomPending = false;
            this.showContextMenu = false;
            return true;
        }
        if (this.insideMap(mouseX, mouseY) && button == 1 && (best = this.findNearestStructure(mouseX, mouseY)) != null) {
            this.menuTarget = best;
            this.menuX = (int)mouseX;
            this.menuY = (int)mouseY;
            this.showContextMenu = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging && button == this.dragButton) {
            int contentW = this.mapW - 50;
            int contentH = this.mapH - 50;
            double dx = mouseX - this.lastMouseX;
            double dy = mouseY - this.lastMouseY;
            this.view.panByScreenDelta(dx, dy, contentW, contentH);
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.view.lockAspect(contentW, contentH);
            this.showContextMenu = false;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragging && button == this.dragButton) {
            this.dragging = false;
            this.view.clampZoom(this.mapW - 50, this.mapH - 50, 32);
            this.debounceZoomPending = false;
            this.requestCurrentView();
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void renderPlayer(class_332 g) {
        int sy;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        double wx = this.field_22787.field_1724.method_23317();
        double wz = this.field_22787.field_1724.method_23321();
        int sx = this.view.toScreenX((int)Math.round(wx), this.mapX, 25, this.mapW - 50);
        if (!this.insideMap(sx, sy = this.view.toScreenY((int)Math.round(wz), this.mapY, 25, this.mapH - 50))) {
            return;
        }
        float yaw = this.field_22787.field_1724.method_36454();
        int left = this.mapX + 25;
        int right = this.mapX + this.mapW - 25;
        int top = this.mapY + 25;
        int bottom = this.mapY + this.mapH - 25;
        MapRenderers.drawPlayerArrow(g, sx, sy, yaw, 10, 6, 4, -16777216, left, top, right, bottom, this.view.pxPerBlockX(this.mapW - 50), this.view.pxPerBlockZ(this.mapH - 50));
    }

    private void requestCurrentView() {
        int minX = (int)Math.floor(Math.min(this.view.getMinX(), this.view.getMaxX()));
        int maxX = (int)Math.ceil(Math.max(this.view.getMinX(), this.view.getMaxX()));
        int minZ = (int)Math.floor(Math.min(this.view.getMinZ(), this.view.getMaxZ()));
        int maxZ = (int)Math.ceil(Math.max(this.view.getMinZ(), this.view.getMaxZ()));
        int pad = 32;
        int fMinX = minX -= pad;
        int fMaxX = maxX += pad;
        int fMinZ = minZ -= pad;
        int fMaxZ = maxZ += pad;
        class_310 mc = this.field_22787;
        if (mc == null) {
            return;
        }
        class_1132 server = mc.method_1576();
        if (server != null) {
            class_3218 level = server.method_3847(class_1937.field_25179);
            if (level != null) {
                int radiusChunks;
                int cx = 0;
                int cz = 0;
                if (mc.field_1724 != null) {
                    cx = (int)Math.round(mc.field_1724.method_23317());
                    cz = (int)Math.round(mc.field_1724.method_23321());
                }
                try {
                    ModConfig cfg = ConfigService.get();
                    radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
                }
                catch (Throwable t) {
                    radiusChunks = 256;
                }
                int radiusBlocks = Math.max(1, radiusChunks) * 16;
                int fcx = cx;
                int fcz = cz;
                int currentSeq = this.requestSeq.incrementAndGet();
                CompletableFuture.supplyAsync(() -> MapDataCollector.build(level, fMinX, fMinZ, fMaxX, fMaxZ, fcx, fcz, radiusBlocks), ComputeService.executor()).thenAccept(snap -> mc.execute(() -> {
                    if (this.requestSeq.get() == currentSeq) {
                        this.setSnapshot((MapSnapshot)snap);
                    }
                }));
            }
        } else {
            this.requestSeq.incrementAndGet();
            ClientNetBridge.requestSnapshot(minX, minZ, maxX, maxZ);
        }
    }

    private class_2338 findNearestStructure(double mouseX, double mouseY) {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        int bestDist = Integer.MAX_VALUE;
        class_2338 best = null;
        for (class_2338 p : this.snapshot.structures()) {
            int dy;
            if (!this.view.isInViewWorld(p.method_10263(), p.method_10260())) continue;
            int x = this.view.toScreenX(p.method_10263(), this.mapX, 25, contentW);
            int y = this.view.toScreenY(p.method_10260(), this.mapY, 25, contentH);
            int dx = (int)Math.abs((double)x - mouseX);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - mouseY)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            return best;
        }
        return null;
    }

    private void onTeleportSelected() {
        if (this.menuTarget == null) {
            return;
        }
        ClientNetBridge.requestTeleport(this.menuTarget.method_10263(), this.menuTarget.method_10264(), this.menuTarget.method_10260());
    }

    private int[] computeConfigBtnBounds() {
        int x = this.mapX + 25 + 4;
        int y = this.mapY + 25 + 4;
        int w = this.field_22793.method_27525((class_5348)BTN_CONFIG) + 6;
        Objects.requireNonNull(this.field_22793);
        int h = 9 + 4;
        return new int[]{x, y, w, h};
    }

    private boolean insideConfigButton(int mx, int my) {
        int[] b = this.computeConfigBtnBounds();
        int x = b[0];
        int y = b[1];
        int w = b[2];
        int h = b[3];
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private void renderConfigButton(class_332 g, int mouseX, int mouseY) {
        int[] b = this.computeConfigBtnBounds();
        int x = b[0];
        int y = b[1];
        int h = b[3];
        Objects.requireNonNull(this.field_22793);
        int ty = y + (h - 9) / 2;
        g.method_51439(this.field_22793, BTN_CONFIG, x + 3, ty, -10601186, false);
        if (this.insideConfigButton(mouseX, mouseY)) {
            int textW = this.field_22793.method_27525((class_5348)BTN_CONFIG);
            Objects.requireNonNull(this.field_22793);
            int uy = ty + 9 + 1;
            int underline = 1616788766;
            g.method_25294(x + 2, uy, x + 2 + textW + 2, uy + 1, underline);
        }
    }

    private class_2561 manualLabel() {
        class_5250 onoff = this.manualMode ? class_2561.method_43471((String)"gui.roadweaver.common.on") : class_2561.method_43471((String)"gui.roadweaver.common.off");
        return class_2561.method_43473().method_10852(BTN_MANUAL).method_27693(": ").method_10852((class_2561)onoff);
    }

    private int[] computeManualBtnBounds() {
        class_2561 lbl = this.manualLabel();
        int w = this.field_22793.method_27525((class_5348)lbl) + 6;
        Objects.requireNonNull(this.field_22793);
        int h = 9 + 4;
        int x = this.mapX + 25 + 4;
        int y = this.mapY + this.mapH - 25 - 4 - h;
        return new int[]{x, y, w, h};
    }

    private boolean insideManualButton(int mx, int my) {
        int[] b = this.computeManualBtnBounds();
        int x = b[0];
        int y = b[1];
        int w = b[2];
        int h = b[3];
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }

    private void renderManualButton(class_332 g, int mouseX, int mouseY) {
        int[] b = this.computeManualBtnBounds();
        int x = b[0];
        int y = b[1];
        int h = b[3];
        Objects.requireNonNull(this.field_22793);
        int ty = y + (h - 9) / 2;
        class_2561 lbl = this.manualLabel();
        g.method_51439(this.field_22793, lbl, x + 3, ty, -10601186, false);
        if (this.insideManualButton(mouseX, mouseY)) {
            int textW = this.field_22793.method_27525((class_5348)lbl);
            Objects.requireNonNull(this.field_22793);
            int uy = ty + 9 + 1;
            int underline = 1616788766;
            g.method_25294(x + 2, uy, x + 2 + textW + 2, uy + 1, underline);
        }
    }

    private void openConfig() {
        if (this.field_22787 == null) {
            return;
        }
        class_437 next = null;
        try {
            next = ConfigScreenFactory.createConfigScreen(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (next != null) {
            this.field_22787.method_1507(next);
        }
    }
}

