/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.config;

import java.util.ArrayList;
import java.util.List;

public final class ModConfig {
    private boolean villagePredictionEnabled = true;
    private int predictRadiusChunks = 1024;
    private boolean biomePrefilter = true;
    private List<String> structureWhitelist = new ArrayList<String>();
    private List<String> structureBlacklist = new ArrayList<String>();
    private int initialPlanRadiusChunks;
    private boolean dynamicPlanEnabled;
    private int dynamicPlanRadiusChunks;
    private int dynamicPlanStrideChunks;
    private PlanningAlgorithm planningAlgorithm;
    private boolean allowArtificial;
    private boolean allowNatural;
    private boolean placeWaypoints;
    private int averagingRadius;
    private int generationThreads;
    private int computeThreads;
    private int initialGenerationThreads;
    private int maxConcurrentGenerations;
    private int aStarStep;
    private int aStarMaxSteps;
    private int causewayMaxDepth;
    private int maxSlopeStepPerTwoSegments;
    private boolean slopeLimitEnabled = true;
    private PathfindingAlgorithm pathfindingAlgorithm;
    private int roadWidth;
    private int lampInterval;
    private int roadClearHeight;
    private boolean tunnelEnabled;
    private int tunnelClearHeight;
    private boolean preventTreesOnRoad;
    private boolean bridgeEnabled;
    private int bridgeDeckClearance;
    private boolean bridgeRailingEnabled;
    private int bridgePierInterval;
    private int bridgePierWidth;
    private int bridgePierMaxHeight;
    private boolean bridgeKeepLamps;
    private int bridgeRampSegments;
    private int bridgeMinWaterDepth;
    private int bridgeMinLength;
    private int bridgeMergeGap;
    private boolean roadsideStructuresEnabled;
    private int roadsideStructureInterval;
    private float roadsideStructureChance;
    private int structureRoadOffset;
    private double orthoStepCost;
    private double diagStepCost;
    private int elevationWeight;
    private int biomeWeight;
    private int stabilityWeight;
    private int waterDepthWeight;
    private int nearWaterCost;
    private double heuristicWeight;
    private double deviationWeight;

    public ModConfig() {
        this.structureWhitelist.add("#minecraft:village");
        this.initialPlanRadiusChunks = 64;
        this.dynamicPlanEnabled = true;
        this.dynamicPlanRadiusChunks = 256;
        this.dynamicPlanStrideChunks = Math.max(8, Math.min(64, this.dynamicPlanRadiusChunks / 2));
        this.planningAlgorithm = PlanningAlgorithm.RNG;
        this.allowArtificial = true;
        this.allowNatural = true;
        this.placeWaypoints = false;
        this.averagingRadius = 8;
        this.generationThreads = Math.max(2, Math.min(3, Runtime.getRuntime().availableProcessors()));
        this.computeThreads = 0;
        this.initialGenerationThreads = 6;
        this.maxConcurrentGenerations = Math.max(1, Math.min(3, this.generationThreads));
        this.aStarStep = 16;
        this.aStarMaxSteps = 10000;
        this.causewayMaxDepth = 1;
        this.maxSlopeStepPerTwoSegments = 1;
        this.slopeLimitEnabled = true;
        this.pathfindingAlgorithm = PathfindingAlgorithm.ASTAR_BASIC;
        this.roadWidth = 3;
        this.lampInterval = 32;
        this.roadClearHeight = 4;
        this.tunnelEnabled = false;
        this.tunnelClearHeight = 5;
        this.preventTreesOnRoad = true;
        this.bridgeEnabled = true;
        this.bridgeDeckClearance = 2;
        this.bridgeRailingEnabled = true;
        this.bridgePierInterval = 6;
        this.bridgePierWidth = 1;
        this.bridgePierMaxHeight = 20;
        this.bridgeKeepLamps = true;
        this.bridgeRampSegments = 4;
        this.bridgeMinWaterDepth = 2;
        this.bridgeMinLength = 5;
        this.bridgeMergeGap = 8;
        this.roadsideStructuresEnabled = true;
        this.roadsideStructureInterval = 48;
        this.roadsideStructureChance = 0.3f;
        this.structureRoadOffset = 60;
        this.orthoStepCost = 1.0;
        this.diagStepCost = 1.0;
        this.elevationWeight = 80;
        this.biomeWeight = 2;
        this.stabilityWeight = 15;
        this.waterDepthWeight = 40;
        this.nearWaterCost = 40;
        this.heuristicWeight = 15.0;
        this.deviationWeight = 0.5;
    }

    public boolean villagePredictionEnabled() {
        return this.villagePredictionEnabled;
    }

    public void setVillagePredictionEnabled(boolean villagePredictionEnabled) {
        this.villagePredictionEnabled = villagePredictionEnabled;
    }

    public int predictRadiusChunks() {
        return this.predictRadiusChunks;
    }

    public void setPredictRadiusChunks(int predictRadiusChunks) {
        this.predictRadiusChunks = predictRadiusChunks;
    }

    public boolean biomePrefilter() {
        return this.biomePrefilter;
    }

    public void setBiomePrefilter(boolean biomePrefilter) {
        this.biomePrefilter = biomePrefilter;
    }

    public List<String> structureWhitelist() {
        return this.structureWhitelist;
    }

    public void setStructureWhitelist(List<String> structureWhitelist) {
        this.structureWhitelist = structureWhitelist == null ? new ArrayList<String>() : new ArrayList<String>(structureWhitelist);
    }

    public List<String> structureBlacklist() {
        return this.structureBlacklist;
    }

    public void setStructureBlacklist(List<String> structureBlacklist) {
        this.structureBlacklist = structureBlacklist == null ? new ArrayList<String>() : new ArrayList<String>(structureBlacklist);
    }

    public void sanitize() {
        if (this.structureWhitelist == null) {
            this.structureWhitelist = new ArrayList<String>();
        }
        if (this.structureBlacklist == null) {
            this.structureBlacklist = new ArrayList<String>();
        }
        if (this.predictRadiusChunks <= 0) {
            this.predictRadiusChunks = 1024;
        }
        if (this.initialPlanRadiusChunks <= 0) {
            this.initialPlanRadiusChunks = 64;
        }
        if (this.dynamicPlanRadiusChunks <= 0) {
            this.dynamicPlanRadiusChunks = 256;
        }
        if (this.dynamicPlanStrideChunks <= 0) {
            this.dynamicPlanStrideChunks = Math.max(8, Math.min(64, Math.max(1, this.dynamicPlanRadiusChunks) / 2));
        }
        if (this.dynamicPlanStrideChunks > this.dynamicPlanRadiusChunks) {
            this.dynamicPlanStrideChunks = this.dynamicPlanRadiusChunks;
        }
        if (this.dynamicPlanStrideChunks > 256) {
            this.dynamicPlanStrideChunks = 256;
        }
        if (this.planningAlgorithm == null) {
            this.planningAlgorithm = PlanningAlgorithm.RNG;
        }
        if (this.aStarStep > 128) {
            this.aStarStep = 128;
        }
        if (this.aStarMaxSteps < 3000) {
            this.aStarMaxSteps = 3000;
        }
        if (this.aStarMaxSteps > 100000) {
            this.aStarMaxSteps = 100000;
        }
        if (this.causewayMaxDepth < 0) {
            this.causewayMaxDepth = 0;
        }
        if (this.causewayMaxDepth > 12) {
            this.causewayMaxDepth = 12;
        }
        if (this.maxSlopeStepPerTwoSegments < 0) {
            this.maxSlopeStepPerTwoSegments = 0;
        }
        if (this.maxSlopeStepPerTwoSegments > 8) {
            this.maxSlopeStepPerTwoSegments = 8;
        }
        if (this.computeThreads < 0) {
            this.computeThreads = 0;
        }
        if (this.computeThreads > 128) {
            this.computeThreads = 128;
        }
        if (this.pathfindingAlgorithm == null) {
            this.pathfindingAlgorithm = PathfindingAlgorithm.ASTAR_BASIC;
        }
        if (this.roadWidth < 0) {
            this.roadWidth = 0;
        }
        if (this.roadWidth > 15) {
            this.roadWidth = 15;
        }
        if (this.lampInterval < 1) {
            this.lampInterval = 59;
        }
        if (this.lampInterval > 2048) {
            this.lampInterval = 2048;
        }
        if (this.roadClearHeight < 1) {
            this.roadClearHeight = 4;
        }
        if (this.roadClearHeight > 16) {
            this.roadClearHeight = 16;
        }
        if (this.tunnelClearHeight < 2) {
            this.tunnelClearHeight = 2;
        }
        if (this.tunnelClearHeight > 16) {
            this.tunnelClearHeight = 16;
        }
        if (this.bridgeDeckClearance < 1) {
            this.bridgeDeckClearance = 1;
        }
        if (this.bridgeDeckClearance > 8) {
            this.bridgeDeckClearance = 8;
        }
        if (this.bridgePierInterval < 3) {
            this.bridgePierInterval = 3;
        }
        if (this.bridgePierInterval > 32) {
            this.bridgePierInterval = 32;
        }
        if (this.bridgePierWidth < 1) {
            this.bridgePierWidth = 1;
        }
        if (this.bridgePierWidth > 3) {
            this.bridgePierWidth = 3;
        }
        if (this.bridgePierMaxHeight < 6) {
            this.bridgePierMaxHeight = 6;
        }
        if (this.bridgePierMaxHeight > 64) {
            this.bridgePierMaxHeight = 64;
        }
        if (this.bridgeRampSegments < 0) {
            this.bridgeRampSegments = 0;
        }
        if (this.bridgeRampSegments > 12) {
            this.bridgeRampSegments = 12;
        }
        if (this.orthoStepCost < 0.0) {
            this.orthoStepCost = 0.0;
        }
        if (this.diagStepCost < 0.0) {
            this.diagStepCost = 0.0;
        }
        if (this.elevationWeight < 0) {
            this.elevationWeight = 0;
        }
        if (this.biomeWeight < 0) {
            this.biomeWeight = 0;
        }
        if (this.stabilityWeight < 0) {
            this.stabilityWeight = 0;
        }
        if (this.waterDepthWeight < 0) {
            this.waterDepthWeight = 0;
        }
        if (this.nearWaterCost < 0) {
            this.nearWaterCost = 0;
        }
        if (this.heuristicWeight < 0.0) {
            this.heuristicWeight = 0.0;
        }
        if (this.deviationWeight < 0.0) {
            this.deviationWeight = 0.0;
        }
        if (this.roadsideStructureInterval < 1) {
            this.roadsideStructureInterval = 1;
        }
        if (this.roadsideStructureInterval > 256) {
            this.roadsideStructureInterval = 256;
        }
        if (this.roadsideStructureChance < 0.0f) {
            this.roadsideStructureChance = 0.0f;
        }
        if (this.roadsideStructureChance > 1.0f) {
            this.roadsideStructureChance = 1.0f;
        }
        if (this.structureRoadOffset < 0) {
            this.structureRoadOffset = 0;
        }
        if (this.structureRoadOffset > 256) {
            this.structureRoadOffset = 256;
        }
    }

    public int initialPlanRadiusChunks() {
        return this.initialPlanRadiusChunks;
    }

    public void setInitialPlanRadiusChunks(int v) {
        this.initialPlanRadiusChunks = v;
    }

    public boolean dynamicPlanEnabled() {
        return this.dynamicPlanEnabled;
    }

    public void setDynamicPlanEnabled(boolean v) {
        this.dynamicPlanEnabled = v;
    }

    public int dynamicPlanRadiusChunks() {
        return this.dynamicPlanRadiusChunks;
    }

    public void setDynamicPlanRadiusChunks(int v) {
        this.dynamicPlanRadiusChunks = v;
    }

    public int dynamicPlanStrideChunks() {
        return this.dynamicPlanStrideChunks;
    }

    public void setDynamicPlanStrideChunks(int v) {
        this.dynamicPlanStrideChunks = v;
    }

    public boolean allowArtificial() {
        return this.allowArtificial;
    }

    public void setAllowArtificial(boolean v) {
        this.allowArtificial = v;
    }

    public boolean allowNatural() {
        return this.allowNatural;
    }

    public void setAllowNatural(boolean v) {
        this.allowNatural = v;
    }

    public boolean placeWaypoints() {
        return this.placeWaypoints;
    }

    public void setPlaceWaypoints(boolean v) {
        this.placeWaypoints = v;
    }

    public int averagingRadius() {
        return this.averagingRadius;
    }

    public void setAveragingRadius(int v) {
        this.averagingRadius = v;
    }

    public int generationThreads() {
        return this.generationThreads;
    }

    public void setGenerationThreads(int v) {
        this.generationThreads = v;
    }

    public int computeThreads() {
        return this.computeThreads;
    }

    public void setComputeThreads(int v) {
        this.computeThreads = v;
    }

    public int initialGenerationThreads() {
        return this.initialGenerationThreads;
    }

    public void setInitialGenerationThreads(int v) {
        this.initialGenerationThreads = v;
    }

    public int maxConcurrentGenerations() {
        return this.maxConcurrentGenerations;
    }

    public void setMaxConcurrentGenerations(int v) {
        this.maxConcurrentGenerations = v;
    }

    public int aStarStep() {
        return this.aStarStep;
    }

    public void setAStarStep(int v) {
        this.aStarStep = v;
    }

    public int aStarMaxSteps() {
        return this.aStarMaxSteps;
    }

    public void setAStarMaxSteps(int v) {
        this.aStarMaxSteps = v;
    }

    public int causewayMaxDepth() {
        return this.causewayMaxDepth;
    }

    public void setCausewayMaxDepth(int v) {
        this.causewayMaxDepth = v;
    }

    public int maxSlopeStepPerTwoSegments() {
        return this.maxSlopeStepPerTwoSegments;
    }

    public void setMaxSlopeStepPerTwoSegments(int v) {
        this.maxSlopeStepPerTwoSegments = v;
    }

    public boolean slopeLimitEnabled() {
        return this.slopeLimitEnabled;
    }

    public void setSlopeLimitEnabled(boolean v) {
        this.slopeLimitEnabled = v;
    }

    public PathfindingAlgorithm pathfindingAlgorithm() {
        return this.pathfindingAlgorithm;
    }

    public void setPathfindingAlgorithm(PathfindingAlgorithm v) {
        this.pathfindingAlgorithm = v;
    }

    public int roadWidth() {
        return this.roadWidth;
    }

    public void setRoadWidth(int v) {
        this.roadWidth = v;
    }

    public int lampInterval() {
        return this.lampInterval;
    }

    public void setLampInterval(int v) {
        this.lampInterval = v;
    }

    public int roadClearHeight() {
        return this.roadClearHeight;
    }

    public void setRoadClearHeight(int v) {
        this.roadClearHeight = v;
    }

    public PlanningAlgorithm planningAlgorithm() {
        return this.planningAlgorithm;
    }

    public void setPlanningAlgorithm(PlanningAlgorithm v) {
        this.planningAlgorithm = v;
    }

    public boolean tunnelEnabled() {
        return this.tunnelEnabled;
    }

    public void setTunnelEnabled(boolean v) {
        this.tunnelEnabled = v;
    }

    public int tunnelClearHeight() {
        return this.tunnelClearHeight;
    }

    public void setTunnelClearHeight(int v) {
        this.tunnelClearHeight = v;
    }

    public boolean preventTreesOnRoad() {
        return this.preventTreesOnRoad;
    }

    public void setPreventTreesOnRoad(boolean v) {
        this.preventTreesOnRoad = v;
    }

    public boolean bridgeEnabled() {
        return this.bridgeEnabled;
    }

    public void setBridgeEnabled(boolean v) {
        this.bridgeEnabled = v;
    }

    public int bridgeDeckClearance() {
        return this.bridgeDeckClearance;
    }

    public void setBridgeDeckClearance(int v) {
        this.bridgeDeckClearance = v;
    }

    public boolean bridgeRailingEnabled() {
        return this.bridgeRailingEnabled;
    }

    public void setBridgeRailingEnabled(boolean v) {
        this.bridgeRailingEnabled = v;
    }

    public int bridgePierInterval() {
        return this.bridgePierInterval;
    }

    public void setBridgePierInterval(int v) {
        this.bridgePierInterval = v;
    }

    public int bridgePierWidth() {
        return this.bridgePierWidth;
    }

    public void setBridgePierWidth(int v) {
        this.bridgePierWidth = v;
    }

    public int bridgePierMaxHeight() {
        return this.bridgePierMaxHeight;
    }

    public void setBridgePierMaxHeight(int v) {
        this.bridgePierMaxHeight = v;
    }

    public boolean bridgeKeepLamps() {
        return this.bridgeKeepLamps;
    }

    public void setBridgeKeepLamps(boolean v) {
        this.bridgeKeepLamps = v;
    }

    public int bridgeRampSegments() {
        return this.bridgeRampSegments;
    }

    public void setBridgeRampSegments(int v) {
        this.bridgeRampSegments = v;
    }

    public int bridgeMinWaterDepth() {
        return this.bridgeMinWaterDepth;
    }

    public void setBridgeMinWaterDepth(int v) {
        this.bridgeMinWaterDepth = v;
    }

    public int bridgeMinLength() {
        return this.bridgeMinLength;
    }

    public void setBridgeMinLength(int v) {
        this.bridgeMinLength = v;
    }

    public int bridgeMergeGap() {
        return this.bridgeMergeGap;
    }

    public void setBridgeMergeGap(int v) {
        this.bridgeMergeGap = v;
    }

    public double orthoStepCost() {
        return this.orthoStepCost;
    }

    public void setOrthoStepCost(double v) {
        this.orthoStepCost = v;
    }

    public double diagStepCost() {
        return this.diagStepCost;
    }

    public void setDiagStepCost(double v) {
        this.diagStepCost = v;
    }

    public int elevationWeight() {
        return this.elevationWeight;
    }

    public void setElevationWeight(int v) {
        this.elevationWeight = v;
    }

    public int biomeWeight() {
        return this.biomeWeight;
    }

    public void setBiomeWeight(int v) {
        this.biomeWeight = v;
    }

    public int stabilityWeight() {
        return this.stabilityWeight;
    }

    public void setStabilityWeight(int v) {
        this.stabilityWeight = v;
    }

    public int waterDepthWeight() {
        return this.waterDepthWeight;
    }

    public void setWaterDepthWeight(int v) {
        this.waterDepthWeight = v;
    }

    public int nearWaterCost() {
        return this.nearWaterCost;
    }

    public void setNearWaterCost(int v) {
        this.nearWaterCost = v;
    }

    public double heuristicWeight() {
        return this.heuristicWeight;
    }

    public void setHeuristicWeight(double v) {
        this.heuristicWeight = v;
    }

    public double deviationWeight() {
        return this.deviationWeight;
    }

    public void setDeviationWeight(double v) {
        this.deviationWeight = v;
    }

    public boolean roadsideStructuresEnabled() {
        return this.roadsideStructuresEnabled;
    }

    public void setRoadsideStructuresEnabled(boolean v) {
        this.roadsideStructuresEnabled = v;
    }

    public int roadsideStructureInterval() {
        return this.roadsideStructureInterval;
    }

    public void setRoadsideStructureInterval(int v) {
        this.roadsideStructureInterval = v;
    }

    public float roadsideStructureChance() {
        return this.roadsideStructureChance;
    }

    public void setRoadsideStructureChance(float v) {
        this.roadsideStructureChance = v;
    }

    public int structureRoadOffset() {
        return this.structureRoadOffset;
    }

    public void setStructureRoadOffset(int v) {
        this.structureRoadOffset = v;
    }

    public static enum PlanningAlgorithm {
        KNN,
        DELAUNAY,
        RNG;

    }

    public static enum PathfindingAlgorithm {
        ASTAR_BASIC,
        ASTAR_BIDIRECTIONAL,
        GRADIENT_DESCENT;

    }
}

