/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.shiroha233.roadweaver.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PresetService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String BASE_DIR = "roadweaver";
    private static final String PRESET_DIR = "presets";
    private static final AtomicReference<Map<String, PresetDef>> PRESETS = new AtomicReference(new LinkedHashMap());

    private PresetService() {
    }

    public static synchronized void reload() {
        Path cfgRoot = Platform.getConfigFolder();
        Path baseDir = cfgRoot.resolve(BASE_DIR);
        Path presetDir = baseDir.resolve(PRESET_DIR);
        Map<Object, Object> map = new LinkedHashMap();
        try {
            try {
                Files.createDirectories(presetDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create preset directory: {}", (Object)presetDir, (Object)e);
            }
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(presetDir, "*.json");){
                for (Path p : ds) {
                    PresetFile dto = PresetService.readPresetFile(p);
                    if (dto == null) continue;
                    String id = dto.id;
                    if (id == null || id.isBlank()) {
                        id = PresetService.stripExt(p.getFileName().toString());
                    }
                    List<Object> mats = dto.materials != null ? dto.materials : List.of();
                    ArrayList<String> valid = new ArrayList<String>();
                    for (String string : mats) {
                        try {
                            class_2960 rl = new class_2960(string);
                            class_2248 class_22482 = (class_2248)class_7923.field_41175.method_10223(rl);
                            if (class_22482 == null || class_22482 == class_2246.field_10124) continue;
                            valid.add(string);
                        }
                        catch (Throwable rl) {}
                    }
                    List<Object> slabIds = dto.slabMaterials != null ? dto.slabMaterials : List.of();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string : slabIds) {
                        try {
                            class_2960 rl = new class_2960(string);
                            class_2248 b = (class_2248)class_7923.field_41175.method_10223(rl);
                            if (b == null || b == class_2246.field_10124) continue;
                            arrayList.add(string);
                        }
                        catch (Throwable throwable) {}
                    }
                    if (valid.isEmpty()) {
                        LOGGER.warn("Skip preset {} due to empty/invalid materials", (Object)p.getFileName());
                        continue;
                    }
                    String name = dto.name == null || dto.name.isBlank() ? id : dto.name;
                    PresetDef presetDef = new PresetDef(id, name, Collections.unmodifiableList(valid), Collections.unmodifiableList(arrayList));
                    if (map.containsKey(id)) {
                        LOGGER.warn("Duplicate preset id '{}', file {} is ignored", (Object)id, (Object)p.getFileName());
                        continue;
                    }
                    map.put(id, presetDef);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed scanning presets: {}", (Object)presetDir, (Object)e);
        }
        if (map.isEmpty()) {
            try {
                PresetService.writeSamplePresets(presetDir);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to write sample presets: {}", (Object)e.toString());
            }
            map = PresetService.defaultPresets();
        }
        PRESETS.set(map);
        LOGGER.info("Presets loaded: {} entries", (Object)map.size());
    }

    private static String stripExt(String fn) {
        int i = fn.lastIndexOf(46);
        return i > 0 ? fn.substring(0, i) : fn;
    }

    private static PresetFile readPresetFile(Path p) {
        PresetFile presetFile;
        block8: {
            BufferedReader br = Files.newBufferedReader(p, StandardCharsets.UTF_8);
            try {
                presetFile = (PresetFile)GSON.fromJson((Reader)br, PresetFile.class);
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to read preset file {}: {}", (Object)p.getFileName(), (Object)e.toString());
                    return null;
                }
            }
            br.close();
        }
        return presetFile;
    }

    private static void writeSamplePresets(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PresetFile a = new PresetFile();
        a.id = "stone_street";
        a.name = "Stone Street";
        a.materials = List.of("minecraft:stone_bricks", "minecraft:polished_andesite");
        a.slabMaterials = List.of("minecraft:stone_brick_slab", "minecraft:polished_andesite_slab");
        PresetFile b = new PresetFile();
        b.id = "mud_road";
        b.name = "Mud Road";
        b.materials = List.of("minecraft:mud_bricks", "minecraft:packed_mud");
        b.slabMaterials = List.of("minecraft:mud_brick_slab");
        PresetFile c = new PresetFile();
        c.id = "aged_stone";
        c.name = "Aged Stone";
        c.materials = List.of("minecraft:stone_bricks", "minecraft:mossy_stone_bricks", "minecraft:cracked_stone_bricks");
        c.slabMaterials = List.of("minecraft:stone_brick_slab", "minecraft:mossy_stone_brick_slab");
        PresetService.writePreset(dir.resolve("stone_street.json"), a);
        PresetService.writePreset(dir.resolve("mud_road.json"), b);
        PresetService.writePreset(dir.resolve("aged_stone.json"), c);
    }

    private static void writePreset(Path file, PresetFile dto) {
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)dto, (Appendable)bw);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Map<String, PresetDef> defaultPresets() {
        LinkedHashMap<String, PresetDef> m = new LinkedHashMap<String, PresetDef>();
        PresetDef a = new PresetDef("mud_road", "Mud Road", List.of("minecraft:mud_bricks", "minecraft:packed_mud"), List.of("minecraft:mud_brick_slab"));
        PresetDef b = new PresetDef("stone_street", "Stone Street", List.of("minecraft:polished_andesite", "minecraft:stone_bricks"), List.of("minecraft:polished_andesite_slab", "minecraft:stone_brick_slab"));
        PresetDef c = new PresetDef("aged_stone", "Aged Stone", List.of("minecraft:stone_bricks", "minecraft:mossy_stone_bricks", "minecraft:cracked_stone_bricks"), List.of("minecraft:stone_brick_slab", "minecraft:mossy_stone_brick_slab"));
        m.put(a.id(), a);
        m.put(b.id(), b);
        m.put(c.id(), c);
        return m;
    }

    public static synchronized List<PresetDef> getAllPresets() {
        if (PRESETS.get().isEmpty()) {
            PresetService.reload();
        }
        return List.copyOf(PRESETS.get().values());
    }

    public static synchronized PresetDef choosePresetForArtificial(class_5819 rnd, ModConfig cfg) {
        Map<String, PresetDef> all;
        ArrayList<PresetDef> pool;
        if (PRESETS.get().isEmpty()) {
            PresetService.reload();
        }
        if ((pool = new ArrayList<PresetDef>((all = PRESETS.get()).values())).isEmpty()) {
            pool = new ArrayList<PresetDef>(PresetService.defaultPresets().values());
        }
        return PresetService.pickPreset(rnd, pool);
    }

    public static synchronized List<class_2680> chooseMaterialsForArtificial(class_5819 rnd, ModConfig cfg) {
        PresetDef chosen = PresetService.choosePresetForArtificial(rnd, cfg);
        return PresetService.toBlockStates(chosen.materials());
    }

    private static PresetDef pickPreset(class_5819 rnd, List<PresetDef> pool) {
        return pool.get(rnd.method_43048(pool.size()));
    }

    private static List<class_2680> toBlockStates(List<String> ids) {
        ArrayList<class_2680> out = new ArrayList<class_2680>();
        if (ids == null) {
            return out;
        }
        for (String s : ids) {
            try {
                class_2960 rl = new class_2960(s);
                class_2248 b = (class_2248)class_7923.field_41175.method_10223(rl);
                if (b == null || b == class_2246.field_10124) continue;
                out.add(b.method_9564());
            }
            catch (Throwable throwable) {}
        }
        if (out.isEmpty()) {
            out.add(class_2246.field_10056.method_9564());
        }
        return out;
    }

    public static List<class_2680> toBlockStatesFromIds(List<String> ids) {
        return PresetService.toBlockStates(ids);
    }

    public static synchronized List<List<String>> getMaterialCombos() {
        if (PRESETS.get().isEmpty()) {
            PresetService.reload();
        }
        ArrayList<List<String>> combos = new ArrayList<List<String>>();
        for (PresetDef d : PRESETS.get().values()) {
            combos.add(d.materials());
        }
        return combos;
    }

    public static synchronized void saveOrUpdatePresetFile(String id, String name, List<String> materials) {
        PresetService.saveOrUpdatePresetFile(id, name, materials, null);
    }

    public static synchronized void saveOrUpdatePresetFile(String id, String name, List<String> materials, List<String> slabMaterials) {
        if (id == null || id.isBlank()) {
            return;
        }
        Path cfgRoot = Platform.getConfigFolder();
        Path baseDir = cfgRoot.resolve(BASE_DIR);
        Path presetDir = baseDir.resolve(PRESET_DIR);
        try {
            Files.createDirectories(presetDir, new FileAttribute[0]);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create preset directory: {}", (Object)presetDir, (Object)e);
        }
        PresetFile dto = new PresetFile();
        dto.id = id;
        dto.name = name;
        dto.materials = materials == null ? List.of() : new ArrayList<String>(materials);
        dto.slabMaterials = slabMaterials == null ? List.of() : new ArrayList<String>(slabMaterials);
        PresetService.writePreset(presetDir.resolve(id + ".json"), dto);
    }

    public static synchronized void deletePresetFile(String id) {
        if (id == null || id.isBlank()) {
            return;
        }
        Path cfgRoot = Platform.getConfigFolder();
        Path baseDir = cfgRoot.resolve(BASE_DIR);
        Path presetDir = baseDir.resolve(PRESET_DIR);
        try {
            Files.deleteIfExists(presetDir.resolve(id + ".json"));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete preset file for id {}: {}", (Object)id, (Object)e.toString());
        }
    }

    private static class PresetFile {
        String id;
        String name;
        List<String> materials;
        List<String> slabMaterials;

        private PresetFile() {
        }
    }

    public record PresetDef(String id, String name, List<String> materials, List<String> slabMaterials) {
    }
}

