/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.bridge;

import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.system.AboveColumnClearer;
import net.shiroha233.roadweaver.helpers.Records;

public final class BridgeBuilder {
    private static final class_2680 DECK = class_2246.field_10056.method_9564();
    private static final class_2680 PIER = class_2246.field_10056.method_9564();

    private BridgeBuilder() {
    }

    public static void placeSegment(class_5281 world, Records.RoadSegmentPlacement seg, class_2338 middle, class_2338 prev, class_2338 next, int roadWidth, int deckY, int segmentIndex, class_5819 random, ModConfig cfg, boolean placePier, boolean placeRail) {
        int interval;
        for (class_2338 widthPos : seg.positions()) {
            class_2338 deckPos = new class_2338(widthPos.method_10263(), deckY, widthPos.method_10260());
            world.method_8652(deckPos, DECK, 3);
            AboveColumnClearer.clearAboveColumn(world, deckPos.method_10084(), cfg);
        }
        if (placePier && segmentIndex % (interval = Math.max(3, cfg.bridgePierInterval())) == 0) {
            BridgeBuilder.placePierUnder(world, middle.method_10263(), middle.method_10260(), deckY - 1, cfg.bridgePierMaxHeight(), cfg.bridgePierWidth());
        }
    }

    private static void placePierUnder(class_5281 world, int x, int z, int fromY, int maxHeight, int pierWidth) {
        int minY = world.method_31607();
        int half = Math.max(0, pierWidth - 1);
        for (int dx = -half; dx <= half; ++dx) {
            for (int dz = -half; dz <= half; ++dz) {
                class_2338 cur;
                int y = fromY;
                for (int h = 0; y >= minY && h < maxHeight && !world.method_8320(cur = new class_2338(x + dx, y, z + dz)).method_26206((class_1922)world, cur, class_2350.field_11036); --y, ++h) {
                    world.method_8652(cur, PIER, 3);
                }
            }
        }
    }
}

