/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.search.StructurePredictor;

public final class StructureRoadOffsetService {
    private static final int MATCH_TOLERANCE_BLOCKS = 16;

    private StructureRoadOffsetService() {
    }

    public static class_2338 adjustEndpoint(class_3218 level, class_2338 endpoint, class_2338 otherEnd) {
        long dz;
        if (endpoint == null || otherEnd == null) {
            return endpoint;
        }
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return endpoint;
        }
        int offset = StructureRoadOffsetService.getOffsetBlocksForEndpoint(level, endpoint);
        if (offset <= 0) {
            return endpoint;
        }
        long dx = (long)otherEnd.method_10263() - (long)endpoint.method_10263();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = (long)otherEnd.method_10260() - (long)endpoint.method_10260()) * (double)dz);
        if (len == 0.0) {
            return endpoint;
        }
        double nx = (double)dx / len;
        double nz = (double)dz / len;
        int ox = (int)Math.round(nx * (double)offset);
        int oz = (int)Math.round(nz * (double)offset);
        return endpoint.method_10069(ox, 0, oz);
    }

    private static int getOffsetBlocksForEndpoint(class_3218 level, class_2338 endpoint) {
        StructureCategory cat = StructureRoadOffsetService.detectCategory(level, endpoint);
        int configOffset = ConfigService.get().structureRoadOffset();
        return switch (cat) {
            case StructureCategory.VILLAGE -> configOffset;
            default -> 0;
        };
    }

    private static StructureCategory detectCategory(class_3218 level, class_2338 endpoint) {
        int cz;
        if (!class_1937.field_25179.equals(level.method_27983())) {
            return StructureCategory.UNKNOWN;
        }
        int cx = endpoint.method_10263() >> 4;
        List<Records.StructureInfo> infos = StructurePredictor.predictOverworldStructuresInRect(level, cx, cz = endpoint.method_10260() >> 4, cx, cz, true, List.of("#minecraft:village"), List.of());
        if (infos == null || infos.isEmpty()) {
            return StructureCategory.UNKNOWN;
        }
        long tol2 = 256L;
        for (Records.StructureInfo info : infos) {
            long dz;
            class_2338 p = info.pos();
            long dx = (long)p.method_10263() - (long)endpoint.method_10263();
            long d2 = dx * dx + (dz = (long)p.method_10260() - (long)endpoint.method_10260()) * dz;
            if (d2 > tol2) continue;
            return StructureCategory.VILLAGE;
        }
        return StructureCategory.UNKNOWN;
    }

    private static enum StructureCategory {
        VILLAGE,
        OTHER,
        UNKNOWN;

    }
}

