/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.PathPostProcessor;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

final class BasicAStarPathfinder {
    private static final int BIOME_BASE_COST = 12;
    private static final double HEURISTIC_EPSILON = 0.2;

    private BasicAStarPathfinder() {
    }

    public static List<Records.RoadSegmentPlacement> calculateLandPath(class_2338 startGround, class_2338 endGround, int width, class_3218 level, int maxSteps, TerrainSamplingCache cache) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<class_2338, Node> allNodes = new HashMap<class_2338, Node>();
        HashSet<class_2338> closed = new HashSet<class_2338>();
        ModConfig cfg = ConfigService.get();
        Node startNode = new Node(startGround, null, 0.0, BasicAStarPathfinder.heuristic(startGround, endGround, cfg));
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = BasicAStarPathfinder.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        int stepsBudget = Math.max(1, maxSteps);
        while (!openSet.isEmpty() && stepsBudget-- > 0) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node current = openSet.poll();
            if (current == null) break;
            if (BasicAStarPathfinder.manhattan2d(current.pos, endGround) < d * 2) {
                ArrayList<class_2338> rawPath = new ArrayList<class_2338>();
                Node c = current;
                while (c != null) {
                    rawPath.add(c.pos);
                    c = c.parent;
                }
                Collections.reverse(rawPath);
                return PathPostProcessor.process(rawPath, width, level, cache);
            }
            closed.add(current.pos);
            allNodes.remove(current.pos);
            for (int[] off : neighborOffsets) {
                int offsetSum;
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                class_2338 nxz = current.pos.method_10069(off[0], 0, off[1]);
                int y = RoadPathCalculator.heightSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
                class_2338 np = new class_2338(nxz.method_10263(), y, nxz.method_10260());
                if (closed.contains(np)) continue;
                class_6880<class_1959> biome = cache.getBiome(level, np.method_10263(), np.method_10260());
                int biomeCost = biome.method_40220(class_6908.field_36511) || biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36508) ? 12 : 0;
                int elevation = Math.abs(y - current.pos.method_10264());
                int midX = (current.pos.method_10263() + np.method_10263()) / 2;
                int midZ = (current.pos.method_10260() + np.method_10260()) / 2;
                int midY = RoadPathCalculator.heightSampler(cache, midX, midZ, level);
                int midDiff = Math.max(Math.abs(midY - current.pos.method_10264()), Math.abs(midY - y));
                double midTerrainPenalty = 0.0;
                if (midDiff > 4) {
                    midTerrainPenalty = (double)(midDiff * midDiff * cfg.elevationWeight()) * 0.5;
                }
                double stepCost = (offsetSum = Math.abs(Math.abs(off[0])) + Math.abs(off[1])) == 2 * d ? cfg.diagStepCost() : cfg.orthoStepCost();
                int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level);
                int sea = level.method_8615();
                boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.method_10263(), nxz.method_10260(), level);
                boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.method_10263(), nxz.method_10260(), level);
                int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
                int waterDepth = Math.max(0, sea - oceanFloor);
                int waterDepthCost = waterColumn ? waterDepth * cfg.waterDepthWeight() : 0;
                int nearWaterCost = nearWater ? cfg.nearWaterCost() : 0;
                double deviation = BasicAStarPathfinder.deviation2d(np, startGround, endGround);
                double deviationCost = deviation * cfg.deviationWeight() / Math.max(1.0, (double)d);
                double tentativeG = current.g + stepCost + (double)(elevation * cfg.elevationWeight()) + midTerrainPenalty + (double)(biomeCost * cfg.biomeWeight()) + (double)(stabilityCost * cfg.stabilityWeight()) + (double)waterDepthCost + (double)nearWaterCost + deviationCost;
                Node n2 = (Node)allNodes.get(np);
                if (n2 != null && !(tentativeG < n2.g)) continue;
                double h = BasicAStarPathfinder.heuristic(np, endGround, cfg);
                double fWeighted = tentativeG + 1.2 * h;
                n2 = new Node(np, current, tentativeG, fWeighted);
                allNodes.put(np, n2);
                openSet.add(n2);
            }
        }
        return null;
    }

    private static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    private static int manhattan2d(class_2338 a, class_2338 b) {
        return Math.abs(a.method_10263() - b.method_10263()) + Math.abs(a.method_10260() - b.method_10260());
    }

    private static double heuristic(class_2338 a, class_2338 b, ModConfig cfg) {
        int dx = a.method_10263() - b.method_10263();
        int dz = a.method_10260() - b.method_10260();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * cfg.heuristicWeight();
    }

    private static double deviation2d(class_2338 p, class_2338 a, class_2338 b) {
        double ax = a.method_10263();
        double az = a.method_10260();
        double bx = b.method_10263();
        double bz = b.method_10260();
        double px = p.method_10263();
        double pz = p.method_10260();
        double num = Math.abs((bz - az) * px - (bx - ax) * pz + bx * az - bz * ax);
        double den = Math.hypot(bx - ax, bz - az);
        if (den <= 0.0) {
            return 0.0;
        }
        return num / den;
    }

    private static final class Node {
        final class_2338 pos;
        final Node parent;
        final double g;
        final double f;

        Node(class_2338 pos, Node parent, double g, double f) {
            this.pos = pos;
            this.parent = parent;
            this.g = g;
            this.f = f;
        }
    }
}

