/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.pipeline;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.model.StructureInstance;
import net.shiroha233.roadweaver.structures.roadside.BeardedTerracePlacer;

public final class StructurePlacer {
    private static final int DEFAULT_TERRACE_BUFFER = 2;
    private static final int DEFAULT_TERRACE_TRANSITION = 4;

    private StructurePlacer() {
    }

    public static StructureInstance place(class_3218 level, StructureBlueprint bp, class_2960 variantTemplateId, class_2338 anchor, class_2470 rotation, class_2415 mirror, class_238 preBounds, BlendProfile blend) {
        class_2960 id = StructurePlacer.normalizeTemplateId(variantTemplateId);
        class_3485 mgr = level.method_8503().method_27727();
        Optional opt = mgr.method_15094(id);
        if (opt.isEmpty()) {
            opt = mgr.method_15094(variantTemplateId);
        }
        if (opt.isEmpty()) {
            class_238 b = preBounds != null ? preBounds : new class_238(anchor).method_1009(8.0, 5.0, 8.0);
            return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.method_27983().method_29177(), anchor, b, level.method_8510());
        }
        class_3499 tpl = (class_3499)opt.get();
        class_2382 raw = tpl.method_15160();
        class_2382 size = StructurePlacer.rotatedSize(raw, rotation);
        class_2338 min = anchor;
        class_2338 max = anchor.method_10069(size.method_10263() - 1, size.method_10264() - 1, size.method_10260() - 1);
        class_238 bounds = new class_238(min, max);
        if (blend != null) {
            int centerX = (min.method_10263() + max.method_10263()) / 2;
            int centerZ = (min.method_10260() + max.method_10260()) / 2;
            int targetY = min.method_10264();
            int structureRadius = Math.max(size.method_10263(), size.method_10260()) / 2;
            int innerRadius = structureRadius + 2;
            int outerRadius = innerRadius + Math.max(8, blend.ringOuter() - blend.ringInner());
            BeardedTerracePlacer.buildTerraceForLargeStructure((class_1936)level, centerX, centerZ, targetY, innerRadius, outerRadius, level.method_8409());
        }
        class_3492 settings = new class_3492().method_15123(rotation).method_15125(mirror);
        tpl.method_15172((class_5425)level, anchor, anchor, settings, level.method_8409(), 2);
        return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.method_27983().method_29177(), anchor, bounds, level.method_8510());
    }

    private static class_2960 normalizeTemplateId(class_2960 in) {
        String path = in.method_12832();
        if (path.startsWith("structures/")) {
            return new class_2960(in.method_12836(), path.substring("structures/".length()));
        }
        return in;
    }

    private static class_2382 rotatedSize(class_2382 s, class_2470 r) {
        return switch (r) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467, class_2470.field_11464 -> s;
            case class_2470.field_11463, class_2470.field_11465 -> new class_2382(s.method_10260(), s.method_10264(), s.method_10263());
        };
    }

    public static boolean placeSimple(class_5281 world, class_3218 server, class_2960 templateId, class_2338 anchor, class_2470 rotation, boolean withTerrace, boolean noBasement, class_5819 random) {
        class_3485 mgr = server.method_14183();
        Optional<class_3499> opt = StructurePlacer.loadTemplate(mgr, templateId);
        if (opt.isEmpty()) {
            return false;
        }
        class_3499 tpl = opt.get();
        class_2382 size = tpl.method_15166(rotation);
        if (withTerrace) {
            int targetY = noBasement ? anchor.method_10264() - 1 : anchor.method_10264();
            StructurePlacer.buildTerraceInternal(world, anchor, size, targetY, random);
        }
        class_3492 settings = new class_3492().method_15123(rotation).method_15125(class_2415.field_11302).method_15133(false);
        tpl.method_15172((class_5425)world, anchor, anchor, settings, random, 2);
        return true;
    }

    public static boolean placeSimple(class_3218 level, class_2960 templateId, class_2338 anchor, class_2470 rotation, boolean withTerrace, boolean noBasement) {
        class_3485 mgr = level.method_14183();
        Optional<class_3499> opt = StructurePlacer.loadTemplate(mgr, templateId);
        if (opt.isEmpty()) {
            return false;
        }
        class_3499 tpl = opt.get();
        class_2382 size = tpl.method_15166(rotation);
        if (withTerrace) {
            int targetY = noBasement ? anchor.method_10264() - 1 : anchor.method_10264();
            int centerX = anchor.method_10263() + size.method_10263() / 2;
            int centerZ = anchor.method_10260() + size.method_10260() / 2;
            int structureRadius = Math.max(size.method_10263(), size.method_10260()) / 2;
            int innerRadius = structureRadius + 2;
            int outerRadius = innerRadius + 4;
            BeardedTerracePlacer.buildTerraceForLargeStructure((class_1936)level, centerX, centerZ, targetY, innerRadius, outerRadius, level.method_8409());
        }
        class_3492 settings = new class_3492().method_15123(rotation).method_15125(class_2415.field_11302).method_15133(false);
        tpl.method_15172((class_5425)level, anchor, anchor, settings, level.method_8409(), 2);
        return true;
    }

    private static Optional<class_3499> loadTemplate(class_3485 mgr, class_2960 templateId) {
        Optional opt = mgr.method_15094(templateId);
        if (opt.isPresent()) {
            return opt;
        }
        class_2960 altId = new class_2960(templateId.method_12836(), "structures/" + templateId.method_12832());
        opt = mgr.method_15094(altId);
        if (opt.isPresent()) {
            return opt;
        }
        String path = templateId.method_12832();
        if (path.startsWith("structures/")) {
            class_2960 cleanId = new class_2960(templateId.method_12836(), path.substring("structures/".length()));
            return mgr.method_15094(cleanId);
        }
        return Optional.empty();
    }

    private static void buildTerraceInternal(class_5281 world, class_2338 anchor, class_2382 size, int targetY, class_5819 random) {
        BeardedTerracePlacer.buildTerrace(world, new class_2338(anchor.method_10263(), targetY + 1, anchor.method_10260()), size, random);
    }
}

