/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.pipeline.StructurePlacer;
import net.shiroha233.roadweaver.structures.roadside.RoadsideBlueprints;
import net.shiroha233.roadweaver.structures.roadside.RoadsideType;

public final class RoadsideStructureService {
    private static final int BASE_SIDE_OFFSET = 8;
    private static final int RANDOM_OFFSET_RANGE = 4;

    private RoadsideStructureService() {
    }

    public static boolean tryPlace(class_5281 world, class_3218 server, class_2338 middlePos, class_2338 prevPos, class_2338 nextPos, int roadWidth, int segmentIndex, class_5819 random, ModConfig cfg) {
        int dz;
        if (!cfg.roadsideStructuresEnabled()) {
            return false;
        }
        int interval = Math.max(1, cfg.roadsideStructureInterval());
        if (segmentIndex % interval != 0) {
            return false;
        }
        float chance = Math.max(0.0f, Math.min(1.0f, cfg.roadsideStructureChance()));
        if (random.method_43057() > chance) {
            return false;
        }
        int dx = nextPos.method_10263() - prevPos.method_10263();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.method_10260() - prevPos.method_10260()) * (double)dz);
        if (len < 0.001) {
            return false;
        }
        double dirX = (double)dx / len;
        double dirZ = (double)dz / len;
        double orthoX = -dirZ;
        double orthoZ = dirX;
        boolean leftSide = random.method_43056();
        double sideMultiplier = leftSide ? 1.0 : -1.0;
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = 8 + halfWidth + random.method_43048(5);
        int placeX = middlePos.method_10263() + (int)Math.round(orthoX * (double)sideOffset * sideMultiplier);
        int placeZ = middlePos.method_10260() + (int)Math.round(orthoZ * (double)sideOffset * sideMultiplier);
        int placeY = world.method_8624(class_2902.class_2903.field_13203, placeX, placeZ);
        class_2338 placePos = new class_2338(placeX, placeY, placeZ);
        int heightDiff = Math.abs(placeY - middlePos.method_10264());
        if (heightDiff > 5) {
            return false;
        }
        RoadsideType type = RoadsideType.chooseWeighted(random);
        StructureBlueprint bp = RoadsideBlueprints.get(type);
        if (bp == null) {
            return false;
        }
        int minDist = bp.spawnRule().separation();
        if (StructureSystem.index(server).existsNear(placePos, minDist)) {
            return false;
        }
        class_2470 rotation = RoadsideStructureService.calculateRotation(dirX, dirZ, leftSide, type.faceRoad());
        class_2960 templateId = type.templateId();
        return StructurePlacer.placeSimple(world, server, templateId, placePos, rotation, true, true, random);
    }

    public static void processSegments(class_5281 world, class_3218 server, List<class_2338> middlePositions, int roadWidth, class_5819 random, ModConfig cfg, int startIndex, int endIndex) {
        if (middlePositions == null || middlePositions.size() < 5) {
            return;
        }
        int safeStart = Math.max(2, startIndex);
        int safeEnd = Math.min(middlePositions.size() - 3, endIndex);
        for (int i = safeStart; i < safeEnd; ++i) {
            class_2338 middle = middlePositions.get(i);
            class_2338 prev = middlePositions.get(i - 2);
            class_2338 next = middlePositions.get(i + 2);
            RoadsideStructureService.tryPlace(world, server, middle, prev, next, roadWidth, i, random, cfg);
        }
    }

    private static class_2470 calculateRotation(double dirX, double dirZ, boolean leftSide, boolean faceRoad) {
        double absZ;
        if (!faceRoad) {
            return class_2470.field_11467;
        }
        double absX = Math.abs(dirX);
        if (absX > (absZ = Math.abs(dirZ))) {
            if (leftSide) {
                return dirX > 0.0 ? class_2470.field_11464 : class_2470.field_11467;
            }
            return dirX > 0.0 ? class_2470.field_11467 : class_2470.field_11464;
        }
        if (leftSide) {
            return dirZ > 0.0 ? class_2470.field_11463 : class_2470.field_11465;
        }
        return dirZ > 0.0 ? class_2470.field_11465 : class_2470.field_11463;
    }
}

