/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.interaction;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;

public final class MapInteraction {
    private MapInteraction() {
    }

    public static void renderHoverHighlight(GuiGraphics g, MapSnapshot snapshot, MapView view, int mapX, int mapY, int mapW, int mapH, int innerPad, double mouseX, double mouseY) {
        double mx = mouseX;
        double my = mouseY;
        if (!MapInteraction.insideMap(mx, my, mapX, mapY, mapW, mapH, innerPad)) {
            return;
        }
        int bestDist = Integer.MAX_VALUE;
        BlockPos best = null;
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        for (BlockPos p : snapshot.structures()) {
            int dy;
            if (!view.isInViewWorld(p.m_123341_(), p.m_123343_())) continue;
            int x = view.toScreenX(p.m_123341_(), mapX, innerPad, contentW);
            int y = view.toScreenY(p.m_123343_(), mapY, innerPad, contentH);
            int dx = (int)Math.abs((double)x - mx);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - my)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            int x = view.toScreenX(best.m_123341_(), mapX, innerPad, contentW);
            int y = view.toScreenY(best.m_123343_(), mapY, innerPad, contentH);
            g.m_280509_(x - 4, y - 4, x + 5, y + 5, -855648945);
        }
    }

    public static void renderHoverTooltip(GuiGraphics g, Font font, MapSnapshot snapshot, MapView view, int mapX, int mapY, int mapW, int mapH, int innerPad, double mouseX, double mouseY) {
        double mx = mouseX;
        double my = mouseY;
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        if (!MapInteraction.insideMap(mx, my, mapX, mapY, mapW, mapH, innerPad)) {
            int wx = (int)Math.round(view.screenToWorldX(mx, mapX, innerPad, contentW));
            int wz = (int)Math.round(view.screenToWorldZ(my, mapY, innerPad, contentH));
            g.m_280557_(font, (Component)Component.m_237110_((String)"gui.roadweaver.map.coord", (Object[])new Object[]{wx, wz}), (int)mx, (int)my);
            return;
        }
        int bestDist = Integer.MAX_VALUE;
        BlockPos best = null;
        for (BlockPos p : snapshot.structures()) {
            int dy;
            if (!view.isInViewWorld(p.m_123341_(), p.m_123343_())) continue;
            int x = view.toScreenX(p.m_123341_(), mapX, innerPad, contentW);
            int y = view.toScreenY(p.m_123343_(), mapY, innerPad, contentH);
            int dx = (int)Math.abs((double)x - mx);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - my)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            String name = snapshot.structureName(best);
            String alias = ClientMapNotes.getAlias(best);
            MutableComponent coords = Component.m_237110_((String)"gui.roadweaver.map.coord", (Object[])new Object[]{best.m_123341_(), best.m_123343_()});
            MutableComponent label = alias != null ? Component.m_237113_((String)alias).m_130946_(" ").m_7220_((Component)coords) : (name != null ? Component.m_237113_((String)name).m_130946_(" ").m_7220_((Component)coords) : coords);
            g.m_280557_(font, (Component)label, (int)mx, (int)my);
        } else {
            int wx = (int)Math.round(view.screenToWorldX(mx, mapX, innerPad, contentW));
            int wz = (int)Math.round(view.screenToWorldZ(my, mapY, innerPad, contentH));
            g.m_280557_(font, (Component)Component.m_237110_((String)"gui.roadweaver.map.coord", (Object[])new Object[]{wx, wz}), (int)mx, (int)my);
        }
    }

    private static boolean insideMap(double x, double y, int mapX, int mapY, int mapW, int mapH, int innerPad) {
        return x >= (double)(mapX + innerPad) && x <= (double)(mapX + mapW - innerPad) && y >= (double)(mapY + innerPad) && y <= (double)(mapY + mapH - innerPad);
    }
}

