/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.base.Decoration;
import net.shiroha233.roadweaver.features.decoration.system.DecorationExecutor;
import net.shiroha233.roadweaver.features.decoration.system.DecorationPlanner;
import net.shiroha233.roadweaver.features.roadlogic.bridge.BridgeRangeCalculator;
import net.shiroha233.roadweaver.features.roadlogic.bridge.BridgeSegmentPlanner;
import net.shiroha233.roadweaver.features.roadlogic.core.SegmentPaver;
import net.shiroha233.roadweaver.features.roadlogic.surface.BridgeTransitionAdjuster;
import net.shiroha233.roadweaver.features.roadlogic.surface.HeightProfileService;
import net.shiroha233.roadweaver.features.roadlogic.surface.RoadTerrainAdapter;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;
import net.shiroha233.roadweaver.structures.roadside.RoadsideStructureService;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RoadFeatureConfig> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        ServerLevel lvl = world.m_6018_();
        if (!(lvl instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = lvl;
        ChunkPos currentChunk = new ChunkPos(ctx.m_159777_());
        int minX = currentChunk.m_45604_();
        int minZ = currentChunk.m_45605_();
        int maxX = currentChunk.m_45608_();
        int maxZ = currentChunk.m_45609_();
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(server, minX, minZ, maxX, maxZ);
        if (roadDataList == null || roadDataList.isEmpty()) {
            return false;
        }
        RandomSource random = ctx.m_225041_();
        ModConfig cfg = ConfigService.get();
        int averagingRadius = Math.max(0, cfg.averagingRadius());
        HashSet<BlockPos> processedMiddle = new HashSet<BlockPos>();
        HashSet<Decoration> decorations = new HashSet<Decoration>();
        for (Records.RoadData data : roadDataList) {
            RoadFeature.processRoadDataInChunk(world, server, currentChunk, data, processedMiddle, decorations, random, cfg, averagingRadius);
        }
        DecorationExecutor.tryPlaceDecorations(decorations);
        return true;
    }

    private static void processRoadDataInChunk(WorldGenLevel world, ServerLevel server, ChunkPos currentChunk, Records.RoadData data, Set<BlockPos> processedMiddle, Set<Decoration> decorations, RandomSource random, ModConfig cfg, int averagingRadius) {
        int roadType = data.roadType();
        int roadWidth = Math.max(1, data.width());
        List<BlockState> materials = data.materials();
        List<BlockState> slabMaterials = data.slabMaterials();
        List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
        if (segments == null || segments.size() < 5) {
            return;
        }
        List<BlockPos> middlePositions = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
        BridgeRangeCalculator.RangeResult res = BridgeRangeCalculator.compute(middlePositions, data.spans());
        boolean[] isBridge = res.isBridge();
        List<int[]> bridgeRanges = res.mergedRanges();
        List<Integer> targetY = data.targetY();
        HeightProfileService.HeightProfile hp = HeightProfileService.build(world, middlePositions, currentChunk, averagingRadius, cfg, targetY);
        boolean usePersisted = hp.usePersisted();
        int[] smoothedYArr = hp.smoothedY();
        int[] baseYArr = usePersisted && targetY != null && targetY.size() == middlePositions.size() ? targetY.stream().mapToInt(Integer::intValue).toArray() : smoothedYArr;
        if (baseYArr != null && cfg.bridgeEnabled() && !bridgeRanges.isEmpty()) {
            baseYArr = BridgeTransitionAdjuster.adjust(baseYArr, bridgeRanges, cfg);
        }
        int deckY = server.m_5736_() + cfg.bridgeDeckClearance();
        int segmentIndex = 0;
        BridgeSegmentPlanner.Context bridgeCtx = BridgeSegmentPlanner.newContext();
        for (int i = 2; i < segments.size() - 2; ++i) {
            ChunkPos middleChunk;
            BlockPos middle = middlePositions.get(i);
            if (!processedMiddle.add(middle) || ++segmentIndex < 8 || segmentIndex > segments.size() - 8 || !(middleChunk = new ChunkPos(middle)).equals((Object)currentChunk)) continue;
            BlockPos prev = middlePositions.get(i - 2);
            BlockPos next = middlePositions.get(i + 2);
            int topYCenter = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, middle.m_123341_(), middle.m_123343_());
            BlockPos averaged = new BlockPos(middle.m_123341_(), topYCenter, middle.m_123343_());
            int baseYForThis = baseYArr != null ? baseYArr[i] : topYCenter;
            Records.RoadSegmentPlacement seg = segments.get(i);
            if (cfg.bridgeEnabled() && isBridge[i]) {
                BridgeSegmentPlanner.processSegment(world, seg, middle, prev, next, roadWidth, baseYForThis, deckY, segmentIndex, random, cfg, bridgeRanges, baseYArr, i, bridgeCtx);
            } else {
                RoadTerrainAdapter.adapt(world, middle, roadWidth, baseYForThis, random, cfg);
                SegmentPaver.paveSegment(world, seg, i, middlePositions, baseYArr, roadType, materials, slabMaterials, random, cfg);
            }
            if (!isBridge[i] || cfg.bridgeKeepLamps()) {
                DecorationPlanner.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadWidth, random, cfg, roadType == 0 ? DecorationPlanner.Mode.ARTIFICIAL : DecorationPlanner.Mode.NATURAL);
            }
            if (isBridge[i]) continue;
            RoadsideStructureService.tryPlace(world, server, middle, prev, next, roadWidth, segmentIndex, random, cfg);
        }
    }
}

