/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.system.AboveColumnClearer;
import net.shiroha233.roadweaver.features.decoration.system.PlacementRules;

public final class RoadBlockPlacer {
    private RoadBlockPlacer() {
    }

    public static void placeRoadBlock(WorldGenLevel world, BlockState blockBelow, BlockPos surfacePos, List<BlockState> materials, RandomSource random, ModConfig cfg) {
        if (!PlacementRules.placeAllowedCheck(blockBelow.m_60734_())) {
            return;
        }
        BlockState chosen = materials.get(random.m_188503_(materials.size()));
        int MAX_CAUSEWAY_DEPTH = Math.max(0, Math.min(12, cfg == null ? 1 : cfg.causewayMaxDepth()));
        BlockPos below1 = surfacePos.m_7495_();
        BlockPos below2 = surfacePos.m_6625_(2);
        boolean sturdy1 = world.m_8055_(below1).m_60783_((BlockGetter)world, below1, Direction.UP);
        boolean sturdy2 = world.m_8055_(below2).m_60783_((BlockGetter)world, below2, Direction.UP);
        if (!sturdy1 && !sturdy2) {
            BlockPos fillStart;
            BlockPos cursor = below2;
            BlockPos base = null;
            for (int depth = 0; cursor.m_123342_() > world.m_141937_() && depth < MAX_CAUSEWAY_DEPTH; ++depth) {
                if (world.m_8055_(cursor).m_60783_((BlockGetter)world, cursor, Direction.UP)) {
                    base = cursor;
                    break;
                }
                cursor = cursor.m_7495_();
            }
            BlockPos blockPos = fillStart = base != null ? base.m_7494_() : below1.m_6625_(Math.min(MAX_CAUSEWAY_DEPTH - 1, Math.max(0, below1.m_123342_() - world.m_141937_())));
            if (fillStart.m_123342_() < world.m_141937_()) {
                fillStart = new BlockPos(fillStart.m_123341_(), world.m_141937_(), fillStart.m_123343_());
            }
            BlockPos pos = fillStart;
            while (pos.m_123342_() <= below1.m_123342_()) {
                world.m_7731_(pos, chosen, 3);
                pos = pos.m_7494_();
            }
        } else {
            world.m_7731_(below1, chosen, 3);
        }
        AboveColumnClearer.clearAboveColumn(world, surfacePos, cfg);
        BlockPos belowPos1 = surfacePos.m_6625_(2);
        BlockState belowState1 = world.m_8055_(belowPos1);
        if (belowState1.m_60713_(Blocks.f_50440_)) {
            world.m_7731_(belowPos1, Blocks.f_50493_.m_49966_(), 3);
        }
    }
}

