/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.types;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.shiroha233.roadweaver.features.decoration.base.OrientedDecoration;
import net.shiroha233.roadweaver.features.decoration.material.wood.BiomeWoodAware;
import net.shiroha233.roadweaver.features.decoration.material.wood.WoodTrapdoorMapper;
import net.shiroha233.roadweaver.helpers.Records;

public class LamppostDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private Records.WoodAssets wood;

    public LamppostDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world) {
        super(pos, direction, world);
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        this.placeLampStructure(basePos, world);
    }

    private void placeLampStructure(BlockPos pos, WorldGenLevel world) {
        world.m_7731_(pos, Blocks.f_50222_.m_49966_(), 3);
        world.m_7731_(pos.m_6630_(1), Blocks.f_50609_.m_49966_(), 3);
        world.m_7731_(pos.m_6630_(2), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(3), this.wood.fence().m_49966_(), 3);
        world.m_7731_(pos.m_6630_(4), Blocks.f_50609_.m_49966_(), 3);
        BlockPos lampPos = pos.m_6630_(5);
        world.m_7731_(lampPos, Blocks.f_50261_.m_49966_(), 3);
        world.m_7731_(lampPos.m_7494_(), (BlockState)Blocks.f_50329_.m_49966_().m_61124_((Property)BlockStateProperties.f_61441_, (Comparable)Boolean.valueOf(true)), 3);
        Block trap = WoodTrapdoorMapper.trapdoorForWood(this.wood);
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos tpos = lampPos.m_121945_(dir);
            BlockState st = (BlockState)((BlockState)((BlockState)trap.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir)).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)Half.TOP);
            if (st.m_61138_((Property)BlockStateProperties.f_61362_)) {
                st = (BlockState)st.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
            }
            world.m_7731_(tpos, st, 3);
        }
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

