/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.bridge;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;

public final class BridgeRangeCalculator {
    private BridgeRangeCalculator() {
    }

    /*
     * WARNING - void declaration
     */
    public static RangeResult compute(List<BlockPos> middlePositions, List<Records.RoadSpan> spans) {
        int n = middlePositions.size();
        boolean[] isBridge = new boolean[n];
        ArrayList<Object> bridgeRanges = new ArrayList<int[]>();
        ModConfig cfg = ConfigService.get();
        int minLength = Math.max(1, cfg.bridgeMinLength());
        int mergeGap = Math.max(1, cfg.bridgeMergeGap());
        if (spans != null) {
            void var9_10;
            HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
            boolean bl = false;
            while (var9_10 < n) {
                indexMap.put(middlePositions.get((int)var9_10).m_121878_(), (int)var9_10);
                ++var9_10;
            }
            for (Records.RoadSpan sp : spans) {
                if (sp.type() != Records.SpanType.BRIDGE) continue;
                Integer si = (Integer)indexMap.get(sp.start().m_121878_());
                Integer ei = (Integer)indexMap.get(sp.end().m_121878_());
                if (si == null || ei == null) continue;
                int a = Math.max(0, Math.min(si, ei));
                int b = Math.min(n - 1, Math.max(si, ei));
                bridgeRanges.add(new int[]{a, b});
            }
        }
        if (!bridgeRanges.isEmpty()) {
            void var9_13;
            bridgeRanges.sort(Comparator.comparingInt(o -> o[0]));
            ArrayList<void> merged = new ArrayList<void>();
            int[] nArray = (int[])bridgeRanges.get(0);
            for (int idx = 1; idx < bridgeRanges.size(); ++idx) {
                int[] nxt = (int[])bridgeRanges.get(idx);
                if (nxt[0] <= var9_13[1] + mergeGap) {
                    var9_13[1] = Math.max((int)var9_13[1], nxt[1]);
                    continue;
                }
                merged.add(var9_13);
                int[] nArray2 = nxt;
            }
            merged.add(var9_13);
            ArrayList<int[]> filtered = new ArrayList<int[]>();
            for (int[] r : merged) {
                int len = r[1] - r[0] + 1;
                if (len < minLength) continue;
                filtered.add(r);
            }
            bridgeRanges = filtered;
        }
        for (int[] nArray : bridgeRanges) {
            for (int k = nArray[0]; k <= nArray[1]; ++k) {
                isBridge[k] = true;
            }
        }
        return new RangeResult(isBridge, bridgeRanges);
    }

    public record RangeResult(boolean[] isBridge, List<int[]> mergedRanges) {
    }
}

