/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.material.surface.BiomeRoadMaterialSelector;
import net.shiroha233.roadweaver.features.decoration.system.SurfacePlacementUtil;
import net.shiroha233.roadweaver.features.roadlogic.surface.RoadHeightInterpolator;
import net.shiroha233.roadweaver.helpers.Records;

public final class SegmentPaver {
    private SegmentPaver() {
    }

    public static void paveSegment(WorldGenLevel world, Records.RoadSegmentPlacement seg, int segmentIndex, List<BlockPos> centers, int[] targetY, int roadType, List<BlockState> materials, List<BlockState> slabMaterials, RandomSource random, ModConfig cfg) {
        List<BlockPos> positions = seg.positions();
        if (positions.isEmpty()) {
            return;
        }
        int[] heights = RoadHeightInterpolator.batchInterpolate(positions, segmentIndex, centers, targetY);
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos widthBlock = positions.get(i);
            int y = heights[i];
            BlockPos pos = new BlockPos(widthBlock.m_123341_(), y, widthBlock.m_123343_());
            List<BlockState> baseMats = roadType == 1 ? BiomeRoadMaterialSelector.forBiome(world, pos) : materials;
            SurfacePlacementUtil.placeOnSurface(world, pos, baseMats, 0, random, cfg);
            if (roadType != 0 || slabMaterials == null || slabMaterials.isEmpty() || !SegmentPaver.shouldPlaceSlab(widthBlock.m_123341_(), widthBlock.m_123343_(), y, centers, targetY)) continue;
            BlockState slabState = slabMaterials.get(random.m_188503_(slabMaterials.size()));
            if (slabState.m_60734_() instanceof SlabBlock) {
                slabState = (BlockState)slabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM);
            }
            world.m_7731_(pos, slabState, 3);
        }
    }

    private static boolean shouldPlaceSlab(int x, int z, int currentY, List<BlockPos> centers, int[] targetY) {
        int yAhead = RoadHeightInterpolator.getInterpolatedY(x + 1, z, centers, targetY);
        int yBehind = RoadHeightInterpolator.getInterpolatedY(x - 1, z, centers, targetY);
        int yLeft = RoadHeightInterpolator.getInterpolatedY(x, z + 1, centers, targetY);
        int yRight = RoadHeightInterpolator.getInterpolatedY(x, z - 1, centers, targetY);
        boolean needsSlabX = yAhead > currentY && yBehind >= currentY || yBehind > currentY && yAhead >= currentY;
        boolean needsSlabZ = yLeft > currentY && yRight >= currentY || yRight > currentY && yLeft >= currentY;
        return needsSlabX || needsSlabZ;
    }
}

