/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.search.StructurePredictor;

public final class StructureRoadOffsetService {
    private static final int MATCH_TOLERANCE_BLOCKS = 16;

    private StructureRoadOffsetService() {
    }

    @Deprecated
    public static BlockPos adjustEndpoint(ServerLevel level, BlockPos endpoint, BlockPos otherEnd) {
        return endpoint;
    }

    public static List<Records.RoadSegmentPlacement> trimPathNearStructure(ServerLevel level, List<Records.RoadSegmentPlacement> segments, BlockPos rawStart, BlockPos rawEnd) {
        long distSq;
        long dz;
        long dx;
        BlockPos pos;
        int i;
        long offsetSq;
        if (segments == null || segments.size() < 3) {
            return segments;
        }
        if (!Level.f_46428_.equals(level.m_46472_())) {
            return segments;
        }
        int startOffset = StructureRoadOffsetService.getOffsetBlocksForEndpoint(level, rawStart);
        int endOffset = StructureRoadOffsetService.getOffsetBlocksForEndpoint(level, rawEnd);
        if (startOffset <= 0 && endOffset <= 0) {
            return segments;
        }
        int n = segments.size();
        int trimStart = 0;
        int trimEnd = n;
        if (startOffset > 0) {
            offsetSq = (long)startOffset * (long)startOffset;
            for (i = 0; i < n; ++i) {
                pos = segments.get(i).middlePos();
                dx = (long)pos.m_123341_() - (long)rawStart.m_123341_();
                distSq = dx * dx + (dz = (long)pos.m_123343_() - (long)rawStart.m_123343_()) * dz;
                if (distSq < offsetSq) continue;
                trimStart = i;
                break;
            }
        }
        if (endOffset > 0) {
            offsetSq = (long)endOffset * (long)endOffset;
            for (i = n - 1; i >= 0; --i) {
                pos = segments.get(i).middlePos();
                dx = (long)pos.m_123341_() - (long)rawEnd.m_123341_();
                distSq = dx * dx + (dz = (long)pos.m_123343_() - (long)rawEnd.m_123343_()) * dz;
                if (distSq < offsetSq) continue;
                trimEnd = i + 1;
                break;
            }
        }
        if (trimStart >= trimEnd || trimEnd - trimStart < 3) {
            int mid = n / 2;
            trimStart = Math.max(0, mid - 2);
            trimEnd = Math.min(n, mid + 3);
        }
        return new ArrayList<Records.RoadSegmentPlacement>(segments.subList(trimStart, trimEnd));
    }

    public static int getOffsetBlocksForEndpoint(ServerLevel level, BlockPos endpoint) {
        StructureCategory cat = StructureRoadOffsetService.detectCategory(level, endpoint);
        int configOffset = ConfigService.get().structureRoadOffset();
        return switch (cat) {
            case StructureCategory.VILLAGE -> configOffset;
            default -> 0;
        };
    }

    private static StructureCategory detectCategory(ServerLevel level, BlockPos endpoint) {
        int cz;
        if (!Level.f_46428_.equals(level.m_46472_())) {
            return StructureCategory.UNKNOWN;
        }
        int cx = endpoint.m_123341_() >> 4;
        List<Records.StructureInfo> infos = StructurePredictor.predictOverworldStructuresInRect(level, cx, cz = endpoint.m_123343_() >> 4, cx, cz, true, List.of("#minecraft:village"), List.of());
        if (infos == null || infos.isEmpty()) {
            return StructureCategory.UNKNOWN;
        }
        long tol2 = 256L;
        for (Records.StructureInfo info : infos) {
            long dz;
            BlockPos p = info.pos();
            long dx = (long)p.m_123341_() - (long)endpoint.m_123341_();
            long d2 = dx * dx + (dz = (long)p.m_123343_() - (long)endpoint.m_123343_()) * dz;
            if (d2 > tol2) continue;
            return StructureCategory.VILLAGE;
        }
        return StructureCategory.UNKNOWN;
    }

    private static enum StructureCategory {
        VILLAGE,
        OTHER,
        UNKNOWN;

    }
}

