/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.surface;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.shiroha233.roadweaver.config.ModConfig;

public final class RoadTerrainAdapter {
    private RoadTerrainAdapter() {
    }

    public static void adapt(WorldGenLevel level, BlockPos middle, int width, int targetY, RandomSource random, ModConfig cfg) {
        int halfWidth = (width + 1) / 2;
        int bankWidth = 3;
        int scanRadius = halfWidth + bankWidth;
        int cx = middle.m_123341_();
        int cz = middle.m_123343_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                int fillTopY;
                double desiredY;
                int surfaceY;
                double distSq = (double)dx * (double)dx + (double)dz * (double)dz;
                double dist = Math.sqrt(distSq);
                if (dist > (double)scanRadius) continue;
                int x = cx + dx;
                int z = cz + dz;
                boolean isRoadSurface = dist <= (double)halfWidth;
                double edgeDist = dist - (double)halfWidth;
                if (edgeDist < 0.0) {
                    edgeDist = 0.0;
                }
                if (edgeDist > (double)bankWidth && !isRoadSurface || targetY - 1 <= (surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z))) continue;
                double targetBelowRoad = targetY - 1;
                if (isRoadSurface) {
                    desiredY = targetBelowRoad;
                } else {
                    double t;
                    double d = t = bankWidth <= 0 ? 1.0 : edgeDist / (double)bankWidth;
                    if (t < 0.0) {
                        t = 0.0;
                    }
                    if (t > 1.0) {
                        t = 1.0;
                    }
                    double s = t * t * (3.0 - 2.0 * t);
                    desiredY = targetBelowRoad * (1.0 - s) + (double)surfaceY * s;
                }
                if (desiredY >= (double)targetY) {
                    desiredY = targetY - 1;
                }
                if ((fillTopY = (int)Math.floor(desiredY)) <= surfaceY) continue;
                cursor.m_122178_(x, surfaceY - 1, z);
                BlockState topState = level.m_8055_((BlockPos)cursor);
                if (topState.m_60795_() || topState.m_60819_().m_76170_()) {
                    topState = Blocks.f_50493_.m_49966_();
                }
                BlockState innerFill = topState;
                BlockState surfaceFill = topState;
                if (topState.m_60713_(Blocks.f_50440_) || topState.m_60713_(Blocks.f_50493_)) {
                    innerFill = Blocks.f_50493_.m_49966_();
                    surfaceFill = Blocks.f_50440_.m_49966_();
                }
                for (int y = surfaceY; y <= fillTopY; ++y) {
                    cursor.m_142448_(y);
                    BlockState cur = level.m_8055_((BlockPos)cursor);
                    if (!cur.m_247087_()) continue;
                    if (y == fillTopY && !isRoadSurface) {
                        level.m_7731_((BlockPos)cursor, surfaceFill, 2);
                        continue;
                    }
                    level.m_7731_((BlockPos)cursor, innerFill, 2);
                }
            }
        }
    }
}

