/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.search;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.shiroha233.roadweaver.helpers.Records;

public final class StructureVerificationService {
    private StructureVerificationService() {
    }

    public static List<Records.StructureInfo> verifyPredictedStructures(ServerLevel level, List<Records.StructureInfo> predicted) {
        ChunkScanAccess scanAccess;
        if (predicted == null || predicted.isEmpty()) {
            return List.of();
        }
        ServerChunkCache source = level.m_7726_();
        if (!(source instanceof ServerChunkCache)) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        ServerChunkCache chunkCache = source;
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        try {
            scanAccess = chunkCache.m_196555_();
        }
        catch (Throwable t) {
            return new ArrayList<Records.StructureInfo>(predicted);
        }
        RegistryAccess registryAccess = level.m_9598_();
        ChunkGenerator generator = chunkCache.m_8481_();
        RandomState randomState = chunkCache.m_214994_();
        BiomeSource biomeSource = generator.m_62218_();
        long seed = level.m_7328_();
        StructureCheck checker = new StructureCheck(scanAccess, registryAccess, server.m_236738_(), level.m_46472_(), generator, randomState, (LevelHeightAccessor)level, biomeSource, seed, server.m_129933_());
        Registry structureRegistry = registryAccess.m_175515_(Registries.f_256944_);
        ArrayList<Records.StructureInfo> result = new ArrayList<Records.StructureInfo>();
        for (Records.StructureInfo info : predicted) {
            StructureCheckResult checkResult;
            String idStr = info.structureId();
            if (idStr == null || idStr.isEmpty()) {
                result.add(info);
                continue;
            }
            ResourceLocation rl = ResourceLocation.m_135820_((String)idStr);
            if (rl == null) {
                result.add(info);
                continue;
            }
            Structure structure = (Structure)structureRegistry.m_7745_(rl);
            if (structure == null) {
                result.add(info);
                continue;
            }
            ChunkPos chunkPos = new ChunkPos(info.pos().m_123341_() >> 4, info.pos().m_123343_() >> 4);
            try {
                checkResult = checker.m_226729_(chunkPos, structure, false);
            }
            catch (Throwable t) {
                result.add(info);
                continue;
            }
            if (checkResult == StructureCheckResult.START_PRESENT) {
                result.add(info);
                continue;
            }
            if (checkResult != StructureCheckResult.CHUNK_LOAD_NEEDED) continue;
            result.add(info);
        }
        return result;
    }
}

