/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.pipeline;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.model.StructureInstance;
import net.shiroha233.roadweaver.structures.roadside.BeardedTerracePlacer;

public final class StructurePlacer {
    private static final int DEFAULT_TERRACE_BUFFER = 2;
    private static final int DEFAULT_TERRACE_TRANSITION = 4;

    private StructurePlacer() {
    }

    public static StructureInstance place(ServerLevel level, StructureBlueprint bp, ResourceLocation variantTemplateId, BlockPos anchor, Rotation rotation, Mirror mirror, AABB preBounds, BlendProfile blend) {
        ResourceLocation id = StructurePlacer.normalizeTemplateId(variantTemplateId);
        StructureTemplateManager mgr = level.m_7654_().m_236738_();
        Optional opt = mgr.m_230407_(id);
        if (opt.isEmpty()) {
            opt = mgr.m_230407_(variantTemplateId);
        }
        if (opt.isEmpty()) {
            AABB b = preBounds != null ? preBounds : new AABB(anchor).m_82377_(8.0, 5.0, 8.0);
            return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.m_46472_().m_135782_(), anchor, b, level.m_46467_());
        }
        StructureTemplate tpl = (StructureTemplate)opt.get();
        Vec3i raw = tpl.m_163801_();
        Vec3i size = StructurePlacer.rotatedSize(raw, rotation);
        BlockPos min = anchor;
        BlockPos max = anchor.m_7918_(size.m_123341_() - 1, size.m_123342_() - 1, size.m_123343_() - 1);
        AABB bounds = new AABB(min, max);
        if (blend != null) {
            int centerX = (min.m_123341_() + max.m_123341_()) / 2;
            int centerZ = (min.m_123343_() + max.m_123343_()) / 2;
            int targetY = min.m_123342_();
            int structureRadius = Math.max(size.m_123341_(), size.m_123343_()) / 2;
            int innerRadius = structureRadius + 2;
            int outerRadius = innerRadius + Math.max(8, blend.ringOuter() - blend.ringInner());
            BeardedTerracePlacer.buildTerraceForLargeStructure((LevelAccessor)level, centerX, centerZ, targetY, innerRadius, outerRadius, level.m_213780_());
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror);
        tpl.m_230328_((ServerLevelAccessor)level, anchor, anchor, settings, level.m_213780_(), 2);
        return new StructureInstance(UUID.randomUUID(), bp.id(), id, level.m_46472_().m_135782_(), anchor, bounds, level.m_46467_());
    }

    private static ResourceLocation normalizeTemplateId(ResourceLocation in) {
        String path = in.m_135815_();
        if (path.startsWith("structures/")) {
            return new ResourceLocation(in.m_135827_(), path.substring("structures/".length()));
        }
        return in;
    }

    private static Vec3i rotatedSize(Vec3i s, Rotation r) {
        return switch (r) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> s;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(s.m_123343_(), s.m_123342_(), s.m_123341_());
        };
    }

    public static boolean placeSimple(WorldGenLevel world, ServerLevel server, ResourceLocation templateId, BlockPos anchor, Rotation rotation, boolean withTerrace, boolean noBasement, RandomSource random) {
        StructureTemplateManager mgr = server.m_215082_();
        Optional<StructureTemplate> opt = StructurePlacer.loadTemplate(mgr, templateId);
        if (opt.isEmpty()) {
            return false;
        }
        StructureTemplate tpl = opt.get();
        Vec3i size = tpl.m_163808_(rotation);
        if (withTerrace) {
            int targetY = noBasement ? anchor.m_123342_() - 1 : anchor.m_123342_();
            StructurePlacer.buildTerraceInternal(world, anchor, size, targetY, random);
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74392_(false);
        tpl.m_230328_((ServerLevelAccessor)world, anchor, anchor, settings, random, 2);
        return true;
    }

    public static boolean placeSimple(ServerLevel level, ResourceLocation templateId, BlockPos anchor, Rotation rotation, boolean withTerrace, boolean noBasement) {
        StructureTemplateManager mgr = level.m_215082_();
        Optional<StructureTemplate> opt = StructurePlacer.loadTemplate(mgr, templateId);
        if (opt.isEmpty()) {
            return false;
        }
        StructureTemplate tpl = opt.get();
        Vec3i size = tpl.m_163808_(rotation);
        if (withTerrace) {
            int targetY = noBasement ? anchor.m_123342_() - 1 : anchor.m_123342_();
            int centerX = anchor.m_123341_() + size.m_123341_() / 2;
            int centerZ = anchor.m_123343_() + size.m_123343_() / 2;
            int structureRadius = Math.max(size.m_123341_(), size.m_123343_()) / 2;
            int innerRadius = structureRadius + 2;
            int outerRadius = innerRadius + 4;
            BeardedTerracePlacer.buildTerraceForLargeStructure((LevelAccessor)level, centerX, centerZ, targetY, innerRadius, outerRadius, level.m_213780_());
        }
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74392_(false);
        tpl.m_230328_((ServerLevelAccessor)level, anchor, anchor, settings, level.m_213780_(), 2);
        return true;
    }

    private static Optional<StructureTemplate> loadTemplate(StructureTemplateManager mgr, ResourceLocation templateId) {
        Optional opt = mgr.m_230407_(templateId);
        if (opt.isPresent()) {
            return opt;
        }
        ResourceLocation altId = new ResourceLocation(templateId.m_135827_(), "structures/" + templateId.m_135815_());
        opt = mgr.m_230407_(altId);
        if (opt.isPresent()) {
            return opt;
        }
        String path = templateId.m_135815_();
        if (path.startsWith("structures/")) {
            ResourceLocation cleanId = new ResourceLocation(templateId.m_135827_(), path.substring("structures/".length()));
            return mgr.m_230407_(cleanId);
        }
        return Optional.empty();
    }

    private static void buildTerraceInternal(WorldGenLevel world, BlockPos anchor, Vec3i size, int targetY, RandomSource random) {
        BeardedTerracePlacer.buildTerrace(world, new BlockPos(anchor.m_123341_(), targetY + 1, anchor.m_123343_()), size, random);
    }
}

