/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public final class BeardedTerracePlacer {
    private static final int TRANSITION_RADIUS = 4;
    private static final double MIN_CONTRIBUTION = 0.05;

    private BeardedTerracePlacer() {
    }

    public static void buildTerrace(WorldGenLevel world, BlockPos anchor, Vec3i size, RandomSource random) {
        int centerX = anchor.m_123341_() + size.m_123341_() / 2;
        int centerZ = anchor.m_123343_() + size.m_123343_() / 2;
        int targetY = anchor.m_123342_() - 1;
        double innerRadius = (double)Math.max(size.m_123341_(), size.m_123343_()) / 2.0 + 0.5;
        double outerRadius = innerRadius + 4.0;
        int searchRadius = (int)Math.ceil(outerRadius) + 1;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int finalY;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > outerRadius) continue;
                int groundY = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) - 1;
                if (dist <= innerRadius) {
                    if (groundY >= targetY) continue;
                    BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, targetY, random);
                    continue;
                }
                double t = (dist - innerRadius) / (outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05 || (finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution))) <= groundY) continue;
                BeardedTerracePlacer.fillColumnUp(world, x, z, groundY, finalY, random);
            }
        }
        BeardedTerracePlacer.fixExposedDirt(world, centerX, centerZ, searchRadius, targetY);
    }

    public static void buildTerraceForLargeStructure(LevelAccessor level, int centerX, int centerZ, int targetY, int innerRadius, int outerRadius, RandomSource random) {
        int searchRadius = outerRadius + 2;
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                int finalY;
                double dx = x - centerX;
                double dz = z - centerZ;
                double dist = Math.sqrt(dx * dx + dz * dz);
                if (dist > (double)outerRadius) continue;
                int groundY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) - 1;
                if (dist <= (double)innerRadius) {
                    if (groundY >= targetY) continue;
                    BeardedTerracePlacer.fillColumnUpGeneric(level, x, z, groundY, targetY, random);
                    continue;
                }
                double t = (dist - (double)innerRadius) / (double)(outerRadius - innerRadius);
                double smooth = BeardedTerracePlacer.smoothstep(t);
                double contribution = 1.0 - smooth;
                if (contribution < 0.05 || (finalY = (int)Math.round((double)targetY * contribution + (double)groundY * (1.0 - contribution))) <= groundY) continue;
                BeardedTerracePlacer.fillColumnUpGeneric(level, x, z, groundY, finalY, random);
            }
        }
        BeardedTerracePlacer.fixExposedDirtGeneric(level, centerX, centerZ, searchRadius, targetY);
    }

    private static void fillColumnUpGeneric(LevelAccessor level, int x, int z, int groundY, int targetY, RandomSource random) {
        BlockState surfaceState = level.m_8055_(new BlockPos(x, groundY, z));
        BlockState fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        BlockState topState = BeardedTerracePlacer.getSuitableTopState(surfaceState);
        for (int y = groundY + 1; y <= targetY; ++y) {
            BlockState state = y == targetY ? topState : fillState;
            level.m_7731_(new BlockPos(x, y, z), state, 3);
        }
    }

    private static void fixExposedDirtGeneric(LevelAccessor level, int centerX, int centerZ, int radius, int baseY) {
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                for (int y = baseY; y >= baseY - 5; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if ((state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50546_)) && BeardedTerracePlacer.isExposedToAirGeneric(level, pos)) {
                        level.m_7731_(pos, Blocks.f_50440_.m_49966_(), 3);
                    }
                    if (!state.m_60713_(Blocks.f_50127_) || !BeardedTerracePlacer.isExposedToAirGeneric(level, pos)) continue;
                    level.m_7731_(pos, Blocks.f_50127_.m_49966_(), 3);
                }
            }
        }
    }

    private static boolean isExposedToAirGeneric(LevelAccessor level, BlockPos pos) {
        if (level.m_8055_(pos.m_7494_()).m_60795_()) {
            return true;
        }
        return level.m_8055_(pos.m_122012_()).m_60795_() || level.m_8055_(pos.m_122019_()).m_60795_() || level.m_8055_(pos.m_122029_()).m_60795_() || level.m_8055_(pos.m_122024_()).m_60795_();
    }

    private static void fixExposedDirt(WorldGenLevel world, int centerX, int centerZ, int radius, int baseY) {
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                for (int y = baseY; y >= baseY - 5; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    if ((state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50546_)) && BeardedTerracePlacer.isExposedToAir(world, pos)) {
                        world.m_7731_(pos, Blocks.f_50440_.m_49966_(), 2);
                    }
                    if (!state.m_60713_(Blocks.f_50127_) || !BeardedTerracePlacer.isExposedToAir(world, pos)) continue;
                    world.m_7731_(pos, Blocks.f_50127_.m_49966_(), 2);
                }
            }
        }
    }

    private static boolean isExposedToAir(WorldGenLevel world, BlockPos pos) {
        if (world.m_8055_(pos.m_7494_()).m_60795_()) {
            return true;
        }
        return world.m_8055_(pos.m_122012_()).m_60795_() || world.m_8055_(pos.m_122019_()).m_60795_() || world.m_8055_(pos.m_122029_()).m_60795_() || world.m_8055_(pos.m_122024_()).m_60795_();
    }

    private static double smoothstep(double t) {
        t = Mth.m_14008_((double)t, (double)0.0, (double)1.0);
        return t * t * (3.0 - 2.0 * t);
    }

    private static void fillColumnUp(WorldGenLevel world, int x, int z, int groundY, int targetY, RandomSource random) {
        BlockState surfaceState = world.m_8055_(new BlockPos(x, groundY, z));
        BlockState fillState = BeardedTerracePlacer.getSuitableFillState(surfaceState);
        BlockState topState = BeardedTerracePlacer.getSuitableTopState(surfaceState);
        for (int y = groundY + 1; y <= targetY; ++y) {
            BlockState state = y == targetY ? topState : fillState;
            world.m_7731_(new BlockPos(x, y, z), state, 2);
        }
    }

    private static BlockState getSuitableFillState(BlockState surface) {
        if (surface.m_60713_(Blocks.f_50440_) || surface.m_60713_(Blocks.f_50493_) || surface.m_60713_(Blocks.f_50599_) || surface.m_60713_(Blocks.f_50195_)) {
            return Blocks.f_50493_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_49992_)) {
            return Blocks.f_49992_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_49993_)) {
            return Blocks.f_49993_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_49994_)) {
            return Blocks.f_49994_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_50069_) || surface.m_60713_(Blocks.f_50334_) || surface.m_60713_(Blocks.f_50228_) || surface.m_60713_(Blocks.f_50122_)) {
            return Blocks.f_50069_.m_49966_();
        }
        return Blocks.f_50493_.m_49966_();
    }

    private static BlockState getSuitableTopState(BlockState surface) {
        if (surface.m_60713_(Blocks.f_50440_)) {
            return Blocks.f_50440_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_50599_)) {
            return Blocks.f_50599_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_50195_)) {
            return Blocks.f_50195_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_49992_)) {
            return Blocks.f_49992_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_49993_)) {
            return Blocks.f_49993_.m_49966_();
        }
        if (surface.m_60713_(Blocks.f_49994_)) {
            return Blocks.f_49994_.m_49966_();
        }
        return Blocks.f_50440_.m_49966_();
    }
}

