/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.SpawnRule;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.api.StructureConnector;
import net.shiroha233.roadweaver.structures.api.StructureVariant;
import net.shiroha233.roadweaver.structures.roadside.RoadsideType;

public final class RoadsideBlueprints {
    private static final Map<RoadsideType, StructureBlueprint> CACHE = new EnumMap<RoadsideType, StructureBlueprint>(RoadsideType.class);
    private static volatile boolean initialized = false;

    private RoadsideBlueprints() {
    }

    public static synchronized void registerAll() {
        if (initialized) {
            return;
        }
        for (RoadsideType type : RoadsideType.values()) {
            StructureBlueprint bp = RoadsideBlueprints.createBlueprint(type);
            CACHE.put(type, bp);
            StructureSystem.registerBlueprint(bp);
        }
        initialized = true;
    }

    public static StructureBlueprint get(RoadsideType type) {
        if (!initialized) {
            RoadsideBlueprints.registerAll();
        }
        return CACHE.get((Object)type);
    }

    public static ResourceLocation blueprintId(RoadsideType type) {
        return new ResourceLocation("roadweaver", "roadside_" + type.name().toLowerCase());
    }

    private static StructureBlueprint createBlueprint(RoadsideType type) {
        ResourceLocation id = RoadsideBlueprints.blueprintId(type);
        ResourceLocation templateId = type.templateId();
        Vec3i sizeHint = type.sizeHint();
        List<StructureVariant> variants = Collections.singletonList(new StructureVariant(templateId, type.weight(), true));
        List<StructureConnector> connectors = Collections.emptyList();
        BlendProfile blend = null;
        SpawnRule rule = RoadsideBlueprints.createSpawnRule(type);
        return new StructureBlueprint(id, variants, connectors, sizeHint, blend, rule);
    }

    private static SpawnRule createSpawnRule(RoadsideType type) {
        int spacing;
        return new SpawnRule(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), spacing, switch (type) {
            case RoadsideType.BENCH -> {
                spacing = 64;
                yield 16;
            }
            case RoadsideType.CAMPFIRE -> {
                spacing = 96;
                yield 24;
            }
            default -> {
                spacing = 48;
                yield 12;
            }
        }, -64, 320, 0, 0);
    }

    public static synchronized void clearCache() {
        CACHE.clear();
        initialized = false;
    }
}

