/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.pipeline.StructurePlacer;
import net.shiroha233.roadweaver.structures.roadside.RoadsideBlueprints;
import net.shiroha233.roadweaver.structures.roadside.RoadsideType;

public final class RoadsideStructureService {
    private static final int BASE_SIDE_OFFSET = 8;
    private static final int RANDOM_OFFSET_RANGE = 4;

    private RoadsideStructureService() {
    }

    public static boolean tryPlace(WorldGenLevel world, ServerLevel server, BlockPos middlePos, BlockPos prevPos, BlockPos nextPos, int roadWidth, int segmentIndex, RandomSource random, ModConfig cfg) {
        int dz;
        if (!cfg.roadsideStructuresEnabled()) {
            return false;
        }
        int interval = Math.max(1, cfg.roadsideStructureInterval());
        if (segmentIndex % interval != 0) {
            return false;
        }
        float chance = Math.max(0.0f, Math.min(1.0f, cfg.roadsideStructureChance()));
        if (random.m_188501_() > chance) {
            return false;
        }
        int dx = nextPos.m_123341_() - prevPos.m_123341_();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.m_123343_() - prevPos.m_123343_()) * (double)dz);
        if (len < 0.001) {
            return false;
        }
        double dirX = (double)dx / len;
        double dirZ = (double)dz / len;
        double orthoX = -dirZ;
        double orthoZ = dirX;
        boolean leftSide = random.m_188499_();
        double sideMultiplier = leftSide ? 1.0 : -1.0;
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = 8 + halfWidth + random.m_188503_(5);
        int placeX = middlePos.m_123341_() + (int)Math.round(orthoX * (double)sideOffset * sideMultiplier);
        int placeZ = middlePos.m_123343_() + (int)Math.round(orthoZ * (double)sideOffset * sideMultiplier);
        int placeY = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, placeX, placeZ);
        BlockPos placePos = new BlockPos(placeX, placeY, placeZ);
        int heightDiff = Math.abs(placeY - middlePos.m_123342_());
        if (heightDiff > 5) {
            return false;
        }
        RoadsideType type = RoadsideType.chooseWeighted(random);
        StructureBlueprint bp = RoadsideBlueprints.get(type);
        if (bp == null) {
            return false;
        }
        int minDist = bp.spawnRule().separation();
        if (StructureSystem.index(server).existsNear(placePos, minDist)) {
            return false;
        }
        Rotation rotation = RoadsideStructureService.calculateRotation(dirX, dirZ, leftSide, type.faceRoad());
        ResourceLocation templateId = type.templateId();
        return StructurePlacer.placeSimple(world, server, templateId, placePos, rotation, true, true, random);
    }

    public static void processSegments(WorldGenLevel world, ServerLevel server, List<BlockPos> middlePositions, int roadWidth, RandomSource random, ModConfig cfg, int startIndex, int endIndex) {
        if (middlePositions == null || middlePositions.size() < 5) {
            return;
        }
        int safeStart = Math.max(2, startIndex);
        int safeEnd = Math.min(middlePositions.size() - 3, endIndex);
        for (int i = safeStart; i < safeEnd; ++i) {
            BlockPos middle = middlePositions.get(i);
            BlockPos prev = middlePositions.get(i - 2);
            BlockPos next = middlePositions.get(i + 2);
            RoadsideStructureService.tryPlace(world, server, middle, prev, next, roadWidth, i, random, cfg);
        }
    }

    private static Rotation calculateRotation(double dirX, double dirZ, boolean leftSide, boolean faceRoad) {
        double absZ;
        if (!faceRoad) {
            return Rotation.NONE;
        }
        double absX = Math.abs(dirX);
        if (absX > (absZ = Math.abs(dirZ))) {
            if (leftSide) {
                return dirX > 0.0 ? Rotation.CLOCKWISE_180 : Rotation.NONE;
            }
            return dirX > 0.0 ? Rotation.NONE : Rotation.CLOCKWISE_180;
        }
        if (leftSide) {
            return dirZ > 0.0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
        }
        return dirZ > 0.0 ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
    }
}

