/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public enum RoadsideType {
    BENCH(new ResourceLocation("roadweaver", "roadside/roadside_bench"), new Vec3i(3, 2, 2), 10, true),
    CAMPFIRE(new ResourceLocation("roadweaver", "roadside/small_campfire"), new Vec3i(3, 3, 3), 8, false);

    private final ResourceLocation templateId;
    private final Vec3i sizeHint;
    private final int weight;
    private final boolean faceRoad;

    private RoadsideType(ResourceLocation templateId, Vec3i sizeHint, int weight, boolean faceRoad) {
        this.templateId = templateId;
        this.sizeHint = sizeHint;
        this.weight = weight;
        this.faceRoad = faceRoad;
    }

    public ResourceLocation templateId() {
        return this.templateId;
    }

    public Vec3i sizeHint() {
        return this.sizeHint;
    }

    public int weight() {
        return this.weight;
    }

    public boolean faceRoad() {
        return this.faceRoad;
    }

    public static RoadsideType chooseWeighted(RandomSource random) {
        int totalWeight = 0;
        for (RoadsideType type : RoadsideType.values()) {
            totalWeight += type.weight;
        }
        int roll = random.m_188503_(totalWeight);
        int cumulative = 0;
        for (RoadsideType type : RoadsideType.values()) {
            if (roll >= (cumulative += type.weight)) continue;
            return type;
        }
        return RoadsideType.values()[0];
    }
}

