/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client;

import java.util.ArrayList;
import java.util.List;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettlementRoadsClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    private static class_304 debugMapKey;

    public void onInitializeClient() {
        LOGGER.info("Initializing RoadWeaver Client (Fabric)...");
        debugMapKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.roadweaver.debug_map", 72, "category.roadweaver"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (debugMapKey.method_1436()) {
                SettlementRoadsClient.handleDebugMapKey(client);
            }
        });
    }

    private static void handleDebugMapKey(class_310 client) {
        if (client == null) {
            return;
        }
        if (client.field_1755 instanceof RoadDebugScreen) {
            client.method_1507(null);
            return;
        }
        if (client.method_1576() == null) {
            return;
        }
        class_3218 world = client.method_1576().method_30002();
        if (world == null) {
            return;
        }
        try {
            Records.StructureLocationData data = WorldDataProvider.getInstance().getStructureLocations(world);
            List<Records.StructureConnection> connections = WorldDataProvider.getInstance().getStructureConnections(world);
            List<Records.RoadData> roads = WorldDataProvider.getInstance().getRoadDataList(world);
            ArrayList<Records.StructureInfo> structureInfos = data != null ? new ArrayList<Records.StructureInfo>(data.structureInfos()) : new ArrayList();
            client.method_1507((class_437)new RoadDebugScreen(structureInfos, connections, roads));
        }
        catch (Exception e) {
            client.method_1507((class_437)new RoadDebugScreen(new ArrayList<Records.StructureInfo>(), new ArrayList<Records.StructureConnection>(), new ArrayList<Records.RoadData>()));
        }
    }
}

